/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.descriptors.data.UserExpressionData;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public final class EnumerationChildrenRenderer
extends ReferenceRenderer
implements ChildrenRenderer {
    @NonNls
    public static final String UNIQUE_ID = "EnumerationChildrenRenderer";
    private List<Pair<String, TextWithImports>> myChildren;
    @NonNls
    public static final String CHILDREN_EXPRESSION = "ChildrenExpression";
    @NonNls
    public static final String CHILD_NAME = "Name";

    public EnumerationChildrenRenderer() {
        this(new ArrayList<Pair<String, TextWithImports>>());
    }

    public EnumerationChildrenRenderer(List<Pair<String, TextWithImports>> children2) {
        this.myChildren = children2;
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public EnumerationChildrenRenderer clone() {
        return (EnumerationChildrenRenderer)super.clone();
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myChildren.clear();
        List children2 = element.getChildren(CHILDREN_EXPRESSION);
        for (Element item : children2) {
            String name = item.getAttributeValue(CHILD_NAME);
            TextWithImports text = DebuggerUtils.getInstance().readTextWithImports((Element)item.getChildren().get(0));
            this.myChildren.add((Pair<String, TextWithImports>)Pair.create((Object)name, (Object)text));
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        for (Pair<String, TextWithImports> pair : this.myChildren) {
            Element child = new Element(CHILDREN_EXPRESSION);
            child.setAttribute(CHILD_NAME, (String)pair.getFirst());
            child.addContent(DebuggerUtils.getInstance().writeTextWithImports((TextWithImports)pair.getSecond()));
            element.addContent(child);
        }
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        NodeManager nodeManager = builder.getNodeManager();
        NodeDescriptorFactory descriptorFactory = builder.getDescriptorManager();
        ArrayList<DebuggerTreeNode> children2 = new ArrayList<DebuggerTreeNode>();
        for (Pair<String, TextWithImports> pair : this.myChildren) {
            children2.add(nodeManager.createNode(descriptorFactory.getUserExpressionDescriptor(builder.getParentDescriptor(), new UserExpressionData((ValueDescriptorImpl)builder.getParentDescriptor(), this.getClassName(), (String)pair.getFirst(), (TextWithImports)pair.getSecond())), evaluationContext));
        }
        builder.setChildren(children2);
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        return ((ValueDescriptor)node.getDescriptor()).getDescriptorEvaluation(context);
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return this.myChildren.size() > 0;
    }

    public List<Pair<String, TextWithImports>> getChildren() {
        return this.myChildren;
    }

    public void setChildren(List<Pair<String, TextWithImports>> children2) {
        this.myChildren = children2;
    }
}

