/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.ImageObjectRenderer;
import com.intellij.debugger.ui.tree.render.ToStringBasedRenderer;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class GraphicsObjectRenderer
extends ToStringBasedRenderer
implements FullValueEvaluatorProvider {
    public GraphicsObjectRenderer(NodeRendererSettings rendererSettings) {
        super(rendererSettings, "Graphics", null, null);
        this.setClassName("sun.java2d.SunGraphics2D");
        this.setEnabled(true);
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(EvaluationContextImpl evaluationContext, ValueDescriptorImpl valueDescriptor) {
        try {
            ObjectReference value = (ObjectReference)valueDescriptor.getValue();
            Field surfaceField = ((ClassType)value.type()).fieldByName("surfaceData");
            if (surfaceField == null) {
                return null;
            }
            ObjectReference surfaceDataValue = (ObjectReference)value.getValue(surfaceField);
            if (surfaceDataValue == null) {
                return null;
            }
            Field imgField = ((ReferenceType)surfaceDataValue.type()).fieldByName("bufImg");
            if (imgField == null) {
                imgField = ((ReferenceType)surfaceDataValue.type()).fieldByName("offscreenImage");
            }
            if (imgField == null) {
                return null;
            }
            final Value bufImgValue = surfaceDataValue.getValue(imgField);
            Type type = bufImgValue.type();
            if (!(type instanceof ReferenceType) || !DebuggerUtils.instanceOf((Type)type, (String)"java.awt.Image")) {
                return null;
            }
            return new ImageObjectRenderer.IconPopupEvaluator(DebuggerBundle.message((String)"message.node.show.image", (Object[])new Object[0]), evaluationContext){

                @Override
                protected Icon getData() {
                    return ImageObjectRenderer.getIcon(this.getEvaluationContext(), bufImgValue, "imageToBytes");
                }
            };
        }
        catch (Exception exception) {
            return null;
        }
    }
}

