/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.selection;

import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.tools.DragTracker;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class NonResizeSelectionDecorator
extends ComponentDecorator {
    protected final Color myColor;
    private final int myLineWidth;
    private final BasicStroke myStroke;

    public NonResizeSelectionDecorator(Color color, int lineWidth) {
        this.myColor = color;
        this.myLineWidth = Math.max(lineWidth, 1);
        this.myStroke = this.myLineWidth > 1 ? new BasicStroke(this.myLineWidth) : null;
    }

    @Override
    public InputTool findTargetTool(DecorationLayer layer, RadComponent component, int x, int y) {
        Rectangle bounds = this.getBounds(layer, component);
        int lineWidth = Math.max(this.myLineWidth, 2);
        Rectangle top = new Rectangle(bounds.x, bounds.y, bounds.width, lineWidth);
        Rectangle bottom = new Rectangle(bounds.x, bounds.y + bounds.height - lineWidth, bounds.width, lineWidth);
        Rectangle left = new Rectangle(bounds.x, bounds.y, lineWidth, bounds.height);
        Rectangle right = new Rectangle(bounds.x + bounds.width - lineWidth, bounds.y, lineWidth, bounds.height);
        if (top.contains(x, y) || bottom.contains(x, y) || left.contains(x, y) || right.contains(x, y)) {
            return new DragTracker(component);
        }
        return null;
    }

    @Override
    protected void paint(DecorationLayer layer, Graphics2D g, RadComponent component) {
        g.setColor(this.myColor);
        if (this.myStroke != null) {
            g.setStroke(this.myStroke);
        }
        Rectangle bounds = this.getBounds(layer, component);
        g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    protected Rectangle getBounds(DecorationLayer layer, RadComponent component) {
        return component.getBounds(layer);
    }
}

