/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.model;

import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.ICaption;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.StaticDecorator;
import com.intellij.designer.designSurface.tools.DragTracker;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.designer.model.RadLayout;
import com.intellij.designer.model.RadLayoutData;
import com.intellij.designer.propertyTable.PropertyTable;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RadComponent
extends PropertiesContainer {
    private static final String ERROR_KEY = "Inspection.Errors";
    protected MetaModel myMetaModel;
    private RadComponent myParent;
    private RadLayout myLayout;
    private final Map<Object, Object> myClientProperties = new HashMap<Object, Object>();

    public MetaModel getMetaModel() {
        return this.myMetaModel;
    }

    public MetaModel getMetaModelForProperties() throws Exception {
        return this.myMetaModel;
    }

    public void setMetaModel(MetaModel metaModel) {
        this.myMetaModel = metaModel;
    }

    public RadComponent getRoot() {
        return this.myParent == null ? this : this.myParent.getRoot();
    }

    public final RadComponent getParent() {
        return this.myParent;
    }

    public final <T extends RadComponent> T getParent(Class<T> clazz) {
        return (T)this.myParent;
    }

    public final void setParent(RadComponent parent) {
        this.myParent = parent;
    }

    public List<RadComponent> getChildren() {
        return Collections.emptyList();
    }

    public Object[] getTreeChildren() {
        return this.getChildren().toArray();
    }

    public void add(@NotNull RadComponent component, @Nullable RadComponent insertBefore) {
        int index;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/designer/model/RadComponent", "add"));
        }
        component.setParent(this);
        List<RadComponent> children2 = this.getChildren();
        if (insertBefore == null) {
            index = children2.size();
            children2.add(component);
        } else {
            index = children2.indexOf(insertBefore);
            children2.add(index, component);
        }
        if (this.myLayout != null) {
            this.myLayout.addComponentToContainer(component, index);
        }
    }

    public void remove(@NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/designer/model/RadComponent", "remove"));
        }
        this.getChildren().remove(component);
        if (this.myLayout != null) {
            this.myLayout.removeComponentFromContainer(component);
        }
        component.setParent(null);
    }

    public void removeFromParent() {
        this.getParent().remove(this);
    }

    public boolean isBackground() {
        return false;
    }

    public boolean isSameType(@NotNull RadComponent other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/designer/model/RadComponent", "isSameType"));
        }
        return other.getClass() == this.getClass();
    }

    public Rectangle getBounds() {
        return null;
    }

    public Rectangle getBounds(Component relativeTo) {
        return null;
    }

    public Rectangle fromModel(@NotNull Component target, @NotNull Rectangle rectangle) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/designer/model/RadComponent", "fromModel"));
        }
        if (rectangle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rectangle", "com/intellij/designer/model/RadComponent", "fromModel"));
        }
        return null;
    }

    public Rectangle toModel(@NotNull Component source, @NotNull Rectangle rectangle) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/designer/model/RadComponent", "toModel"));
        }
        if (rectangle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rectangle", "com/intellij/designer/model/RadComponent", "toModel"));
        }
        return null;
    }

    public Point fromModel(@NotNull Component target, @NotNull Point point) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/designer/model/RadComponent", "fromModel"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/designer/model/RadComponent", "fromModel"));
        }
        return null;
    }

    public Point toModel(@NotNull Component source, @NotNull Point point) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/designer/model/RadComponent", "toModel"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/designer/model/RadComponent", "toModel"));
        }
        return null;
    }

    public Dimension fromModel(@NotNull Component target, @NotNull Dimension size) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/designer/model/RadComponent", "fromModel"));
        }
        if (size == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/designer/model/RadComponent", "fromModel"));
        }
        return null;
    }

    public Dimension toModel(@NotNull Component source, @NotNull Dimension size) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/designer/model/RadComponent", "toModel"));
        }
        if (size == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/designer/model/RadComponent", "toModel"));
        }
        return null;
    }

    public Point convertPoint(Component relativeFrom, int x, int y) {
        return null;
    }

    public InputTool getDragTracker(Point location, InputEvent event, boolean isTree) {
        return new DragTracker(this);
    }

    public void processDropOperation(OperationContext context) {
    }

    public void addStaticDecorators(List<StaticDecorator> decorators, List<RadComponent> selection) {
    }

    public void addSelectionActions(DesignerEditorPanel designer, DefaultActionGroup actionGroup, JComponent shortcuts, List<RadComponent> selection) {
    }

    @Nullable
    public ICaption getCaption() {
        return null;
    }

    public RadLayout getLayout() {
        return this.myLayout;
    }

    public void setLayout(@Nullable RadLayout layout) {
        this.myLayout = layout;
        if (this.myLayout != null) {
            this.myLayout.setContainer(this);
        }
    }

    @Nullable
    public RadLayoutData getLayoutData() {
        return null;
    }

    public List<Property> getProperties() {
        return Collections.emptyList();
    }

    public List<Property> getProperties(String key2) {
        return Collections.emptyList();
    }

    @Nullable
    public String getPropertyValue(String name) {
        if (this.getProperties() == null) {
            throw new NullPointerException("Component " + this + ", " + this.myLayout + ", " + this.myMetaModel.getTag() + ", " + this.myMetaModel.getTarget() + " without properties");
        }
        Property property = PropertyTable.findProperty(this.getProperties(), name);
        if (property != null) {
            try {
                return String.valueOf(property.getValue(this));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public List<Property> getInplaceProperties() throws Exception {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (this.myMetaModel != null) {
            List<Property> allProperties = this.getProperties();
            for (String name : this.myMetaModel.getInplaceProperties()) {
                Property property = PropertyTable.findProperty(allProperties, name);
                if (property == null) continue;
                properties.add(property);
            }
        }
        return properties;
    }

    public final <T> T getClientProperty(@NotNull String key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/designer/model/RadComponent", "getClientProperty"));
        }
        return (T)this.myClientProperties.get(key2);
    }

    public final <T> T extractClientProperty(@NotNull String key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/designer/model/RadComponent", "extractClientProperty"));
        }
        return (T)this.myClientProperties.remove(key2);
    }

    public final void setClientProperty(@NotNull Object key2, Object value) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/designer/model/RadComponent", "setClientProperty"));
        }
        this.myClientProperties.put(key2, value);
    }

    public void accept(RadComponentVisitor visitor, boolean forward) {
        if (visitor.visit(this)) {
            this.acceptChildren(visitor, forward);
            visitor.endVisit(this);
        }
    }

    public void acceptChildren(RadComponentVisitor visitor, boolean forward) {
        List<RadComponent> children2 = this.getChildrenForAccept(visitor);
        if (forward) {
            for (RadComponent child : children2) {
                child.accept(visitor, forward);
            }
        } else {
            int size = children2.size();
            for (int i = size - 1; i >= 0; --i) {
                children2.get(i).accept(visitor, forward);
            }
        }
    }

    protected List<RadComponent> getChildrenForAccept(RadComponentVisitor visitor) {
        return this.getChildren();
    }

    public boolean canDelete() {
        return this.myMetaModel == null || this.myMetaModel.canDelete();
    }

    public void delete() throws Exception {
    }

    public void copyTo(Element parentElement) throws Exception {
    }

    @Nullable
    public RadComponent morphingTo(MetaModel target) throws Exception {
        return null;
    }

    @Nullable
    public RadComponent wrapIn(MetaModel target) throws Exception {
        return null;
    }

    public static List<ErrorInfo> getError(RadComponent component) {
        List errorInfos = (List)component.getClientProperty(ERROR_KEY);
        return errorInfos == null ? Collections.emptyList() : errorInfos;
    }

    public static void addError(RadComponent component, ErrorInfo errorInfo) {
        ArrayList<ErrorInfo> errorInfos = (ArrayList<ErrorInfo>)component.getClientProperty(ERROR_KEY);
        if (errorInfos == null) {
            errorInfos = new ArrayList<ErrorInfo>();
            component.setClientProperty(ERROR_KEY, errorInfos);
        }
        errorInfos.add(errorInfo);
    }

    public static void clearErrors(RadComponent component) {
        component.accept(new RadComponentVisitor(){

            @Override
            public void endVisit(RadComponent component) {
                component.extractClientProperty(RadComponent.ERROR_KEY);
            }
        }, true);
    }

    @NotNull
    public static Map<RadComponent, List<RadComponent>> groupSiblings(@NotNull List<? extends RadComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/designer/model/RadComponent", "groupSiblings"));
        }
        HashMap<RadComponent, List<RadComponent>> siblingLists = new HashMap<RadComponent, List<RadComponent>>();
        if (components.isEmpty()) {
            HashMap<RadComponent, List<RadComponent>> hashMap = siblingLists;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/model/RadComponent", "groupSiblings"));
            }
            return hashMap;
        }
        if (components.size() == 1) {
            RadComponent component = components.get(0);
            siblingLists.put(component.getParent(), Collections.singletonList(component));
            HashMap<RadComponent, List<RadComponent>> hashMap = siblingLists;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/model/RadComponent", "groupSiblings"));
            }
            return hashMap;
        }
        for (RadComponent radComponent : components) {
            RadComponent parent = radComponent.getParent();
            ArrayList<RadComponent> children2 = (ArrayList<RadComponent>)siblingLists.get(parent);
            if (children2 == null) {
                children2 = new ArrayList<RadComponent>();
                siblingLists.put(parent, children2);
            }
            children2.add(radComponent);
        }
        HashMap<RadComponent, List<RadComponent>> hashMap = siblingLists;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/model/RadComponent", "groupSiblings"));
        }
        return hashMap;
    }

    public static Set<RadComponent> getParents(List<RadComponent> components) {
        HashSet<RadComponent> parents = new HashSet<RadComponent>();
        for (RadComponent component : components) {
            RadComponent parent = component.getParent();
            if (parent == null) continue;
            parents.add(parent);
        }
        return parents;
    }

    public static boolean isParentsContainedIn(List<RadComponent> components, RadComponent component) {
        for (RadComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!components.contains(parent)) continue;
            return true;
        }
        return false;
    }

    public static List<RadComponent> getPureSelection(List<RadComponent> selection) {
        ArrayList<RadComponent> components = new ArrayList<RadComponent>();
        for (RadComponent component : selection) {
            if (RadComponent.isParentsContainedIn(selection, component)) continue;
            components.add(component);
        }
        return components;
    }

    public boolean isAncestorFor(@NotNull RadComponent component, boolean strict) {
        RadComponent parent;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/designer/model/RadComponent", "isAncestorFor"));
        }
        RadComponent radComponent = parent = strict ? component.getParent() : component;
        while (parent != null) {
            if (parent == this) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

