/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable.renderers;

import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.PropertyTable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelPropertyRenderer
extends JLabel
implements PropertyRenderer {
    @Nullable
    private final String myStaticText;

    public LabelPropertyRenderer(@Nullable String staticText) {
        this.myStaticText = staticText;
        this.setOpaque(true);
        this.putClientProperty("html.disable", true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
    }

    @Override
    @NotNull
    public JComponent getComponent(@Nullable PropertiesContainer container, PropertyContext context, @Nullable Object value, boolean selected, boolean hasFocus) {
        this.setText(null);
        this.setIcon(null);
        PropertyTable.updateRenderer(this, selected);
        if (value != null) {
            this.customize(value);
        }
        LabelPropertyRenderer labelPropertyRenderer = this;
        if (labelPropertyRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/propertyTable/renderers/LabelPropertyRenderer", "getComponent"));
        }
        return labelPropertyRenderer;
    }

    protected void customize(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/designer/propertyTable/renderers/LabelPropertyRenderer", "customize"));
        }
        this.setText(this.myStaticText != null ? this.myStaticText : value.toString());
    }
}

