/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.IdeMessagePanel;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.diagnostic.MessagePool;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import java.awt.Component;
import java.awt.Window;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class ErrorNotifier {
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"IDE Fatal Errors");

    public static void notifyUi(final LogMessage message, final MessagePool pool) {
        if (message.getThrowable() instanceof MessagePool.TooManyErrorsException) {
            NOTIFICATION_GROUP.createNotification(message.getMessage(), NotificationType.ERROR).notify(null);
            return;
        }
        String title = "<a href='xxx'>" + ErrorNotifier.getTitle(message) + "</a>";
        String notificationText = ErrorNotifier.getNotificationText(message);
        NotificationListener listener2 = new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/diagnostic/ErrorNotifier$1", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diagnostic/ErrorNotifier$1", "hyperlinkUpdate"));
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ErrorNotifier.openFatals(event, message);
                }
            }
        };
        Notification notification = new Notification(NOTIFICATION_GROUP.getDisplayId(), title, notificationText, NotificationType.ERROR, listener2){

            public void expire() {
                super.expire();
                if (!message.isRead()) {
                    message.setRead(true);
                }
                pool.notifyListenersRead();
            }
        };
        notification.notify(null);
        message.setNotification(notification);
    }

    private static void openFatals(HyperlinkEvent event, LogMessage message) {
        Window window;
        Object source = event.getSource();
        if (source instanceof Component && (window = SwingUtilities.getWindowAncestor((Component)source)) instanceof IdeFrame) {
            StatusBarWidget widget;
            StatusBar statusBar = ((IdeFrame)window).getStatusBar();
            StatusBarWidget statusBarWidget = widget = statusBar == null ? null : statusBar.getWidget("FatalError");
            if (widget instanceof IdeMessagePanel) {
                ((IdeMessagePanel)widget).openFatals(message);
            }
        }
    }

    private static String getNotificationText(LogMessage message) {
        String result2;
        String text = message.getMessage();
        if (message instanceof LogMessageEx && (result2 = ((LogMessageEx)message).getNotificationText()) != null) {
            text = StringUtil.stripHtml((String)result2, (boolean)false);
        }
        return text;
    }

    private static String getTitle(LogMessage message) {
        if (message instanceof LogMessageEx) {
            return ((LogMessageEx)message).getTitle();
        }
        Throwable throwable = message.getThrowable();
        return throwable == null ? "IDE Fatal Error" : throwable.getClass().getSimpleName();
    }
}

