/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.GroupedLogMessage;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.IdeFatalErrorsIcon;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IconLikeCustomStatusBarWidget;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.ui.popup.NotificationPopup;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeMessagePanel
extends JPanel
implements MessagePoolListener,
IconLikeCustomStatusBarWidget {
    public static final String FATAL_ERROR = "FatalError";
    private final IdeFatalErrorsIcon myIdeFatal;
    static final String INTERNAL_ERROR_NOTICE = DiagnosticBundle.message("error.notification.tooltip", new Object[0]);
    private IdeErrorsDialog myDialog;
    private boolean myOpeningInProgress;
    private final IdeFrame myFrame;
    private final MessagePool myMessagePool;
    private boolean myNotificationPopupAlreadyShown;
    private static final String ERROR_TITLE = DiagnosticBundle.message("error.new.notification.title", new Object[0]);
    private static final String ERROR_LINK = DiagnosticBundle.message("error.new.notification.link", new Object[0]);

    public IdeMessagePanel(@NotNull IdeFrame frame, @NotNull MessagePool messagePool) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/diagnostic/IdeMessagePanel", "<init>"));
        }
        if (messagePool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messagePool", "com/intellij/diagnostic/IdeMessagePanel", "<init>"));
        }
        super(new BorderLayout());
        this.myNotificationPopupAlreadyShown = false;
        this.myIdeFatal = new IdeFatalErrorsIcon(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeMessagePanel.this.openFatals(null);
            }
        });
        this.myIdeFatal.setVerticalAlignment(0);
        this.add((Component)this.myIdeFatal, "Center");
        this.myFrame = frame;
        this.myMessagePool = messagePool;
        messagePool.addListener(this);
        this.updateFatalErrorsIcon();
        this.setOpaque(false);
    }

    @NotNull
    public String ID() {
        if (FATAL_ERROR == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/IdeMessagePanel", "ID"));
        }
        return FATAL_ERROR;
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diagnostic/IdeMessagePanel", "getPresentation"));
        }
        return null;
    }

    public void dispose() {
        this.myMessagePool.removeListener(this);
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/diagnostic/IdeMessagePanel", "install"));
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public void openFatals(final @Nullable LogMessage message) {
        if (this.myDialog != null) {
            return;
        }
        if (this.myOpeningInProgress) {
            return;
        }
        this.myOpeningInProgress = true;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (IdeMessagePanel.this.isOtherModalWindowActive()) {
                    if (IdeMessagePanel.this.myDialog == null) {
                        EdtExecutorService.getScheduledExecutorInstance().schedule(this, 300L, TimeUnit.MILLISECONDS);
                    }
                    return;
                }
                try {
                    IdeMessagePanel.this._openFatals(message);
                }
                finally {
                    IdeMessagePanel.this.myOpeningInProgress = false;
                }
            }
        };
        task.run();
    }

    private void _openFatals(@Nullable LogMessage message) {
        this.myDialog = new IdeErrorsDialog(this.myMessagePool, message){

            @Override
            public void doOKAction() {
                super.doOKAction();
                IdeMessagePanel.this.disposeDialog(this);
            }

            @Override
            public void doCancelAction() {
                super.doCancelAction();
                IdeMessagePanel.this.disposeDialog(this);
            }

            @Override
            protected void updateOnSubmit() {
                super.updateOnSubmit();
                IdeMessagePanel.this.updateState(IdeMessagePanel.this.computeState());
            }
        };
        this.myMessagePool.addListener(this.myDialog);
        if (!this.isOtherModalWindowActive()) {
            this.myDialog.show();
        } else {
            this.myDialog.close(0);
            this.disposeDialog(this.myDialog);
        }
    }

    private void updateState(IdeFatalErrorsIcon.State state) {
        this.myIdeFatal.setState(state);
        UIUtil.invokeLaterIfNeeded(() -> this.setVisible(state != IdeFatalErrorsIcon.State.NoErrors));
    }

    private void disposeDialog(IdeErrorsDialog listDialog) {
        this.myMessagePool.removeListener(listDialog);
        this.updateFatalErrorsIcon();
        this.myDialog = null;
    }

    @Override
    public void newEntryAdded() {
        this.updateFatalErrorsIcon();
    }

    @Override
    public void poolCleared() {
        this.updateFatalErrorsIcon();
    }

    @Override
    public void entryWasRead() {
        this.updateFatalErrorsIcon();
    }

    private boolean isOtherModalWindowActive() {
        Window window = IdeMessagePanel.getActiveModalWindow();
        if (window == null) {
            return false;
        }
        return this.myDialog == null || this.myDialog.getWindow() != window;
    }

    private static Window getActiveModalWindow() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeWindow = manager.getActiveWindow();
        if (activeWindow instanceof JDialog && ((JDialog)activeWindow).isModal()) {
            return activeWindow;
        }
        return null;
    }

    private IdeFatalErrorsIcon.State computeState() {
        List<AbstractMessage> errors = this.myMessagePool.getFatalErrors(true, false);
        if (errors.isEmpty()) {
            return IdeFatalErrorsIcon.State.NoErrors;
        }
        for (AbstractMessage error : errors) {
            if (error.isRead()) continue;
            return IdeFatalErrorsIcon.State.UnreadErrors;
        }
        return IdeFatalErrorsIcon.State.ReadErrors;
    }

    void updateFatalErrorsIcon() {
        IdeFatalErrorsIcon.State state = this.computeState();
        this.updateState(state);
        if (state == IdeFatalErrorsIcon.State.NoErrors) {
            this.myNotificationPopupAlreadyShown = false;
        } else if (state == IdeFatalErrorsIcon.State.UnreadErrors && !this.myNotificationPopupAlreadyShown) {
            ApplicationManager.getApplication().invokeLater(() -> {
                String notificationText = IdeMessagePanel.tryGetFromMessages(this.myMessagePool.getFatalErrors(false, false));
                if (NotificationsManagerImpl.newEnabled()) {
                    this.showErrorNotification(notificationText);
                    return;
                }
                if (notificationText == null) {
                    notificationText = INTERNAL_ERROR_NOTICE;
                }
                JLabel label = new JLabel(notificationText);
                label.setIcon(AllIcons.Ide.FatalError);
                new NotificationPopup(this, label, LightColors.RED, false, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        IdeMessagePanel.this._openFatals(null);
                    }
                }, true);
            });
            this.myNotificationPopupAlreadyShown = true;
        }
    }

    private void showErrorNotification(@Nullable String notificationText) {
        Notification notification = new Notification("", AllIcons.Ide.FatalError, notificationText == null ? ERROR_TITLE : "", null, notificationText == null ? "" : notificationText, NotificationType.ERROR, null);
        if (notificationText == null) {
            notification.addAction((AnAction)new NotificationAction(ERROR_LINK){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diagnostic/IdeMessagePanel$5", "actionPerformed"));
                    }
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/diagnostic/IdeMessagePanel$5", "actionPerformed"));
                    }
                    notification.expire();
                    IdeMessagePanel.this._openFatals(null);
                }
            });
        }
        BalloonLayout layout = this.myFrame.getBalloonLayout();
        assert (layout != null);
        BalloonLayoutData layoutData = new BalloonLayoutData();
        layoutData.groupId = "";
        layoutData.showSettingButton = false;
        layoutData.fadeoutTime = 5000L;
        layoutData.fillColor = new JBColor(16115431, 5848385);
        layoutData.borderColor = new JBColor(14723241, 7554379);
        Project project2 = this.myFrame.getProject();
        assert (project2 != null);
        Balloon balloon = NotificationsManagerImpl.createBalloon(this.myFrame, notification, false, false, (Ref<Object>)new Ref((Object)layoutData), (Disposable)project2);
        layout.add(balloon);
    }

    private static String tryGetFromMessages(List<AbstractMessage> messages) {
        String result2 = null;
        for (AbstractMessage message : messages) {
            String s;
            if (message instanceof LogMessageEx) {
                s = ((LogMessageEx)message).getNotificationText();
            } else if (message instanceof GroupedLogMessage) {
                s = IdeMessagePanel.tryGetFromMessages(((GroupedLogMessage)message).getMessages());
            } else {
                return null;
            }
            if (result2 == null) {
                result2 = s;
                continue;
            }
            if (result2.equals(s)) continue;
            return null;
        }
        return result2;
    }
}

