/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.ApdexData;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.ThreadMXBean;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerformanceWatcher
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.diagnostic.PerformanceWatcher");
    private static final int TOLERABLE_LATENCY = 100;
    private final ScheduledFuture<?> myThread;
    private final ThreadMXBean myThreadMXBean;
    private final DateFormat myDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private final File mySessionLogDir;
    private File myCurHangLogDir;
    private List<StackTraceElement> myStacktraceCommonPart;
    private final IdePerformanceListener myPublisher;
    private volatile ApdexData mySwingApdex = ApdexData.EMPTY;
    private volatile ApdexData myGeneralApdex = ApdexData.EMPTY;
    private volatile long myLastSampling = System.currentTimeMillis();
    private volatile long myLastAliveEdt = System.currentTimeMillis();
    private long myLastDumpTime;
    private long myFreezeStart;
    private int UNRESPONSIVE_THRESHOLD_SECONDS = 5;
    private int UNRESPONSIVE_INTERVAL_SECONDS = 5;
    private static final int SAMPLING_INTERVAL_MS = 1000;

    public static PerformanceWatcher getInstance() {
        return (PerformanceWatcher)ApplicationManager.getApplication().getComponent(PerformanceWatcher.class);
    }

    @NotNull
    public String getComponentName() {
        if ("PerformanceWatcher" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/PerformanceWatcher", "getComponentName"));
        }
        return "PerformanceWatcher";
    }

    public PerformanceWatcher() {
        this.myCurHangLogDir = this.mySessionLogDir = new File(PathManager.getLogPath() + "/threadDumps-" + this.myDateFormat.format(new Date()) + "-" + ApplicationInfo.getInstance().getBuild().asString());
        this.myPublisher = (IdePerformanceListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(IdePerformanceListener.TOPIC);
        this.myThreadMXBean = ManagementFactory.getThreadMXBean();
        this.myThread = JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                PerformanceWatcher.this.samplePerformance();
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void initComponent() {
        this.UNRESPONSIVE_THRESHOLD_SECONDS = SystemProperties.getIntProperty((String)"performance.watcher.threshold", (int)5);
        this.UNRESPONSIVE_INTERVAL_SECONDS = SystemProperties.getIntProperty((String)"performance.watcher.interval", (int)5);
        if (this.shouldWatch()) {
            final AppScheduledExecutorService service = (AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService();
            service.setNewThreadListener((Consumer)new Consumer<Thread>(){
                private final int ourReasonableThreadPoolSize = Registry.intValue((String)"core.pooled.threads");

                public void consume(Thread thread) {
                    if (service.getBackendPoolExecutorSize() > this.ourReasonableThreadPoolSize && ApplicationInfoImpl.getShadowInstance().isEAP()) {
                        File file2 = PerformanceWatcher.this.dumpThreads("newPooledThread/", true);
                        LOG.info("Not enough pooled threads" + (file2 != null ? "; dumped threads into file '" + file2.getPath() + "'" : ""));
                    }
                }
            });
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    PerformanceWatcher.deleteOldThreadDumps();
                }
            });
            for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
                if (!"Code Cache".equals(bean.getName())) continue;
                this.watchCodeCache(bean);
                break;
            }
        }
    }

    private void watchCodeCache(final MemoryPoolMXBean bean) {
        final long threshold = bean.getUsage().getMax() - 0x500000L;
        if (!bean.isUsageThresholdSupported() || threshold <= 0L) {
            return;
        }
        bean.setUsageThreshold(threshold);
        final NotificationEmitter emitter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
        emitter.addNotificationListener(new NotificationListener(){

            @Override
            public void handleNotification(Notification n, Object hb) {
                if (bean.getUsage().getUsed() > threshold) {
                    LOG.info("Code Cache is almost full");
                    PerformanceWatcher.this.dumpThreads("codeCacheFull", true);
                    try {
                        emitter.removeNotificationListener(this);
                    }
                    catch (ListenerNotFoundException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }, null, null);
    }

    private static void deleteOldThreadDumps() {
        Object[] dirs;
        File allLogsDir = new File(PathManager.getLogPath());
        if (allLogsDir.isDirectory() && (dirs = allLogsDir.list(new FilenameFilter(){

            @Override
            public boolean accept(@NotNull File dir, @NotNull String name) {
                if (dir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/diagnostic/PerformanceWatcher$5", "accept"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/diagnostic/PerformanceWatcher$5", "accept"));
                }
                return name.startsWith("threadDumps-");
            }
        })) != null) {
            Arrays.sort(dirs);
            for (int i = 0; i < dirs.length - 11; ++i) {
                FileUtil.delete((File)new File(allLogsDir, (String)dirs[i]));
            }
        }
    }

    public void disposeComponent() {
        if (this.myThread != null) {
            this.myThread.cancel(true);
        }
    }

    private boolean shouldWatch() {
        return !ApplicationManager.getApplication().isHeadlessEnvironment() && this.UNRESPONSIVE_INTERVAL_SECONDS != 0 && this.UNRESPONSIVE_THRESHOLD_SECONDS != 0;
    }

    private void samplePerformance() {
        long millis = System.currentTimeMillis();
        this.myLastSampling = millis;
        for (long diff = millis - this.myLastSampling - 1000L; diff >= 0L; diff -= 1000L) {
            this.myGeneralApdex = this.myGeneralApdex.withEvent(100L, diff);
        }
        long sinceLastEdt = millis - this.myLastAliveEdt;
        if (sinceLastEdt >= (long)(this.UNRESPONSIVE_THRESHOLD_SECONDS * 1000 + 10)) {
            this.edtFrozen(millis);
        } else if (sinceLastEdt <= 1000L) {
            this.edtResponds(millis);
        }
        SwingUtilities.invokeLater(new SwingThreadRunnable(millis));
    }

    private void edtFrozen(long currentMillis) {
        if (currentMillis - this.myLastDumpTime >= (long)(this.UNRESPONSIVE_INTERVAL_SECONDS * 1000)) {
            this.myLastDumpTime = currentMillis;
            if (this.myFreezeStart == 0L) {
                this.myFreezeStart = this.myLastAliveEdt;
                this.myPublisher.uiFreezeStarted();
            }
            if (this.myCurHangLogDir == this.mySessionLogDir) {
                this.myCurHangLogDir = new File(this.mySessionLogDir, this.myDateFormat.format(new Date()));
            }
            this.dumpThreads("", false);
        }
    }

    private void edtResponds(long currentMillis) {
        if (this.myFreezeStart != 0L) {
            if (this.myCurHangLogDir != this.mySessionLogDir && this.myCurHangLogDir.exists()) {
                int unresponsiveDuration = (int)(currentMillis - this.myFreezeStart) / 1000;
                this.myCurHangLogDir.renameTo(new File(this.mySessionLogDir, this.getLogDirForHang(unresponsiveDuration)));
                this.myPublisher.uiFreezeFinished(unresponsiveDuration);
            }
            this.myFreezeStart = 0L;
            this.myCurHangLogDir = this.mySessionLogDir;
            this.myStacktraceCommonPart = null;
        }
    }

    private String getLogDirForHang(int unresponsiveDuration) {
        StringBuilder name = new StringBuilder("freeze-" + this.myCurHangLogDir.getName());
        name.append("-").append(unresponsiveDuration);
        if (this.myStacktraceCommonPart != null && !this.myStacktraceCommonPart.isEmpty()) {
            StackTraceElement element = this.myStacktraceCommonPart.get(0);
            name.append("-").append(StringUtil.getShortName((String)element.getClassName())).append(".").append(element.getMethodName());
        }
        return name.toString();
    }

    @Nullable
    public File dumpThreads(@NotNull String pathPrefix, boolean millis) {
        if (pathPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathPrefix", "com/intellij/diagnostic/PerformanceWatcher", "dumpThreads"));
        }
        if (!this.shouldWatch()) {
            return null;
        }
        String suffix = millis ? "-" + System.currentTimeMillis() : "";
        File file2 = new File(this.myCurHangLogDir, pathPrefix + "threadDump-" + this.myDateFormat.format(new Date()) + suffix + ".txt");
        File dir = file2.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            return null;
        }
        PerformanceWatcher.checkMemoryUsage(file2);
        ThreadDump threadDump = ThreadDumper.getThreadDumpInfo((ThreadMXBean)this.myThreadMXBean);
        try {
            FileUtil.writeToFile((File)file2, (String)threadDump.getRawDump());
            Object[] edtStack = threadDump.getEDTStackTrace();
            if (edtStack != null) {
                if (this.myStacktraceCommonPart == null) {
                    this.myStacktraceCommonPart = ContainerUtil.newArrayList((Object[])edtStack);
                } else {
                    this.updateStacktraceCommonPart((StackTraceElement[])edtStack);
                }
            }
            this.myPublisher.dumpedThreads(file2, threadDump);
        }
        catch (IOException e) {
            LOG.info("failed to write thread dump file: " + e.getMessage());
        }
        return file2;
    }

    private static void checkMemoryUsage(File file2) {
        long usedMemory;
        Runtime rt = Runtime.getRuntime();
        long maxMemory = rt.maxMemory();
        long freeMemory = maxMemory - (usedMemory = rt.totalMemory() - rt.freeMemory());
        if (freeMemory < maxMemory / 5L) {
            LOG.info("High memory usage (free " + freeMemory / 1024L / 1024L + " of " + maxMemory / 1024L / 1024L + " MB) while dumping threads to " + file2);
        }
    }

    public static void dumpThreadsToConsole(String message) {
        System.err.println(message);
        System.err.println(ThreadDumper.dumpThreadsToString());
    }

    private void updateStacktraceCommonPart(StackTraceElement[] stackTraceElements) {
        for (int i = 0; i < this.myStacktraceCommonPart.size() && i < stackTraceElements.length; ++i) {
            StackTraceElement el2;
            StackTraceElement el1 = this.myStacktraceCommonPart.get(this.myStacktraceCommonPart.size() - i - 1);
            if (el1.equals(el2 = stackTraceElements[stackTraceElements.length - i - 1])) continue;
            this.myStacktraceCommonPart = this.myStacktraceCommonPart.subList(this.myStacktraceCommonPart.size() - i, this.myStacktraceCommonPart.size());
            break;
        }
    }

    @NotNull
    public static Snapshot takeSnapshot() {
        PerformanceWatcher performanceWatcher = PerformanceWatcher.getInstance();
        performanceWatcher.getClass();
        Snapshot snapshot = performanceWatcher.new Snapshot();
        if (snapshot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/PerformanceWatcher", "takeSnapshot"));
        }
        return snapshot;
    }

    public class Snapshot {
        private final ApdexData myStartGeneralSnapshot;
        private final ApdexData myStartSwingSnapshot;
        private final long myStartMillis;

        private Snapshot() {
            this.myStartGeneralSnapshot = PerformanceWatcher.this.myGeneralApdex;
            this.myStartSwingSnapshot = PerformanceWatcher.this.mySwingApdex;
            this.myStartMillis = System.currentTimeMillis();
        }

        public void logResponsivenessSinceCreation(@NotNull String activityName) {
            if (activityName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityName", "com/intellij/diagnostic/PerformanceWatcher$Snapshot", "logResponsivenessSinceCreation"));
            }
            LOG.info(activityName + " took " + (System.currentTimeMillis() - this.myStartMillis) + "ms" + "; general responsiveness: " + PerformanceWatcher.this.myGeneralApdex.summarizePerformanceSince(this.myStartGeneralSnapshot) + "; EDT responsiveness: " + PerformanceWatcher.this.mySwingApdex.summarizePerformanceSince(this.myStartSwingSnapshot));
        }
    }

    private class SwingThreadRunnable
    implements Runnable {
        private final long myCreationMillis;

        SwingThreadRunnable(long creationMillis) {
            this.myCreationMillis = creationMillis;
        }

        @Override
        public void run() {
            long millis = System.currentTimeMillis();
            PerformanceWatcher.this.mySwingApdex = PerformanceWatcher.this.mySwingApdex.withEvent(100L, millis - this.myCreationMillis);
            PerformanceWatcher.this.myLastAliveEdt = millis;
        }
    }
}

