/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.errordialog;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.errordialog.LabeledTextComponent;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AttachmentsTabForm {
    private static final Logger LOG = Logger.getInstance(AttachmentsTabForm.class);
    private JPanel myContentPane;
    private TableView<Attachment> myTable;
    private LabeledTextComponent myFileTextArea;
    private final EventDispatcher<ChangeListener> myInclusionEventDispatcher;
    private final ColumnInfo<Attachment, Boolean> ENABLED_COLUMN;
    private static final ColumnInfo<Attachment, String> PATH_COLUMN = new ColumnInfo<Attachment, String>(DiagnosticBundle.message("error.dialog.attachment.path.column.title", new Object[0])){

        public String valueOf(Attachment attachment) {
            return attachment.getPath();
        }
    };

    public AttachmentsTabForm() {
        this.$$$setupUI$$$();
        this.myInclusionEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.ENABLED_COLUMN = new ColumnInfo<Attachment, Boolean>(DiagnosticBundle.message("error.dialog.attachment.include.column.title", new Object[0])){

            public Boolean valueOf(Attachment attachment) {
                return attachment.isIncluded();
            }

            public Class getColumnClass() {
                return Boolean.class;
            }

            public int getWidth(JTable table) {
                return 50;
            }

            public boolean isCellEditable(Attachment attachment) {
                return true;
            }

            public void setValue(Attachment attachment, Boolean value) {
                attachment.setIncluded(value.booleanValue());
                ((ChangeListener)AttachmentsTabForm.this.myInclusionEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(attachment));
            }
        };
        this.myFileTextArea.getTextComponent().setEditable(false);
        this.myFileTextArea.setTitle(DiagnosticBundle.message("error.dialog.filecontent.title", new Object[0]));
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                LabeledTextComponent.setText(AttachmentsTabForm.this.myFileTextArea.getTextComponent(), null, true);
                Attachment attachment = (Attachment)AttachmentsTabForm.this.myTable.getSelectedObject();
                if (attachment != null) {
                    try {
                        LabeledTextComponent.setText(AttachmentsTabForm.this.myFileTextArea.getTextComponent(), attachment.getDisplayText(), true);
                    }
                    catch (Throwable th) {
                        LOG.warn(th);
                    }
                }
            }
        });
        this.myTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = AttachmentsTabForm.this.myTable.getSelectedRows();
                boolean aggregateValue = true;
                for (int selectedRow : selectedRows) {
                    if (selectedRow < 0 || !AttachmentsTabForm.this.myTable.isCellEditable(selectedRow, 0)) {
                        return;
                    }
                    Boolean value = (Boolean)AttachmentsTabForm.this.myTable.getValueAt(selectedRow, 0);
                    aggregateValue &= value == null || value != false;
                }
                for (int selectedRow : selectedRows) {
                    AttachmentsTabForm.this.myTable.setValueAt((Object)(aggregateValue ? Boolean.FALSE : Boolean.TRUE), selectedRow, 0);
                }
                AttachmentsTabForm.this.myTable.repaint();
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.myTable.setModelAndUpdateColumns(new ListTableModel(new ColumnInfo[]{this.ENABLED_COLUMN, PATH_COLUMN}, attachments, 1));
        this.myTable.setBorder(IdeBorderFactory.createBorder());
        this.myTable.setSelection(Collections.singletonList(attachments.get(0)));
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public void addInclusionListener(ChangeListener listener2) {
        this.myInclusionEventDispatcher.addListener((EventListener)listener2);
    }

    public void selectFirstIncludedAttachment() {
        List items = ((ListTableModel)this.myTable.getModel()).getItems();
        for (Object item : items) {
            if (!((Attachment)item).isIncluded()) continue;
            this.myTable.setSelection(Collections.singleton((Attachment)item));
            break;
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledTextComponent labeledTextComponent;
        TableView tableView;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(5, 5, 5, 5), -1, 5, false, false));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTable = tableView = new TableView();
        jBScrollPane.setViewportView((Component)tableView);
        this.myFileTextArea = labeledTextComponent = new LabeledTextComponent();
        JComponent jComponent = labeledTextComponent.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("<html>These files will be attached to the bug report. We recommend to include all the files providing maximum information.<br/><b>Note:</b> all the data you send will be kept private.</ntml>");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

