/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.diagnostic.logging.DefaultLogFormatter;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.diagnostic.logging.LogConsoleListener;
import com.intellij.diagnostic.logging.LogContentPreprocessor;
import com.intellij.diagnostic.logging.LogFilter;
import com.intellij.diagnostic.logging.LogFilterListener;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.diagnostic.logging.LogFormatter;
import com.intellij.diagnostic.logging.LogFragment;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.FilterComponent;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LogConsoleBase
extends AdditionalTabComponent
implements LogConsole,
LogFilterListener {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.diagnostic.logging.LogConsoleImpl");
    @NonNls
    public static final String APPLYING_FILTER_TITLE = "Applying filter...";
    private JPanel mySearchComponent;
    private JComboBox myLogFilterCombo;
    private JPanel myTextFilterWrapper;
    private boolean myDisposed;
    private ConsoleView myConsole;
    private final LightProcessHandler myProcessHandler;
    private ReaderThread myReaderThread;
    private StringBuffer myOriginalDocument;
    private String myLineUnderSelection;
    private int myLineOffset;
    private LogContentPreprocessor myContentPreprocessor;
    private final Project myProject;
    private String myTitle;
    private boolean myWasInitialized;
    private final JPanel myTopComponent;
    private ActionGroup myActions;
    private final boolean myBuildInActions;
    private LogFilterModel myModel;
    private final LogFormatter myFormatter;
    private final List<LogConsoleListener> myListeners;
    private final List<? extends LogFilter> myFilters;
    private FilterComponent myFilter;

    public LogConsoleBase(@NotNull Project project2, @Nullable Reader reader, String title, boolean buildInActions, LogFilterModel model) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diagnostic/logging/LogConsoleBase", "<init>"));
        }
        this(project2, reader, title, buildInActions, model, GlobalSearchScope.allScope((Project)project2));
    }

    public LogConsoleBase(@NotNull Project project2, @Nullable Reader reader, String title, boolean buildInActions, LogFilterModel model, @NotNull GlobalSearchScope scope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diagnostic/logging/LogConsoleBase", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/diagnostic/logging/LogConsoleBase", "<init>"));
        }
        this(project2, reader, title, buildInActions, model, scope, new DefaultLogFormatter());
    }

    public LogConsoleBase(@NotNull Project project2, @Nullable Reader reader, String title, boolean buildInActions, LogFilterModel model, @NotNull GlobalSearchScope scope, LogFormatter formatter) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diagnostic/logging/LogConsoleBase", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/diagnostic/logging/LogConsoleBase", "<init>"));
        }
        super((LayoutManager)new BorderLayout());
        this.$$$setupUI$$$();
        this.myProcessHandler = new LightProcessHandler();
        this.myOriginalDocument = null;
        this.myLineUnderSelection = null;
        this.myLineOffset = -1;
        this.myTitle = null;
        this.myTopComponent = new JPanel(new BorderLayout());
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myFilter = new FilterComponent("LOG_FILTER_HISTORY", 5){

            public void filter() {
                Task.Backgroundable task = new Task.Backgroundable(LogConsoleBase.this.myProject, LogConsoleBase.APPLYING_FILTER_TITLE){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diagnostic/logging/LogConsoleBase$1$1", "run"));
                        }
                        LogConsoleBase.this.myModel.updateCustomFilter(this.getFilter());
                    }
                };
                ProgressManager.getInstance().run((Task)task);
            }
        };
        this.myProject = project2;
        this.myTitle = title;
        this.myModel = model;
        this.myFormatter = formatter;
        this.myFilters = this.myModel.getLogFilters();
        this.myReaderThread = new ReaderThread(reader);
        this.myBuildInActions = buildInActions;
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project2, scope);
        this.myConsole = builder.getConsole();
        this.myConsole.attachToProcess((ProcessHandler)this.myProcessHandler);
        this.myDisposed = false;
        this.myModel.addFilterListener((LogFilterListener)this);
    }

    public void setFilterModel(LogFilterModel model) {
        if (this.myModel != null) {
            this.myModel.removeFilterListener((LogFilterListener)this);
        }
        this.myModel = model;
        this.myModel.addFilterListener((LogFilterListener)this);
    }

    public LogFilterModel getFilterModel() {
        return this.myModel;
    }

    public LogContentPreprocessor getContentPreprocessor() {
        return this.myContentPreprocessor;
    }

    public void setContentPreprocessor(LogContentPreprocessor contentPreprocessor) {
        this.myContentPreprocessor = contentPreprocessor;
    }

    @Nullable
    protected BufferedReader updateReaderIfNeeded(@Nullable BufferedReader reader) throws IOException {
        return reader;
    }

    private JComponent createToolbar() {
        String customFilter = this.myModel.getCustomFilter();
        this.myFilter.reset();
        this.myFilter.setSelectedItem(customFilter != null ? customFilter : "");
        new AnAction(){
            {
                this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(9, 64)), (JComponent)((Object)LogConsoleBase.this));
            }

            public void actionPerformed(AnActionEvent e) {
                LogConsoleBase.this.myFilter.requestFocusInWindow();
            }
        };
        if (this.myBuildInActions) {
            JComponent tbComp = ActionManager.getInstance().createActionToolbar("unknown", this.getOrCreateActions(), true).getComponent();
            this.myTopComponent.add((Component)tbComp, "Center");
            this.myTopComponent.add((Component)this.getSearchComponent(), "East");
        }
        return this.myTopComponent;
    }

    public ActionGroup getOrCreateActions() {
        AnAction[] actions;
        if (this.myActions != null) {
            return this.myActions;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        for (AnAction action : actions = this.getConsoleNotNull().createConsoleActions()) {
            group.add(action);
        }
        group.addSeparator();
        this.myActions = group;
        return this.myActions;
    }

    public void onFilterStateChange(LogFilter filter) {
        this.filterConsoleOutput();
    }

    public void onTextFilterChange() {
        this.filterConsoleOutput();
    }

    @NotNull
    public JComponent getComponent() {
        if (!this.myWasInitialized) {
            this.myWasInitialized = true;
            this.add(this.getConsoleNotNull().getComponent(), "Center");
            this.add(this.createToolbar(), "North");
        }
        LogConsoleBase logConsoleBase = this;
        if (logConsoleBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/logging/LogConsoleBase", "getComponent"));
        }
        return logConsoleBase;
    }

    public abstract boolean isActive();

    public void activate() {
        ReaderThread readerThread = this.myReaderThread;
        if (readerThread == null) {
            return;
        }
        if (this.isActive() && !readerThread.myRunning) {
            this.resetLogFilter();
            this.myFilter.setSelectedItem(this.myModel.getCustomFilter());
            readerThread.startRunning();
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)readerThread);
        } else if (!this.isActive() && readerThread.myRunning) {
            readerThread.stopRunning();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.activate();
    }

    @NotNull
    public String getTabTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/logging/LogConsoleBase", "getTabTitle"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.myModel.removeFilterListener((LogFilterListener)this);
        this.stopRunning(false);
        LogConsoleBase logConsoleBase = this;
        synchronized (logConsoleBase) {
            this.myDisposed = true;
            if (this.myConsole != null) {
                Disposer.dispose((Disposable)this.myConsole);
                this.myConsole = null;
            }
        }
        if (this.myFilter != null) {
            this.myFilter.dispose();
            this.myFilter = null;
        }
        this.myOriginalDocument = null;
    }

    private void stopRunning(boolean checkActive) {
        ReaderThread readerThread;
        if (!checkActive) {
            this.fireLoggingWillBeStopped();
        }
        if ((readerThread = this.myReaderThread) != null && readerThread.myReader != null) {
            if (!checkActive) {
                readerThread.stopRunning();
                try {
                    readerThread.myReader.close();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
                readerThread.myReader = null;
                this.myReaderThread = null;
            } else {
                try {
                    BufferedReader reader = readerThread.myReader;
                    while (reader != null && reader.ready()) {
                        this.addMessage(reader.readLine());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.stopRunning(false);
            }
        }
    }

    protected synchronized void addMessage(String text) {
        if (text == null) {
            return;
        }
        if (this.myContentPreprocessor != null) {
            List fragments = this.myContentPreprocessor.parseLogLine(text + "\n");
            this.myOriginalDocument = this.getOriginalDocument();
            for (LogFragment fragment : fragments) {
                String formattedMessage = this.myFormatter.formatMessage(fragment.getText());
                this.myProcessHandler.notifyTextAvailable(formattedMessage, fragment.getOutputType());
                if (this.myOriginalDocument == null) continue;
                this.myOriginalDocument.append(fragment.getText());
            }
        } else {
            Key key2;
            LogFilterModel.MyProcessingResult processingResult = this.myModel.processLine(text);
            if (processingResult.isApplicable() && (key2 = processingResult.getKey()) != null) {
                String messagePrefix = processingResult.getMessagePrefix();
                if (messagePrefix != null) {
                    String formattedPrefix = this.myFormatter.formatPrefix(messagePrefix);
                    this.myProcessHandler.notifyTextAvailable(formattedPrefix, key2);
                }
                String formattedMessage = this.myFormatter.formatMessage(text);
                this.myProcessHandler.notifyTextAvailable(formattedMessage + "\n", key2);
            }
            this.myOriginalDocument = this.getOriginalDocument();
            if (this.myOriginalDocument != null) {
                this.myOriginalDocument.append(text).append("\n");
            }
        }
    }

    public void attachStopLogConsoleTrackingListener(final ProcessHandler process2) {
        if (process2 != null) {
            ProcessAdapter stopListener = new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    process2.removeProcessListener((ProcessListener)this);
                    LogConsoleBase.this.stopRunning(true);
                }
            };
            process2.addProcessListener((ProcessListener)stopListener);
        }
    }

    public StringBuffer getOriginalDocument() {
        int toRemove;
        if (this.myOriginalDocument == null) {
            Editor editor = this.getEditor();
            if (editor != null) {
                this.myOriginalDocument = new StringBuffer(editor.getDocument().getText());
            }
        } else if (ConsoleBuffer.useCycleBuffer() && (toRemove = this.myOriginalDocument.length() - ConsoleBuffer.getCycleBufferSize()) > 0) {
            this.myOriginalDocument.delete(0, toRemove);
        }
        return this.myOriginalDocument;
    }

    @Nullable
    private Editor getEditor() {
        ConsoleView console = this.getConsole();
        return console != null ? (Editor)CommonDataKeys.EDITOR.getData((DataProvider)console) : null;
    }

    private void filterConsoleOutput() {
        ApplicationManager.getApplication().invokeLater(() -> this.computeSelectedLineAndFilter());
    }

    private synchronized void computeSelectedLineAndFilter() {
        this.myOriginalDocument = this.getOriginalDocument();
        if (this.myOriginalDocument != null) {
            Editor editor = this.getEditor();
            LOG.assertTrue(editor != null);
            Document document2 = editor.getDocument();
            int caretOffset = editor.getCaretModel().getOffset();
            this.myLineUnderSelection = null;
            this.myLineOffset = -1;
            if (caretOffset > -1 && caretOffset < document2.getTextLength()) {
                int line;
                try {
                    line = document2.getLineNumber(caretOffset);
                }
                catch (IllegalStateException e) {
                    throw new IllegalStateException("document.length=" + document2.getTextLength() + ", caret offset = " + caretOffset + "; " + e.getMessage(), e);
                }
                if (line > -1 && line < document2.getLineCount()) {
                    int startOffset = document2.getLineStartOffset(line);
                    this.myLineUnderSelection = document2.getText().substring(startOffset, document2.getLineEndOffset(line));
                    this.myLineOffset = caretOffset - startOffset;
                }
            }
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> this.doFilter());
    }

    private synchronized void doFilter() {
        if (this.myDisposed) {
            return;
        }
        ConsoleView console = this.getConsoleNotNull();
        console.clear();
        this.myModel.processingStarted();
        String[] lines = this.myOriginalDocument != null ? this.myOriginalDocument.toString().split("\n") : ArrayUtil.EMPTY_STRING_ARRAY;
        int offset = 0;
        boolean caretPositioned = false;
        for (String line : lines) {
            int printed = this.printMessageToConsole(line);
            if (printed <= 0 || caretPositioned) continue;
            if (Comparing.strEqual((String)this.myLineUnderSelection, (String)line)) {
                caretPositioned = true;
                offset += this.myLineOffset != -1 ? this.myLineOffset : 0;
                continue;
            }
            offset += printed;
        }
        if (caretPositioned) {
            console.scrollTo(offset);
        } else {
            ((ConsoleViewImpl)console).requestScrollingToEnd();
        }
    }

    private int printMessageToConsole(String line) {
        ConsoleViewContentType type;
        Key key2;
        ConsoleView console = this.getConsoleNotNull();
        if (this.myContentPreprocessor != null) {
            List fragments = this.myContentPreprocessor.parseLogLine(line + '\n');
            for (LogFragment fragment : fragments) {
                ConsoleViewContentType consoleViewType = ConsoleViewContentType.getConsoleViewType((Key)fragment.getOutputType());
                if (consoleViewType == null) continue;
                String formattedText = this.myFormatter.formatMessage(fragment.getText());
                console.print(formattedText, consoleViewType);
            }
            return line.length() + 1;
        }
        LogFilterModel.MyProcessingResult processingResult = this.myModel.processLine(line);
        if (processingResult.isApplicable() && (key2 = processingResult.getKey()) != null && (type = ConsoleViewContentType.getConsoleViewType((Key)key2)) != null) {
            String messagePrefix = processingResult.getMessagePrefix();
            if (messagePrefix != null) {
                String formattedPrefix = this.myFormatter.formatPrefix(messagePrefix);
                console.print(formattedPrefix, type);
            }
            String formattedMessage = this.myFormatter.formatMessage(line);
            console.print(formattedMessage + "\n", type);
            return (messagePrefix != null ? messagePrefix.length() : 0) + line.length() + 1;
        }
        return 0;
    }

    @Nullable
    public synchronized ConsoleView getConsole() {
        return this.myConsole;
    }

    @NotNull
    private synchronized ConsoleView getConsoleNotNull() {
        ConsoleView console = this.getConsole();
        assert (console != null) : "it looks like console has been disposed";
        ConsoleView consoleView = console;
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/logging/LogConsoleBase", "getConsoleNotNull"));
        }
        return consoleView;
    }

    public ActionGroup getToolbarActions() {
        return this.getOrCreateActions();
    }

    public String getToolbarPlace() {
        return "unknown";
    }

    @Nullable
    public JComponent getToolbarContextComponent() {
        ConsoleView console = this.getConsole();
        return console == null ? null : console.getComponent();
    }

    public JComponent getPreferredFocusableComponent() {
        return this.getConsoleNotNull().getPreferredFocusableComponent();
    }

    public String getTitle() {
        return this.myTitle;
    }

    public synchronized void clear() {
        this.getConsoleNotNull().clear();
        this.myOriginalDocument = null;
    }

    public JComponent getSearchComponent() {
        this.myLogFilterCombo.setModel(new DefaultComboBoxModel<LogFilter>(this.myFilters.toArray(new LogFilter[this.myFilters.size()])));
        this.resetLogFilter();
        this.myLogFilterCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final LogFilter filter = (LogFilter)LogConsoleBase.this.myLogFilterCombo.getSelectedItem();
                Task.Backgroundable task = new Task.Backgroundable(LogConsoleBase.this.myProject, LogConsoleBase.APPLYING_FILTER_TITLE){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diagnostic/logging/LogConsoleBase$4$1", "run"));
                        }
                        LogConsoleBase.this.myModel.selectFilter(filter);
                    }
                };
                ProgressManager.getInstance().run((Task)task);
            }
        });
        this.myTextFilterWrapper.removeAll();
        this.myTextFilterWrapper.add(this.getTextFilterComponent());
        return this.mySearchComponent;
    }

    private void resetLogFilter() {
        for (LogFilter logFilter : this.myFilters) {
            if (!this.myModel.isFilterSelected(logFilter) || this.myLogFilterCombo.getSelectedItem() == logFilter) continue;
            this.myLogFilterCombo.setSelectedItem(logFilter);
            break;
        }
    }

    @NotNull
    protected Component getTextFilterComponent() {
        FilterComponent filterComponent = this.myFilter;
        if (filterComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/logging/LogConsoleBase", "getTextFilterComponent"));
        }
        return filterComponent;
    }

    public boolean isContentBuiltIn() {
        return this.myBuildInActions;
    }

    public void writeToConsole(String text, Key outputType) {
        this.myProcessHandler.notifyTextAvailable(text, outputType);
    }

    public void addListener(LogConsoleListener listener2) {
        this.myListeners.add(listener2);
    }

    private void fireLoggingWillBeStopped() {
        for (LogConsoleListener listener2 : this.myListeners) {
            listener2.loggingWillBeStopped();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        JPanel jPanel2;
        this.mySearchComponent = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 10), -1, -1, false, false));
        this.myLogFilterCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, new Dimension(100, -1), null, null));
        this.myTextFilterWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mySearchComponent;
    }

    private class ReaderThread
    implements Runnable {
        private BufferedReader myReader;
        private boolean myRunning = false;
        private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)LogConsoleBase.this);

        public ReaderThread(Reader reader) {
            this.myReader = reader != null ? new BufferedReader(reader) : null;
        }

        @Override
        public void run() {
            if (this.myReader == null) {
                return;
            }
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    if (ReaderThread.this.myRunning) {
                        try {
                            ReaderThread.this.myReader = LogConsoleBase.this.updateReaderIfNeeded(ReaderThread.this.myReader);
                            int i = 0;
                            while (i++ < 1000) {
                                BufferedReader reader = ReaderThread.this.myReader;
                                if (ReaderThread.this.myRunning && reader != null && reader.ready()) {
                                    LogConsoleBase.this.addMessage(reader.readLine());
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException e) {
                            LOG.info((Throwable)e);
                            LogConsoleBase.this.addMessage("I/O Error" + (e.getMessage() != null ? ": " + e.getMessage() : ""));
                            return;
                        }
                    }
                    if (ReaderThread.this.myAlarm.isDisposed()) {
                        return;
                    }
                    ReaderThread.this.myAlarm.addRequest((Runnable)this, 100);
                }
            };
            if (this.myAlarm.isDisposed()) {
                return;
            }
            this.myAlarm.addRequest(runnable2, 10);
        }

        public void startRunning() {
            this.myRunning = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRunning() {
            this.myRunning = false;
            ReaderThread readerThread = this;
            synchronized (readerThread) {
                this.notifyAll();
            }
        }
    }

    private static class LightProcessHandler
    extends ProcessHandler {
        private LightProcessHandler() {
        }

        protected void destroyProcessImpl() {
            throw new UnsupportedOperationException();
        }

        protected void detachProcessImpl() {
            throw new UnsupportedOperationException();
        }

        public boolean detachIsDefault() {
            return false;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return null;
        }
    }
}

