/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Block {
    private static final Logger LOG = Logger.getInstance(Block.class);
    @NotNull
    private final String[] mySource;
    private final int myStart;
    private final int myEnd;

    public Block(@NotNull String source, int start, int end) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/diff/Block", "<init>"));
        }
        this(Block.tokenize(source), start, end);
    }

    public Block(@NotNull String[] source, int start, int end) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/diff/Block", "<init>"));
        }
        this.mySource = source;
        this.myStart = Math.min(Math.max(0, start), source.length);
        this.myEnd = Math.min(Math.max(this.myStart, end), source.length);
    }

    @NotNull
    public static String[] tokenize(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/Block", "tokenize"));
        }
        String[] stringArray = LineTokenizer.tokenize((CharSequence)text, (boolean)false, (boolean)false);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/Block", "tokenize"));
        }
        return stringArray;
    }

    @NotNull
    public Block createPreviousBlock(@NotNull String prevContent) {
        if (prevContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevContent", "com/intellij/diff/Block", "createPreviousBlock"));
        }
        Block block = this.createPreviousBlock(Block.tokenize(prevContent));
        if (block == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/Block", "createPreviousBlock"));
        }
        return block;
    }

    @NotNull
    public Block createPreviousBlock(@NotNull String[] prevContent) {
        if (prevContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevContent", "com/intellij/diff/Block", "createPreviousBlock"));
        }
        int start = -1;
        int end = -1;
        int shift = 0;
        FairDiffIterable iterable = DiffIterableUtil.diffSomehow(prevContent, this.mySource, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        for (Pair<Range, Boolean> pair : DiffIterableUtil.iterateAll(iterable)) {
            Boolean equals = (Boolean)pair.second;
            Range range = (Range)pair.first;
            if (!equals.booleanValue()) {
                if (Math.max(this.myStart, range.start2) < Math.min(this.myEnd, range.end2)) {
                    if (range.start2 <= this.myStart) {
                        start = range.start1;
                    }
                    if (range.end2 > this.myEnd) {
                        end = range.end1;
                    }
                }
                if (range.start2 > this.myStart) {
                    if (start == -1) {
                        start = this.myStart - shift;
                    }
                    if (end == -1 && range.start2 >= this.myEnd) {
                        end = this.myEnd - shift;
                    }
                }
                shift += range.end2 - range.start2 - (range.end1 - range.start1);
                continue;
            }
            int count = range.end1 - range.start1;
            for (int i = 0; i < count; ++i) {
                prevContent[range.start1 + i] = this.mySource[range.start2 + i];
            }
        }
        if (start == -1) {
            start = this.myStart - shift;
        }
        if (end == -1) {
            end = this.myEnd - shift;
        }
        if (start < 0 || end > prevContent.length || end < start) {
            LOG.error("Invalid block range: [" + start + ", " + end + "); length - " + prevContent.length);
        }
        Block block = new Block(prevContent, start, end);
        if (block == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/Block", "createPreviousBlock"));
        }
        return block;
    }

    @NotNull
    public String getBlockContent() {
        String string = StringUtil.join(this.getLines(), (String)"\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/Block", "getBlockContent"));
        }
        return string;
    }

    @NotNull
    public List<String> getLines() {
        List<String> list = Arrays.asList(this.mySource).subList(this.myStart, this.myEnd);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/Block", "getLines"));
        }
        return list;
    }

    public int hashCode() {
        return Arrays.hashCode(this.mySource) ^ this.myStart ^ this.myEnd;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Block)) {
            return false;
        }
        Block other = (Block)object;
        return Arrays.equals(this.mySource, other.mySource) && this.myStart == other.myStart && this.myEnd == other.myEnd;
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        this.appendLines(result2, 0, this.myStart);
        result2.append("<-----------------------------\n");
        this.appendLines(result2, this.myStart, this.myEnd);
        result2.append("----------------------------->\n");
        this.appendLines(result2, this.myEnd, this.mySource.length);
        return result2.toString();
    }

    private void appendLines(@NotNull StringBuilder result2, int from, int to) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diff/Block", "appendLines"));
        }
        for (int i = from; i < to; ++i) {
            result2.append(this.mySource[i]);
            result2.append("\n");
        }
    }
}

