/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="DiffSettings", storages={@Storage(value="diff.xml")})
public class DiffSettingsHolder
implements PersistentStateComponent<State> {
    public static final Key<DiffSettings> KEY = Key.create((String)"DiffSettings");
    private State myState = new State();

    @NotNull
    public DiffSettings getSettings(@Nullable String place) {
        PlaceSettings placeSettings;
        if (place == null) {
            place = "Default";
        }
        if ((placeSettings = this.myState.PLACES_MAP.get(place)) == null) {
            placeSettings = new PlaceSettings();
            this.myState.PLACES_MAP.put(place, placeSettings);
        }
        DiffSettings diffSettings = new DiffSettings(this.myState.SHARED_SETTINGS, placeSettings);
        if (diffSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffSettingsHolder", "getSettings"));
        }
        return diffSettings;
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffSettingsHolder", "getState"));
        }
        return state;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public static DiffSettingsHolder getInstance() {
        return (DiffSettingsHolder)ServiceManager.getService(DiffSettingsHolder.class);
    }

    public static class State {
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
        public Map<String, PlaceSettings> PLACES_MAP = new HashMap();
        public SharedSettings SHARED_SETTINGS = new SharedSettings();
    }

    public static class DiffSettings {
        @NotNull
        public SharedSettings SHARED_SETTINGS;
        @NotNull
        public PlaceSettings PLACE_SETTINGS;

        public DiffSettings() {
            this.SHARED_SETTINGS = new SharedSettings();
            this.PLACE_SETTINGS = new PlaceSettings();
        }

        public DiffSettings(@NotNull SharedSettings SHARED_SETTINGS, @NotNull PlaceSettings PLACE_SETTINGS) {
            if (SHARED_SETTINGS == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "SHARED_SETTINGS", "com/intellij/diff/impl/DiffSettingsHolder$DiffSettings", "<init>"));
            }
            if (PLACE_SETTINGS == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "PLACE_SETTINGS", "com/intellij/diff/impl/DiffSettingsHolder$DiffSettings", "<init>"));
            }
            this.SHARED_SETTINGS = new SharedSettings();
            this.PLACE_SETTINGS = new PlaceSettings();
            this.SHARED_SETTINGS = SHARED_SETTINGS;
            this.PLACE_SETTINGS = PLACE_SETTINGS;
        }

        @NotNull
        public List<String> getDiffToolsOrder() {
            List<String> list = this.PLACE_SETTINGS.DIFF_TOOLS_ORDER;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffSettingsHolder$DiffSettings", "getDiffToolsOrder"));
            }
            return list;
        }

        public void setDiffToolsOrder(@NotNull List<String> order) {
            if (order == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "order", "com/intellij/diff/impl/DiffSettingsHolder$DiffSettings", "setDiffToolsOrder"));
            }
            this.PLACE_SETTINGS.DIFF_TOOLS_ORDER = order;
        }

        public boolean isGoToNextFileOnNextDifference() {
            return this.SHARED_SETTINGS.GO_TO_NEXT_FILE_ON_NEXT_DIFFERENCE;
        }

        public void setGoToNextFileOnNextDifference(boolean value) {
            this.SHARED_SETTINGS.GO_TO_NEXT_FILE_ON_NEXT_DIFFERENCE = value;
        }

        public boolean isSyncBinaryEditorSettings() {
            return this.PLACE_SETTINGS.SYNC_BINARY_EDITOR_SETTINGS;
        }

        public void setSyncBinaryEditorSettings(boolean value) {
            this.PLACE_SETTINGS.SYNC_BINARY_EDITOR_SETTINGS = value;
        }

        @NotNull
        public static DiffSettings getSettings() {
            DiffSettings diffSettings = DiffSettings.getSettings(null);
            if (diffSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffSettingsHolder$DiffSettings", "getSettings"));
            }
            return diffSettings;
        }

        @NotNull
        public static DiffSettings getSettings(@Nullable String place) {
            DiffSettings diffSettings = DiffSettingsHolder.getInstance().getSettings(place);
            if (diffSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffSettingsHolder$DiffSettings", "getSettings"));
            }
            return diffSettings;
        }
    }

    private static class PlaceSettings {
        @NotNull
        public List<String> DIFF_TOOLS_ORDER = new ArrayList<String>();
        public boolean SYNC_BINARY_EDITOR_SETTINGS = true;

        private PlaceSettings() {
        }
    }

    private static class SharedSettings {
        public boolean GO_TO_NEXT_FILE_ON_NEXT_DIFFERENCE = true;

        private SharedSettings() {
        }
    }
}

