/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.settings;

import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class ExternalDiffSettingsPanel {
    private static final String DESCRIPTION_TEXT = "<html>Different tools have different parameters. It's important to specify all necessary parameters in proper order<br><b>%1</b> - left (Local changes)<br><b>%2</b> - right (Server content)<br><b>%3</b> - base (Current version without local changes)<br><b>%4</b> - output (Merge result)</html>";
    private JPanel myPane;
    @NotNull
    private final ExternalDiffSettings mySettings;
    private JCheckBox myDiffEnabled;
    private JBCheckBox myDiffDefault;
    private TextFieldWithBrowseButton myDiffPath;
    private JTextField myDiffParameters;
    private JCheckBox myMergeEnabled;
    private TextFieldWithBrowseButton myMergePath;
    private JTextField myMergeParameters;
    private JLabel myDescriptionLabel;
    private JCheckBox myRespectExitCodeCheckbox;

    public ExternalDiffSettingsPanel() {
        this.$$$setupUI$$$();
        this.mySettings = ExternalDiffSettings.getInstance();
        this.myDescriptionLabel.setText(DESCRIPTION_TEXT);
        this.myDiffEnabled.getModel().addActionListener(e -> this.updateEnabledEffect());
        this.myMergeEnabled.getModel().addActionListener(e -> this.updateEnabledEffect());
        this.myDiffPath.addBrowseFolderListener(DiffBundle.message((String)"select.external.diff.program.dialog.title", (Object[])new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myMergePath.addBrowseFolderListener(DiffBundle.message((String)"select.external.merge.program.dialog.title", (Object[])new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
    }

    @NotNull
    public JComponent getPanel() {
        JPanel jPanel = this.myPane;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/settings/ExternalDiffSettingsPanel", "getPanel"));
        }
        return jPanel;
    }

    public boolean isModified() {
        if (this.mySettings.isDiffEnabled() != this.myDiffEnabled.isSelected()) {
            return true;
        }
        if (this.mySettings.isDiffDefault() != this.myDiffDefault.isSelected()) {
            return true;
        }
        if (!this.mySettings.getDiffExePath().equals(this.myDiffPath.getText())) {
            return true;
        }
        if (!this.mySettings.getDiffParameters().equals(this.myDiffParameters.getText())) {
            return true;
        }
        if (this.mySettings.isMergeEnabled() != this.myMergeEnabled.isSelected()) {
            return true;
        }
        if (!this.mySettings.getMergeExePath().equals(this.myMergePath.getText())) {
            return true;
        }
        if (!this.mySettings.getMergeParameters().equals(this.myMergeParameters.getText())) {
            return true;
        }
        return this.mySettings.isMergeTrustExitCode() != this.myRespectExitCodeCheckbox.isSelected();
    }

    public void apply() {
        this.mySettings.setDiffEnabled(this.myDiffEnabled.isSelected());
        this.mySettings.setDiffDefault(this.myDiffDefault.isSelected());
        this.mySettings.setDiffExePath(this.myDiffPath.getText());
        this.mySettings.setDiffParameters(this.myDiffParameters.getText());
        this.mySettings.setMergeEnabled(this.myMergeEnabled.isSelected());
        this.mySettings.setMergeExePath(this.myMergePath.getText());
        this.mySettings.setMergeParameters(this.myMergeParameters.getText());
        this.mySettings.setMergeTrustExitCode(this.myRespectExitCodeCheckbox.isSelected());
    }

    public void reset() {
        this.myDiffEnabled.setSelected(this.mySettings.isDiffEnabled());
        this.myDiffDefault.setSelected(this.mySettings.isDiffDefault());
        this.myDiffPath.setText(this.mySettings.getDiffExePath());
        this.myDiffParameters.setText(this.mySettings.getDiffParameters());
        this.myMergePath.setText(this.mySettings.getMergeExePath());
        this.myMergeEnabled.setSelected(this.mySettings.isMergeEnabled());
        this.myMergeParameters.setText(this.mySettings.getMergeParameters());
        this.myRespectExitCodeCheckbox.setSelected(this.mySettings.isMergeTrustExitCode());
        this.updateEnabledEffect();
    }

    private void updateEnabledEffect() {
        UIUtil.setEnabled((Component)this.myDiffPath, (boolean)this.myDiffEnabled.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myDiffParameters, (boolean)this.myDiffEnabled.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myDiffDefault, (boolean)this.myDiffEnabled.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myMergePath, (boolean)this.myMergeEnabled.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myMergeParameters, (boolean)this.myMergeEnabled.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myRespectExitCodeCheckbox, (boolean)this.myMergeEnabled.isSelected(), (boolean)true);
    }

    private void createUIComponents() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox3;
        JLabel jLabel;
        JTextField jTextField2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel;
        this.myPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(7, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Path to executable:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDiffPath = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setText("");
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 3, 8, 1, 7, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Parameters:");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDiffParameters = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 3, 8, 1, 6, 0, null, null, null));
        this.myDescriptionLabel = jLabel = new JLabel();
        jLabel.setText("<Usage description>");
        jPanel.add((Component)jLabel, new GridConstraints(6, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myDiffEnabled = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Use external diff tool:");
        jCheckBox3.setMargin(new Insets(4, 2, 0, 2));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myDiffDefault = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Use by default");
        jBCheckBox.setToolTipText("");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myMergeEnabled = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/DiffBundle").getString("diff.options.use.external.merge.tool.for.files.checkbox"));
        jCheckBox2.setMargin(new Insets(4, 2, 0, 2));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myRespectExitCodeCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Trust process exit code");
        jCheckBox.setMargin(new Insets(4, 2, 0, 2));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Path to executable:");
        jPanel.add((Component)jLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Parameters:");
        jPanel.add((Component)jLabel5, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMergePath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 3, 8, 1, 7, 0, null, null, null));
        this.myMergeParameters = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(5, 1, 1, 3, 8, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

