/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.GutterContentProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Graphics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicGutterContentProvider
extends GutterContentProvider {
    public static final String EVAL_OUT_MARKER = "\u200c";
    public static final String EVAL_IN_MARKER = "\u200c\u200c";
    protected final boolean isLineRelationshipComputable;

    public BasicGutterContentProvider() {
        this(true);
    }

    public BasicGutterContentProvider(boolean isLineRelationshipComputable) {
        this.isLineRelationshipComputable = isLineRelationshipComputable;
    }

    @Override
    public boolean hasText() {
        return false;
    }

    @Override
    @Nullable
    public String getText(int line, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/BasicGutterContentProvider", "getText"));
        }
        return null;
    }

    @Override
    @Nullable
    public String getToolTip(int line, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/BasicGutterContentProvider", "getToolTip"));
        }
        return null;
    }

    @Override
    public void doAction(int line, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/BasicGutterContentProvider", "doAction"));
        }
    }

    @Override
    public void beforeEvaluate(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/BasicGutterContentProvider", "beforeEvaluate"));
        }
        Document document2 = editor.getDocument();
        document2.insertString(document2.getTextLength(), (CharSequence)EVAL_IN_MARKER);
    }

    @Override
    public boolean drawIcon(int line, @NotNull Graphics g, int y, @NotNull Editor editor) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/execution/console/BasicGutterContentProvider", "drawIcon"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/BasicGutterContentProvider", "drawIcon"));
        }
        int markerCount = BasicGutterContentProvider.getMarkerCount(line, editor.getDocument());
        if (markerCount == EVAL_OUT_MARKER.length() || markerCount == EVAL_IN_MARKER.length()) {
            g.setColor((Color)JBColor.GRAY);
            g.drawString(markerCount == EVAL_IN_MARKER.length() ? ">" : "<", 3, y);
            return true;
        }
        return false;
    }

    @Override
    public final boolean isShowSeparatorLine(int line, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/BasicGutterContentProvider", "isShowSeparatorLine"));
        }
        Document document2 = editor.getDocument();
        if (line + 1 >= document2.getLineCount()) {
            return true;
        }
        int markerCount = BasicGutterContentProvider.getMarkerCount(line, document2);
        if (markerCount == EVAL_IN_MARKER.length()) {
            return BasicGutterContentProvider.getMarkerCount(line + 1, document2) != EVAL_OUT_MARKER.length();
        }
        if (!this.isLineRelationshipComputable && markerCount == EVAL_OUT_MARKER.length()) {
            return BasicGutterContentProvider.getMarkerCount(line + 1, document2) == EVAL_IN_MARKER.length();
        }
        if (!this.isLineRelationshipComputable && markerCount == 0) {
            return BasicGutterContentProvider.getMarkerCount(line + 1, document2) != 0 || line != 0 && BasicGutterContentProvider.getMarkerCount(line - 1, document2) != 0;
        }
        return this.doIsShowSeparatorLine(line, editor, document2);
    }

    protected boolean doIsShowSeparatorLine(int line, @NotNull Editor editor, @NotNull Document document2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/BasicGutterContentProvider", "doIsShowSeparatorLine"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/execution/console/BasicGutterContentProvider", "doIsShowSeparatorLine"));
        }
        return this.isLineRelationshipComputable;
    }

    private static int getMarkerCount(int line, @NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/execution/console/BasicGutterContentProvider", "getMarkerCount"));
        }
        return StringUtil.countChars((CharSequence)document2.getImmutableCharSequence(), (char)EVAL_IN_MARKER.charAt(0), (int)document2.getLineStartOffset(line), (boolean)true);
    }
}

