/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleUtil {
    private ConsoleUtil() {
    }

    public static void addToken(int length, @Nullable HyperlinkInfo info, ConsoleViewContentType contentType, @NotNull List<ConsoleViewImpl.TokenInfo> tokens) {
        if (tokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "com/intellij/execution/impl/ConsoleUtil", "addToken"));
        }
        int startOffset = 0;
        if (!tokens.isEmpty()) {
            ConsoleViewImpl.TokenInfo lastToken = tokens.get(tokens.size() - 1);
            if (lastToken.contentType == contentType && info == lastToken.getHyperlinkInfo()) {
                lastToken.endOffset += length;
                return;
            }
            startOffset = lastToken.endOffset;
        }
        tokens.add(info != null ? new ConsoleViewImpl.HyperlinkTokenInfo(contentType, startOffset, startOffset + length, info) : new ConsoleViewImpl.TokenInfo(contentType, startOffset, startOffset + length));
    }

    public static void updateTokensOnTextRemoval(@NotNull List<? extends ConsoleViewImpl.TokenInfo> tokens, int startOffset, int endOffset) {
        if (tokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "com/intellij/execution/impl/ConsoleUtil", "updateTokensOnTextRemoval"));
        }
        int firstIndex = ConsoleUtil.findTokenInfoIndexByOffset(tokens, startOffset);
        if (firstIndex >= tokens.size()) {
            return;
        }
        int removedSymbolsNumber = endOffset - startOffset;
        boolean updateOnly = false;
        int removeIndexStart = -1;
        int removeIndexEnd = -1;
        ConsoleViewImpl.TokenInfo firstToken = tokens.get(firstIndex);
        if (startOffset == firstToken.startOffset) {
            if (endOffset < firstToken.endOffset) {
                firstToken.endOffset -= removedSymbolsNumber;
                updateOnly = true;
            } else {
                removeIndexStart = removeIndexEnd = firstIndex;
            }
        } else if (endOffset <= firstToken.endOffset) {
            firstToken.endOffset -= removedSymbolsNumber;
            updateOnly = true;
        }
        for (int i = firstIndex + 1; i < tokens.size(); ++i) {
            ConsoleViewImpl.TokenInfo tokenInfo = tokens.get(i);
            if (updateOnly) {
                tokenInfo.startOffset -= removedSymbolsNumber;
                tokenInfo.endOffset -= removedSymbolsNumber;
                continue;
            }
            if (endOffset >= tokenInfo.endOffset) {
                if (removeIndexStart < 0) {
                    removeIndexStart = i;
                }
                removeIndexEnd = i;
                continue;
            }
            tokenInfo.startOffset = startOffset;
            tokenInfo.endOffset = startOffset + (tokenInfo.endOffset - endOffset);
            updateOnly = true;
        }
        if (removeIndexStart >= 0) {
            tokens.subList(removeIndexStart, removeIndexEnd + 1).clear();
        }
    }

    public static int findTokenInfoIndexByOffset(@NotNull List<? extends ConsoleViewImpl.TokenInfo> tokens, int offset) {
        if (tokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "com/intellij/execution/impl/ConsoleUtil", "findTokenInfoIndexByOffset"));
        }
        int low = 0;
        int high = tokens.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            ConsoleViewImpl.TokenInfo midVal = tokens.get(mid);
            if (offset < midVal.startOffset) {
                high = mid - 1;
                continue;
            }
            if (offset >= midVal.endOffset) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return tokens.size();
    }
}

