/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStartupConfigurationBase
implements PersistentStateComponent<ProjectStartupConfigurationBase> {
    @Tag(value="configurations")
    @AbstractCollection(surroundWithTag=false)
    private final List<ConfigurationDescriptor> myList = new ArrayList<ConfigurationDescriptor>();

    protected ProjectStartupConfigurationBase() {
    }

    @Nullable
    public ProjectStartupConfigurationBase getState() {
        return this;
    }

    public void loadState(ProjectStartupConfigurationBase state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public void clear() {
        this.myList.clear();
    }

    @Transient
    public List<ConfigurationDescriptor> getList() {
        return this.myList;
    }

    public void setList(@NotNull List<ConfigurationDescriptor> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/startup/ProjectStartupConfigurationBase", "setList"));
        }
        this.myList.clear();
        Collections.sort(list, new ConfigurationDescriptorComparator());
        this.myList.addAll(list);
    }

    public boolean isEmpty() {
        return this.myList.isEmpty();
    }

    public void setConfigurations(@NotNull Collection<RunnerAndConfigurationSettings> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/execution/startup/ProjectStartupConfigurationBase", "setConfigurations"));
        }
        List names = ContainerUtil.map(collection, settings -> new ConfigurationDescriptor(settings.getUniqueID(), settings.getName()));
        this.setList(names);
    }

    public boolean deleteConfiguration(String id) {
        List<ConfigurationDescriptor> list = this.getList();
        Iterator<ConfigurationDescriptor> iterator = list.iterator();
        while (iterator.hasNext()) {
            ConfigurationDescriptor descriptor = iterator.next();
            if (!descriptor.getId().equals(id)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean rename(String oldId, RunnerAndConfigurationSettings settings) {
        List<ConfigurationDescriptor> list = this.getList();
        for (ConfigurationDescriptor descriptor : list) {
            if (!descriptor.getId().equals(oldId)) continue;
            ArrayList<ConfigurationDescriptor> newList = new ArrayList<ConfigurationDescriptor>(list);
            newList.remove(descriptor);
            newList.add(new ConfigurationDescriptor(settings.getUniqueID(), settings.getName()));
            this.setList(newList);
            return true;
        }
        return false;
    }

    private static class ConfigurationDescriptorComparator
    implements Comparator<ConfigurationDescriptor> {
        private ConfigurationDescriptorComparator() {
        }

        @Override
        public int compare(ConfigurationDescriptor o1, ConfigurationDescriptor o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }

    @Tag(value="configuration")
    public static class ConfigurationDescriptor {
        private String myId;
        private String myName;

        public ConfigurationDescriptor() {
        }

        public ConfigurationDescriptor(@NotNull String id, @NotNull String name) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/execution/startup/ProjectStartupConfigurationBase$ConfigurationDescriptor", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/execution/startup/ProjectStartupConfigurationBase$ConfigurationDescriptor", "<init>"));
            }
            this.myId = id;
            this.myName = name;
        }

        @Attribute(value="id")
        public String getId() {
            return this.myId;
        }

        @Attribute(value="name")
        public String getName() {
            return this.myName;
        }

        public void setId(String id) {
            this.myId = id;
        }

        public void setName(String name) {
            this.myName = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigurationDescriptor that = (ConfigurationDescriptor)o;
            if (!this.myId.equals(that.myId)) {
                return false;
            }
            return this.myName.equals(that.myName);
        }

        public int hashCode() {
            int result2 = this.myId.hashCode();
            result2 = 31 * result2 + this.myName.hashCode();
            return result2;
        }
    }
}

