/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.TestDiscoveryListener;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDiscoveryExtension
extends RunConfigurationExtension {
    private static final Logger LOG = Logger.getInstance((String)("#" + TestDiscoveryExtension.class.getName()));
    private static final Object ourTracesLock = new Object();

    @Nullable
    public SettingsEditor createEditor(@NotNull RunConfigurationBase configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/testDiscovery/TestDiscoveryExtension", "createEditor"));
        }
        return null;
    }

    @Nullable
    public String getEditorTitle() {
        return null;
    }

    @NotNull
    public String getSerializationId() {
        if ("testDiscovery" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/TestDiscoveryExtension", "getSerializationId"));
        }
        return "testDiscovery";
    }

    protected void attachToProcess(final @NotNull RunConfigurationBase configuration, final @NotNull ProcessHandler handler2, @Nullable RunnerSettings runnerSettings) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/testDiscovery/TestDiscoveryExtension", "attachToProcess"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/testDiscovery/TestDiscoveryExtension", "attachToProcess"));
        }
        if (runnerSettings == null && this.isApplicableFor(configuration)) {
            final Alarm processTracesAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, null);
            final MessageBusConnection connection = configuration.getProject().getMessageBus().connect();
            connection.subscribe(SMTRunnerEventsListener.TEST_STATUS, (Object)new SMTRunnerEventsAdapter(){
                private List<String> myCompletedMethodNames = new ArrayList<String>();

                @Override
                public void onTestFinished(@NotNull SMTestProxy test) {
                    String fullTestName;
                    if (test == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "test", "com/intellij/execution/testDiscovery/TestDiscoveryExtension$1", "onTestFinished"));
                    }
                    SMTestProxy.SMRootTestProxy root = test.getRoot();
                    if ((root == null || root.getHandler() == handler2) && (fullTestName = test.getLocationUrl()) != null && fullTestName.startsWith("java:test")) {
                        this.myCompletedMethodNames.add(((JavaTestConfigurationBase)configuration).getFrameworkPrefix() + fullTestName.substring("java:test".length() + 3));
                        if (this.myCompletedMethodNames.size() > 50) {
                            String[] fullTestNames = ArrayUtil.toStringArray(this.myCompletedMethodNames);
                            this.myCompletedMethodNames.clear();
                            processTracesAlarm.addRequest(() -> {
                                if (configuration == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/testDiscovery/TestDiscoveryExtension$1", "lambda$onTestFinished$0"));
                                }
                                TestDiscoveryExtension.processAvailableTraces(configuration, fullTestNames);
                            }, 100);
                        }
                    }
                }

                @Override
                public void onTestingFinished(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
                    if (testsRoot == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testsRoot", "com/intellij/execution/testDiscovery/TestDiscoveryExtension$1", "onTestingFinished"));
                    }
                    if (testsRoot.getHandler() == handler2) {
                        processTracesAlarm.cancelAllRequests();
                        processTracesAlarm.addRequest(() -> {
                            if (configuration == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/testDiscovery/TestDiscoveryExtension$1", "lambda$onTestingFinished$1"));
                            }
                            TestDiscoveryExtension.processAvailableTraces(configuration);
                            Disposer.dispose((Disposable)processTracesAlarm);
                        }, 0);
                        connection.disconnect();
                    }
                }
            });
        }
    }

    public void updateJavaParameters(RunConfigurationBase configuration, JavaParameters params, RunnerSettings runnerSettings) {
        if (runnerSettings != null || !this.isApplicableFor(configuration)) {
            return;
        }
        StringBuilder argument = new StringBuilder("-javaagent:");
        String agentPath = PathUtil.getJarPathForClass(ProjectData.class);
        argument.append(agentPath);
        params.getVMParametersList().add(argument.toString());
        params.getClassPath().add(agentPath);
        params.getVMParametersList().addProperty("org.jetbrains.instrumentation.trace.dir", TestDiscoveryExtension.getTracesDirectory(configuration));
    }

    @NotNull
    private static String getTracesDirectory(RunConfigurationBase configuration) {
        String string = TestDiscoveryExtension.baseTestDiscoveryPathForProject(configuration.getProject()) + File.separator + configuration.getUniqueID();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/TestDiscoveryExtension", "getTracesDirectory"));
        }
        return string;
    }

    @Override
    public boolean isListenerDisabled(RunConfigurationBase configuration, Object listener2, RunnerSettings runnerSettings) {
        return listener2 instanceof TestDiscoveryListener && (runnerSettings != null || !this.isApplicableFor(configuration));
    }

    public void readExternal(@NotNull RunConfigurationBase runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/execution/testDiscovery/TestDiscoveryExtension", "readExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/testDiscovery/TestDiscoveryExtension", "readExternal"));
        }
    }

    public void writeExternal(@NotNull RunConfigurationBase runConfiguration, @NotNull Element element) throws WriteExternalException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/execution/testDiscovery/TestDiscoveryExtension", "writeExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/testDiscovery/TestDiscoveryExtension", "writeExternal"));
        }
        throw new WriteExternalException();
    }

    protected boolean isApplicableFor(@NotNull RunConfigurationBase configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/testDiscovery/TestDiscoveryExtension", "isApplicableFor"));
        }
        return configuration instanceof JavaTestConfigurationBase && Registry.is((String)"testDiscovery.enabled");
    }

    @NotNull
    public static String baseTestDiscoveryPathForProject(Project project2) {
        String string = PathManager.getSystemPath() + File.separator + "testDiscovery" + File.separator + project2.getName() + "." + project2.getLocationHash();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/TestDiscoveryExtension", "baseTestDiscoveryPathForProject"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processAvailableTraces(RunConfigurationBase configuration) {
        String tracesDirectory = TestDiscoveryExtension.getTracesDirectory(configuration);
        TestDiscoveryIndex coverageIndex = TestDiscoveryIndex.getInstance(configuration.getProject());
        Object object = ourTracesLock;
        synchronized (object) {
            File tracesDirectoryFile = new File(tracesDirectory);
            File[] testMethodTraces = tracesDirectoryFile.listFiles((dir, name) -> name.endsWith(".tr"));
            if (testMethodTraces != null) {
                for (File testMethodTrace : testMethodTraces) {
                    try {
                        coverageIndex.updateFromTestTrace(testMethodTrace);
                        FileUtil.delete((File)testMethodTrace);
                    }
                    catch (IOException e) {
                        LOG.error("Can not load " + testMethodTrace, (Throwable)e);
                    }
                }
                String[] filesInTracedDirectories = tracesDirectoryFile.list();
                if (filesInTracedDirectories == null || filesInTracedDirectories.length == 0) {
                    FileUtil.delete((File)tracesDirectoryFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processAvailableTraces(RunConfigurationBase configuration, String[] fullTestNames) {
        String tracesDirectory = TestDiscoveryExtension.getTracesDirectory(configuration);
        TestDiscoveryIndex coverageIndex = TestDiscoveryIndex.getInstance(configuration.getProject());
        Object object = ourTracesLock;
        synchronized (object) {
            for (String fullTestName : fullTestNames) {
                File testMethodTrace;
                String className = StringUtil.getPackageName((String)fullTestName);
                String methodName = StringUtil.getShortName((String)fullTestName);
                if (StringUtil.isEmptyOrSpaces((String)className) || StringUtil.isEmptyOrSpaces((String)methodName) || !(testMethodTrace = new File(tracesDirectory, className + "-" + methodName + ".tr")).exists()) continue;
                try {
                    coverageIndex.updateFromTestTrace(testMethodTrace);
                    FileUtil.delete((File)testMethodTrace);
                }
                catch (IOException e) {
                    LOG.error("Can not load " + testMethodTrace, (Throwable)e);
                }
            }
        }
    }
}

