/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.events;

import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.util.text.StringUtil;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestFailedEvent
extends TreeNodeEvent {
    private final String myLocalizedFailureMessage;
    private final String myStacktrace;
    private final boolean myTestError;
    private final String myComparisonFailureActualText;
    private final String myComparisonFailureExpectedText;
    private final String myExpectedFilePath;
    private final String myActualFilePath;
    private final long myDurationMillis;

    public TestFailedEvent(@NotNull TestFailed testFailed, boolean testError) {
        if (testFailed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFailed", "com/intellij/execution/testframework/sm/runner/events/TestFailedEvent", "<init>"));
        }
        this(testFailed, testError, null);
    }

    public TestFailedEvent(@NotNull TestFailed testFailed, boolean testError, @Nullable String expectedFilePath) {
        if (testFailed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFailed", "com/intellij/execution/testframework/sm/runner/events/TestFailedEvent", "<init>"));
        }
        this(testFailed, testError, expectedFilePath, null);
    }

    public TestFailedEvent(@NotNull TestFailed testFailed, boolean testError, @Nullable String expectedFilePath, @Nullable String actualFilePath) {
        if (testFailed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFailed", "com/intellij/execution/testframework/sm/runner/events/TestFailedEvent", "<init>"));
        }
        super(testFailed.getTestName(), TreeNodeEvent.getNodeId((ServiceMessage)testFailed));
        if (testFailed.getFailureMessage() == null) {
            throw new NullPointerException();
        }
        this.myLocalizedFailureMessage = testFailed.getFailureMessage();
        this.myStacktrace = testFailed.getStacktrace();
        this.myTestError = testError;
        this.myComparisonFailureActualText = testFailed.getActual();
        this.myComparisonFailureExpectedText = testFailed.getExpected();
        this.myExpectedFilePath = expectedFilePath;
        this.myActualFilePath = actualFilePath;
        this.myDurationMillis = TestFailedEvent.parseDuration((String)testFailed.getAttributes().get("duration"));
    }

    private static long parseDuration(@Nullable String durationStr) {
        if (!StringUtil.isEmpty((String)durationStr)) {
            try {
                return Long.parseLong(durationStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public TestFailedEvent(@NotNull String testName, @NotNull String localizedFailureMessage, @Nullable String stackTrace, boolean testError, @Nullable String comparisonFailureActualText, @Nullable String comparisonFailureExpectedText) {
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/intellij/execution/testframework/sm/runner/events/TestFailedEvent", "<init>"));
        }
        if (localizedFailureMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedFailureMessage", "com/intellij/execution/testframework/sm/runner/events/TestFailedEvent", "<init>"));
        }
        this(testName, null, localizedFailureMessage, stackTrace, testError, comparisonFailureActualText, comparisonFailureExpectedText, null, -1L);
    }

    public TestFailedEvent(@Nullable String testName, @Nullable String id, @NotNull String localizedFailureMessage, @Nullable String stackTrace, boolean testError, @Nullable String comparisonFailureActualText, @Nullable String comparisonFailureExpectedText, @Nullable String expectedFilePath, long durationMillis) {
        if (localizedFailureMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedFailureMessage", "com/intellij/execution/testframework/sm/runner/events/TestFailedEvent", "<init>"));
        }
        super(testName, id);
        this.myLocalizedFailureMessage = localizedFailureMessage;
        this.myStacktrace = stackTrace;
        this.myTestError = testError;
        this.myComparisonFailureActualText = comparisonFailureActualText;
        this.myComparisonFailureExpectedText = comparisonFailureExpectedText;
        this.myExpectedFilePath = expectedFilePath;
        this.myActualFilePath = null;
        this.myDurationMillis = durationMillis;
    }

    @NotNull
    public String getLocalizedFailureMessage() {
        String string = this.myLocalizedFailureMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/events/TestFailedEvent", "getLocalizedFailureMessage"));
        }
        return string;
    }

    @Nullable
    public String getStacktrace() {
        return this.myStacktrace;
    }

    public boolean isTestError() {
        return this.myTestError;
    }

    @Nullable
    public String getComparisonFailureActualText() {
        return this.myComparisonFailureActualText;
    }

    @Nullable
    public String getComparisonFailureExpectedText() {
        return this.myComparisonFailureExpectedText;
    }

    @Override
    protected void appendToStringInfo(@NotNull StringBuilder buf) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/execution/testframework/sm/runner/events/TestFailedEvent", "appendToStringInfo"));
        }
        TestFailedEvent.append(buf, "localizedFailureMessage", this.myLocalizedFailureMessage);
        TestFailedEvent.append(buf, "stacktrace", this.myStacktrace);
        TestFailedEvent.append(buf, "isTestError", this.myTestError);
        TestFailedEvent.append(buf, "comparisonFailureActualText", this.myComparisonFailureActualText);
        TestFailedEvent.append(buf, "comparisonFailureExpectedText", this.myComparisonFailureExpectedText);
    }

    public String getFilePath() {
        return this.myExpectedFilePath;
    }

    @Nullable
    public String getExpectedFilePath() {
        return this.myExpectedFilePath;
    }

    @Nullable
    public String getActualFilePath() {
        return this.myActualFilePath;
    }

    public long getDurationMillis() {
        return this.myDurationMillis;
    }
}

