/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalDependencies.impl;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.externalDependencies.ProjectExternalDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.FormBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDependenciesConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final ExternalDependenciesManager myDependenciesManager;
    private CollectionListModel<ProjectExternalDependency> myListModel = new CollectionListModel((Object[])new ProjectExternalDependency[0]);
    private Map<String, String> myPluginNameById;

    public ExternalDependenciesConfigurable(Project project2) {
        this.myDependenciesManager = ExternalDependenciesManager.getInstance(project2);
    }

    public void reset() {
        List<ProjectExternalDependency> dependencies = this.myDependenciesManager.getAllDependencies();
        this.myListModel.replaceAll(dependencies);
    }

    public boolean isModified() {
        return !new HashSet<ProjectExternalDependency>(this.myDependenciesManager.getAllDependencies()).equals(new HashSet(this.myListModel.getItems()));
    }

    public void apply() throws ConfigurationException {
        this.myDependenciesManager.setAllDependencies(this.myListModel.getItems());
    }

    @Nls
    public String getDisplayName() {
        return "Required Plugins";
    }

    @Nullable
    public JComponent createComponent() {
        final JBList dependenciesList = new JBList();
        dependenciesList.setCellRenderer((ListCellRenderer)new ColoredListCellRendererWrapper<DependencyOnPlugin>(){

            protected void doCustomize(JList list, DependencyOnPlugin value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.append(ExternalDependenciesConfigurable.this.getPluginNameById(value.getPluginId()), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    String minVersion = value.getMinVersion();
                    String maxVersion = value.getMaxVersion();
                    if (minVersion != null || maxVersion != null) {
                        this.append(", version ");
                    }
                    if (minVersion != null && minVersion.equals(maxVersion)) {
                        this.append(minVersion, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else if (minVersion != null && maxVersion != null) {
                        this.append("between ");
                        this.append(minVersion, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                        this.append(" and ");
                        this.append(maxVersion, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else if (minVersion != null) {
                        this.append("at least ");
                        this.append(minVersion, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else if (maxVersion != null) {
                        this.append("at most ");
                        this.append(maxVersion, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    }
                }
            }
        });
        dependenciesList.setModel(this.myListModel);
        JPanel dependenciesPanel = ToolbarDecorator.createDecorator((JList)dependenciesList).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ExternalDependenciesConfigurable.this.replaceDependency(new DependencyOnPlugin("", null, null, null), dependenciesList);
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                DependencyOnPlugin selected = (DependencyOnPlugin)dependenciesList.getSelectedValue();
                if (selected != null) {
                    ExternalDependenciesConfigurable.this.replaceDependency(selected, dependenciesList);
                }
            }
        }).createPanel();
        return FormBuilder.createFormBuilder().addLabeledComponentFillVertically("Plugins which are required to work on this project.", (JComponent)dependenciesPanel).getPanel();
    }

    private void replaceDependency(DependencyOnPlugin original, JBList dependenciesList) {
        DependencyOnPlugin dependency = this.editPluginDependency((JComponent)dependenciesList, original);
        if (dependency != null) {
            for (ProjectExternalDependency dependency1 : new ArrayList(this.myListModel.getItems())) {
                if (!(dependency1 instanceof DependencyOnPlugin) || !((DependencyOnPlugin)dependency1).getPluginId().equals(dependency.getPluginId())) continue;
                this.myListModel.remove((Object)dependency1);
            }
            this.myListModel.add((Object)dependency);
            dependenciesList.setSelectedValue((Object)dependency, true);
        }
    }

    private String getPluginNameById(@NotNull String pluginId) {
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/externalDependencies/impl/ExternalDependenciesConfigurable", "getPluginNameById"));
        }
        return (String)ObjectUtils.notNull((Object)this.getPluginNameByIdMap().get(pluginId), (Object)pluginId);
    }

    private Map<String, String> getPluginNameByIdMap() {
        if (this.myPluginNameById == null) {
            this.myPluginNameById = new HashMap<String, String>();
            for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
                this.myPluginNameById.put(descriptor.getPluginId().getIdString(), descriptor.getName());
            }
        }
        return this.myPluginNameById;
    }

    @NotNull
    public String getId() {
        if ("preferences.externalDependencies" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/externalDependencies/impl/ExternalDependenciesConfigurable", "getId"));
        }
        return "preferences.externalDependencies";
    }

    @Nullable
    private DependencyOnPlugin editPluginDependency(@NotNull JComponent parent, @NotNull DependencyOnPlugin original) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/externalDependencies/impl/ExternalDependenciesConfigurable", "editPluginDependency"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/externalDependencies/impl/ExternalDependenciesConfigurable", "editPluginDependency"));
        }
        ArrayList<String> pluginIds = new ArrayList<String>(this.getPluginNameByIdMap().keySet());
        if (!original.getPluginId().isEmpty() && !pluginIds.contains(original.getPluginId())) {
            pluginIds.add(original.getPluginId());
        }
        Collections.sort(pluginIds, (o1, o2) -> this.getPluginNameById((String)o1).compareToIgnoreCase(this.getPluginNameById((String)o2)));
        final ComboBox pluginChooser = new ComboBox((Object[])ArrayUtilRt.toStringArray(pluginIds), 250);
        pluginChooser.setRenderer((ListCellRenderer)new ListCellRendererWrapper<String>(){

            public void customize(JList list, String value, int index, boolean selected, boolean hasFocus) {
                this.setText(ExternalDependenciesConfigurable.this.getPluginNameById(value));
            }
        });
        new ComboboxSpeedSearch((JComboBox)pluginChooser){

            @Override
            protected String getElementText(Object element) {
                return ExternalDependenciesConfigurable.this.getPluginNameById((String)element);
            }
        };
        pluginChooser.setSelectedItem((Object)original.getPluginId());
        JBTextField minVersionField = new JBTextField(StringUtil.notNullize((String)original.getMinVersion()));
        JBTextField maxVersionField = new JBTextField(StringUtil.notNullize((String)original.getMaxVersion()));
        JBTextField channelField = new JBTextField(StringUtil.notNullize((String)original.getChannel()));
        minVersionField.getEmptyText().setText("<any>");
        minVersionField.setColumns(10);
        maxVersionField.getEmptyText().setText("<any>");
        maxVersionField.setColumns(10);
        channelField.setColumns(10);
        JPanel panel = FormBuilder.createFormBuilder().addLabeledComponent("Plugin:", (JComponent)pluginChooser).addLabeledComponent("Minimum version:", (JComponent)minVersionField).addLabeledComponent("Maximum version:", (JComponent)maxVersionField).addLabeledComponent("Channel:", (JComponent)channelField).getPanel();
        final DialogBuilder dialogBuilder = new DialogBuilder((Component)parent).title("Required Plugin").centerPanel((JComponent)panel);
        dialogBuilder.setPreferredFocusComponent((JComponent)pluginChooser);
        pluginChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialogBuilder.setOkActionEnabled(!StringUtil.isEmpty((String)((String)pluginChooser.getSelectedItem())));
            }
        });
        if (dialogBuilder.show() == 0) {
            return new DependencyOnPlugin((String)pluginChooser.getSelectedItem(), StringUtil.nullize((String)minVersionField.getText().trim()), StringUtil.nullize((String)maxVersionField.getText().trim()), StringUtil.nullize((String)channelField.getText().trim()));
        }
        return null;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nullable
    public String getHelpTopic() {
        return "Required_Plugin";
    }

    public void disposeUIResources() {
    }
}

