/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class Utils {
    private Utils() {
    }

    public static void showCompletionPopup(JComponent toolbarComponent, JList list, String title, JTextComponent textField, String ad) {
        Runnable callback = () -> {
            String selectedValue = (String)list.getSelectedValue();
            if (selectedValue != null) {
                textField.setText(selectedValue);
            }
        };
        PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder(list);
        if (title != null) {
            builder.setTitle(title);
        }
        JBPopup popup = builder.setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(callback).createPopup();
        if (ad != null) {
            popup.setAdText(ad, 2);
        }
        if (toolbarComponent != null) {
            popup.showUnderneathOf((Component)toolbarComponent);
        } else {
            popup.showUnderneathOf((Component)textField);
        }
    }

    public static void setSmallerFont(JComponent component) {
        if (SystemInfo.isMac) {
            component.setFont((Font)JBUI.Fonts.smallFont());
        }
    }

    public static void setSmallerFontForChildren(JComponent component) {
        for (Component c : component.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            Utils.setSmallerFont((JComponent)c);
        }
    }

    @NotNull
    public static CustomShortcutSet shortcutSetOf(@NotNull List<Shortcut> shortcuts) {
        if (shortcuts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcuts", "com/intellij/find/editorHeaderActions/Utils", "shortcutSetOf"));
        }
        CustomShortcutSet customShortcutSet = new CustomShortcutSet(shortcuts.toArray(new Shortcut[shortcuts.size()]));
        if (customShortcutSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/editorHeaderActions/Utils", "shortcutSetOf"));
        }
        return customShortcutSet;
    }

    @NotNull
    public static List<Shortcut> shortcutsOf(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/find/editorHeaderActions/Utils", "shortcutsOf"));
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        List list = action == null ? ContainerUtil.emptyList() : ContainerUtil.immutableList((Object[])action.getShortcutSet().getShortcuts());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/editorHeaderActions/Utils", "shortcutsOf"));
        }
        return list;
    }
}

