/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.addSupport;

import com.intellij.framework.FrameworkOrGroup;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class FrameworkSupportInModuleProvider
implements FrameworkOrGroup {
    @NotNull
    public abstract FrameworkTypeEx getFrameworkType();

    @NotNull
    public abstract FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel var1);

    public abstract boolean isEnabledForModuleType(@NotNull ModuleType var1);

    public boolean isEnabledForModuleBuilder(@NotNull ModuleBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/framework/addSupport/FrameworkSupportInModuleProvider", "isEnabledForModuleBuilder"));
        }
        return this.isEnabledForModuleType(builder.getModuleType());
    }

    public boolean isSupportAlreadyAdded(@NotNull Module module2, @NotNull FacetsProvider facetsProvider) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/framework/addSupport/FrameworkSupportInModuleProvider", "isSupportAlreadyAdded"));
        }
        if (facetsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetsProvider", "com/intellij/framework/addSupport/FrameworkSupportInModuleProvider", "isSupportAlreadyAdded"));
        }
        return false;
    }

    public boolean canAddSupport(@NotNull Module module2, @NotNull FacetsProvider facetsProvider) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/framework/addSupport/FrameworkSupportInModuleProvider", "canAddSupport"));
        }
        if (facetsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetsProvider", "com/intellij/framework/addSupport/FrameworkSupportInModuleProvider", "canAddSupport"));
        }
        return !this.isSupportAlreadyAdded(module2, facetsProvider);
    }

    @Override
    public String getPresentableName() {
        return this.getFrameworkType().getPresentableName();
    }

    public FrameworkRole[] getRoles() {
        return this.getFrameworkType().getRoles();
    }

    public String getVersionLabel() {
        return "Version:";
    }

    public List<FrameworkDependency> getDependenciesFrameworkIds() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.getFrameworkType().getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/addSupport/FrameworkSupportInModuleProvider", "getId"));
        }
        return string;
    }

    @Override
    public Icon getIcon() {
        return this.getFrameworkType().getIcon();
    }

    public String toString() {
        return this.getPresentableName();
    }

    public static class FrameworkDependency {
        private final String myFrameworkId;
        private final boolean myOptional;

        private FrameworkDependency(String frameworkId, boolean optional) {
            this.myFrameworkId = frameworkId;
            this.myOptional = optional;
        }

        public static FrameworkDependency optional(String frameworkId) {
            return new FrameworkDependency(frameworkId, true);
        }

        public static FrameworkDependency required(String frameworkId) {
            return new FrameworkDependency(frameworkId, false);
        }

        public String getFrameworkId() {
            return this.myFrameworkId;
        }

        public boolean isOptional() {
            return this.myOptional;
        }
    }
}

