/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.diff.Block;
import com.intellij.history.core.Content;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.Progress;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class SelectionCalculator {
    private static final Block EMPTY_BLOCK = new Block("", 0, 0);
    private final IdeaGateway myGateway;
    private final List<Revision> myRevisions;
    private final int myFromLine;
    private final int myToLine;
    private final Map<Integer, Block> myCache = new HashMap<Integer, Block>();

    public SelectionCalculator(IdeaGateway gw, List<Revision> rr, int fromLine, int toLine) {
        this.myGateway = gw;
        this.myRevisions = rr;
        this.myFromLine = fromLine;
        this.myToLine = toLine;
    }

    public boolean canCalculateFor(Revision r, Progress p) throws FilesTooBigForDiffException {
        try {
            this.doGetSelectionFor(r, p);
        }
        catch (ContentIsUnavailableException e) {
            return false;
        }
        return true;
    }

    public Block getSelectionFor(Revision r, Progress p) throws FilesTooBigForDiffException {
        return this.doGetSelectionFor(r, p);
    }

    private Block doGetSelectionFor(Revision r, Progress p) throws FilesTooBigForDiffException {
        int target = this.myRevisions.indexOf(r);
        return this.getSelectionFor(target, target + 1, p);
    }

    private Block getSelectionFor(int revisionIndex, int totalRevisions, Progress p) throws FilesTooBigForDiffException {
        Block result2;
        Block cached = this.myCache.get(revisionIndex);
        if (cached != null) {
            return cached;
        }
        String content = this.getRevisionContent(this.myRevisions.get(revisionIndex));
        p.processed((totalRevisions - revisionIndex) * 100 / totalRevisions);
        if (content == null) {
            result2 = EMPTY_BLOCK;
        } else if (revisionIndex == 0) {
            result2 = new Block(content, this.myFromLine, this.myToLine + 1);
        } else {
            Block prev = EMPTY_BLOCK;
            int i = revisionIndex;
            while (prev == EMPTY_BLOCK && i > 0) {
                prev = this.getSelectionFor(--i, totalRevisions, p);
            }
            result2 = prev.createPreviousBlock(content);
        }
        this.myCache.put(revisionIndex, result2);
        return result2;
    }

    @Nullable
    private String getRevisionContent(Revision r) {
        Entry e = r.findEntry();
        if (e == null) {
            return null;
        }
        Content c = e.getContent();
        if (!c.isAvailable()) {
            throw new ContentIsUnavailableException();
        }
        return c.getString(e, this.myGateway);
    }

    private static class ContentIsUnavailableException
    extends RuntimeException {
        private ContentIsUnavailableException() {
        }
    }
}

