/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.annotations.NotNull;

public class FixLineSeparatorsAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile[] vFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (project2 == null || vFiles == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            for (VirtualFile vFile : vFiles) {
                FixLineSeparatorsAction.fixSeparators(vFile);
            }
        }, "fixing line separators", null);
    }

    private static void fixSeparators(VirtualFile vFile) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)vFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                Document document2;
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/FixLineSeparatorsAction$1", "visitFile"));
                }
                if (!file2.isDirectory() && !file2.getFileType().isBinary() && FixLineSeparatorsAction.areSeparatorsBroken(document2 = FileDocumentManager.getInstance().getDocument(file2))) {
                    FixLineSeparatorsAction.fixSeparators(document2);
                }
                return true;
            }
        });
    }

    private static boolean areSeparatorsBroken(Document document2) {
        int count = document2.getLineCount();
        for (int i = 1; i < count; i += 2) {
            if (document2.getLineStartOffset(i) == document2.getLineEndOffset(i)) continue;
            return false;
        }
        return true;
    }

    private static void fixSeparators(Document document2) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (int i = 1; i < document2.getLineCount(); ++i) {
                int start = document2.getLineEndOffset(i);
                int end = document2.getLineEndOffset(i) + document2.getLineSeparatorLength(i);
                document2.deleteString(start, end);
            }
        });
    }
}

