/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoActionItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionAction
extends GotoActionBase
implements DumbAware {
    @Override
    public void gotoActionPerformed(final @NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoActionAction", "gotoActionPerformed"));
        }
        final Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        final Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.action");
        GotoActionModel model = new GotoActionModel(project2, component, editor, file2);
        GotoActionBase.GotoActionCallback<Object> callback = new GotoActionBase.GotoActionCallback<Object>(){

            @Override
            public void elementChosen(@NotNull ChooseByNamePopup popup, @NotNull Object element) {
                if (popup == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ide/actions/GotoActionAction$1", "elementChosen"));
                }
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/actions/GotoActionAction$1", "elementChosen"));
                }
                if (project2 != null) {
                    project2.putUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, null);
                }
                String enteredText = popup.getTrimmedText();
                GotoActionAction.openOptionOrPerformAction(((GotoActionModel.MatchedValue)element).value, enteredText, project2, component, e);
            }
        };
        Pair<String, Integer> start = GotoActionAction.getInitialText(false, e);
        this.showNavigationPopup(callback, null, GotoActionAction.createPopup(project2, model, (String)start.first, (Integer)start.second, component, e), false);
    }

    @Nullable
    private static ChooseByNamePopup createPopup(@Nullable Project project2, final @NotNull GotoActionModel model, String initialText, int initialIndex, final Component component, final AnActionEvent e) {
        ChooseByNamePopup oldPopup;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/actions/GotoActionAction", "createPopup"));
        }
        ChooseByNamePopup chooseByNamePopup = oldPopup = project2 == null ? null : (ChooseByNamePopup)project2.getUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY);
        if (oldPopup != null) {
            oldPopup.close(false);
        }
        final Disposable disposable = Disposer.newDisposable();
        final ChooseByNamePopup popup = new ChooseByNamePopup(project2, model, new GotoActionItemProvider(model), oldPopup, initialText, false, initialIndex){

            @Override
            protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
                super.initUI(callback, modalityState, allowMultipleSelection);
                this.myList.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        Object value = myList.getSelectedValue();
                        String text = this.getText(value);
                        if (text != null && myDropdownPopup != null) {
                            myDropdownPopup.setAdText(text, 2);
                        }
                    }

                    @Nullable
                    private String getText(@Nullable Object o) {
                        if (o instanceof GotoActionModel.MatchedValue) {
                            GotoActionModel.MatchedValue mv = (GotoActionModel.MatchedValue)o;
                            if (mv.value instanceof BooleanOptionDescription || mv.value instanceof GotoActionModel.ActionWrapper && ((GotoActionModel.ActionWrapper)mv.value).getAction() instanceof ToggleAction) {
                                return "Press " + KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(10, 0)) + " to toggle option";
                            }
                        }
                        return this.getAdText();
                    }
                });
            }

            @Override
            @NotNull
            protected Set<Object> filter(@NotNull Set<Object> elements) {
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/actions/GotoActionAction$2", "filter"));
                }
                Set<Object> set = super.filter(model.sort(elements));
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/GotoActionAction$2", "filter"));
                }
                return set;
            }

            @Override
            protected boolean closeForbidden(boolean ok) {
                if (!ok) {
                    return false;
                }
                Object element = this.getChosenElement();
                return element instanceof GotoActionModel.MatchedValue && GotoActionAction.processOptionInplace(((GotoActionModel.MatchedValue)element).value, this, component, e) || super.closeForbidden(true);
            }

            @Override
            public void setDisposed(boolean disposedFlag) {
                super.setDisposed(disposedFlag);
                Disposer.dispose((Disposable)disposable);
                for (ListSelectionListener listener2 : this.myList.getListSelectionListeners()) {
                    this.myList.removeListSelectionListener(listener2);
                }
                UIUtil.dispose((Component)this.myList);
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(ProgressWindow.TOPIC, (Object)new ProgressWindow.Listener(){

            @Override
            public void progressWindowCreated(ProgressWindow pw) {
                Disposer.register((Disposable)pw, (Disposable)new Disposable(){

                    public void dispose() {
                        if (!popup.checkDisposed()) {
                            popup.repaintList();
                        }
                    }
                });
            }
        });
        if (project2 != null) {
            project2.putUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, (Object)popup);
        }
        popup.addMouseClickListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent me) {
                if (me == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me", "com/intellij/ide/actions/GotoActionAction$4", "mouseClicked"));
                }
                Object element = popup.getSelectionByPoint(me.getPoint());
                if (element instanceof GotoActionModel.MatchedValue && GotoActionAction.processOptionInplace(((GotoActionModel.MatchedValue)element).value, popup, component, e)) {
                    me.consume();
                }
            }
        });
        CustomShortcutSet shortcutSet = new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("ShowIntentionActions"));
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                GotoActionModel.ActionWrapper aw;
                boolean available;
                Comparable value;
                Object o = popup.getChosenElement();
                if (o instanceof GotoActionModel.MatchedValue && (value = ((GotoActionModel.MatchedValue)o).value) instanceof GotoActionModel.ActionWrapper && (available = (aw = (GotoActionModel.ActionWrapper)value).isAvailable())) {
                    AnAction action = aw.getAction();
                    String id = ActionManager.getInstance().getId(action);
                    KeymapManagerImpl km = (KeymapManagerImpl)KeymapManager.getInstance();
                    Keymap k = km.getActiveKeymap();
                    if (!k.canModify()) {
                        return;
                    }
                    KeymapPanel.addKeyboardShortcut(id, ActionShortcutRestrictions.getInstance().getForActionId(id), k, component, new QuickList[0]);
                    popup.repaintListImmediate();
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)shortcutSet, (JComponent)popup.getTextField(), disposable);
        return popup;
    }

    private static boolean processOptionInplace(Object value, ChooseByNamePopup popup, Component component, AnActionEvent e) {
        AnAction action;
        if (value instanceof BooleanOptionDescription) {
            BooleanOptionDescription option;
            option.setOptionState(!(option = (BooleanOptionDescription)value).isOptionEnabled());
            GotoActionAction.repaint(popup);
            return true;
        }
        if (value instanceof GotoActionModel.ActionWrapper && (action = ((GotoActionModel.ActionWrapper)value).getAction()) instanceof ToggleAction) {
            GotoActionAction.performAction(action, component, e);
            GotoActionAction.repaint(popup);
            return true;
        }
        return false;
    }

    private static void repaint(@Nullable ChooseByNamePopup popup) {
        if (popup != null) {
            popup.repaintListImmediate();
        }
    }

    public static void openOptionOrPerformAction(@NotNull Object element, String enteredText, Project project2, Component component, @Nullable AnActionEvent e) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/actions/GotoActionAction", "openOptionOrPerformAction"));
        }
        if (element instanceof OptionDescription) {
            String configurableId = ((OptionDescription)element).getConfigurableId();
            TransactionGuard.getInstance().submitTransactionLater((Disposable)project2, () -> ShowSettingsUtilImpl.showSettingsDialog(project2, configurableId, enteredText));
        } else {
            GotoActionAction.performAction(element, component, e);
        }
    }

    public static void performAction(Object element, @Nullable Component component, @Nullable AnActionEvent e) {
        if (component == null) {
            return;
        }
        AnAction action = element instanceof AnAction ? (AnAction)element : ((GotoActionModel.ActionWrapper)element).getAction();
        TransactionGuard.getInstance().submitTransactionLater((Disposable)ApplicationManager.getApplication(), () -> {
            DataManager instance;
            DataContext context;
            InputEvent inputEvent = e == null ? null : e.getInputEvent();
            AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, (InputEvent)inputEvent, (String)"GoToAction", (DataContext)(context = (instance = DataManager.getInstance()) != null ? instance.getDataContext(component) : DataContext.EMPTY_CONTEXT));
            if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)event, (boolean)false)) {
                if (action instanceof ActionGroup && ((ActionGroup)action).getChildren(event).length > 0) {
                    ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(event.getPresentation().getText(), (ActionGroup)action, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
                    Window window = SwingUtilities.getWindowAncestor(component);
                    if (window != null) {
                        popup.showInCenterOf((Component)window);
                    } else {
                        popup.showInFocusCenter();
                    }
                } else {
                    ActionUtil.performActionDumbAware((AnAction)action, (AnActionEvent)event);
                }
            }
        });
    }

    @Override
    protected boolean requiresProject() {
        return false;
    }
}

