/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.SaveFileAsTemplateDialog;
import com.intellij.ide.actions.SaveFileAsTemplateHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.FileTemplateConfigurable;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;

public class SaveFileAsTemplateAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)ObjectUtils.assertNotNull((Object)e.getData(CommonDataKeys.PROJECT));
        String fileText = (String)ObjectUtils.assertNotNull((Object)e.getData(PlatformDataKeys.FILE_TEXT));
        VirtualFile file2 = (VirtualFile)ObjectUtils.assertNotNull((Object)e.getData(CommonDataKeys.VIRTUAL_FILE));
        String extension = StringUtil.notNullize((String)file2.getExtension());
        String nameWithoutExtension = file2.getNameWithoutExtension();
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        for (SaveFileAsTemplateHandler handler2 : (SaveFileAsTemplateHandler[])Extensions.getExtensions(SaveFileAsTemplateHandler.EP_NAME)) {
            String textFromHandler = handler2.getTemplateText(psiFile, fileText, nameWithoutExtension);
            if (textFromHandler == null) continue;
            fileText = textFromHandler;
            break;
        }
        FileTemplateManager templateManager = FileTemplateManager.getInstance(project2);
        Object[] templates = templateManager.getAllTemplates();
        FileTemplate template = FileTemplateUtil.createTemplate(nameWithoutExtension, extension, fileText, (FileTemplate[])templates);
        FileTemplateConfigurable configurable = new FileTemplateConfigurable(project2);
        configurable.setProportion(0.6f);
        configurable.setTemplate(template, FileTemplateManagerImpl.getInstanceImpl(project2).getDefaultTemplateDescription());
        SaveFileAsTemplateDialog dialog = new SaveFileAsTemplateDialog(project2, (Configurable)configurable);
        if (dialog.showAndGet()) {
            templateManager.setTemplates("Default", Arrays.asList(ArrayUtil.append((Object[])templates, (Object)template)));
        }
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(e.getData(CommonDataKeys.VIRTUAL_FILE) != null && e.getData(PlatformDataKeys.FILE_TEXT) != null);
    }
}

