/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.google.common.net.HostAndPort;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Urls;
import com.intellij.util.net.NetUtils;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserStarter {
    private static final Logger LOG = Logger.getInstance(BrowserStarter.class);
    private final StartBrowserSettings mySettings;
    private final RunConfiguration myRunConfiguration;
    private final Computable<Boolean> myOutdated;

    public BrowserStarter(@NotNull RunConfiguration runConfiguration, @NotNull StartBrowserSettings settings, @NotNull Computable<Boolean> outdated) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/ide/browsers/BrowserStarter", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/ide/browsers/BrowserStarter", "<init>"));
        }
        if (outdated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outdated", "com/intellij/ide/browsers/BrowserStarter", "<init>"));
        }
        this.mySettings = settings;
        this.myRunConfiguration = runConfiguration;
        this.myOutdated = outdated;
    }

    public BrowserStarter(@NotNull RunConfiguration runConfiguration, @NotNull StartBrowserSettings settings, @NotNull ProcessHandler serverProcessHandler) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/ide/browsers/BrowserStarter", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/ide/browsers/BrowserStarter", "<init>"));
        }
        if (serverProcessHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverProcessHandler", "com/intellij/ide/browsers/BrowserStarter", "<init>"));
        }
        this(runConfiguration, settings, (Computable<Boolean>)((Computable)() -> {
            if (serverProcessHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverProcessHandler", "com/intellij/ide/browsers/BrowserStarter", "lambda$new$0"));
            }
            return serverProcessHandler.isProcessTerminating() || serverProcessHandler.isProcessTerminated();
        }));
    }

    public void start() {
        if (!this.mySettings.isSelected() || this.mySettings.getUrl() == null) {
            return;
        }
        HostAndPort hostAndPort = BrowserStarter.getHostAndPort(this.mySettings.getUrl());
        if (hostAndPort != null) {
            this.checkAndOpenPageLater(hostAndPort, 1, 300);
        } else {
            this.openPageLater(1000);
        }
    }

    @Nullable
    private static HostAndPort getHostAndPort(@NotNull String rawUrl) {
        if (rawUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawUrl", "com/intellij/ide/browsers/BrowserStarter", "getHostAndPort"));
        }
        URI url = Urls.parseAsJavaUriWithoutParameters(rawUrl);
        if (url == null) {
            return null;
        }
        int port = url.getPort();
        if (port == -1) {
            port = "https".equals(url.getScheme()) ? 443 : 80;
        }
        return HostAndPort.fromParts((String)StringUtil.notNullize((String)url.getHost(), (String)"127.0.0.1"), (int)port);
    }

    private void checkAndOpenPageLater(@NotNull HostAndPort hostAndPort, int attemptNumber, int delayMillis) {
        if (hostAndPort == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostAndPort", "com/intellij/ide/browsers/BrowserStarter", "checkAndOpenPageLater"));
        }
        JobScheduler.getScheduler().schedule(() -> {
            if (hostAndPort == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostAndPort", "com/intellij/ide/browsers/BrowserStarter", "lambda$checkAndOpenPageLater$1"));
            }
            this.checkAndOpenPage(hostAndPort, attemptNumber);
        }, (long)delayMillis, TimeUnit.MILLISECONDS);
    }

    private void checkAndOpenPage(@NotNull HostAndPort hostAndPort, int attemptNumber) {
        if (hostAndPort == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostAndPort", "com/intellij/ide/browsers/BrowserStarter", "checkAndOpenPage"));
        }
        if (NetUtils.canConnectToRemoteSocket((String)hostAndPort.getHostText(), (int)hostAndPort.getPort())) {
            this.openPageNow();
        } else {
            LOG.info("[attempt#" + attemptNumber + "] Checking " + hostAndPort + " failed");
            if (!this.isOutdated()) {
                int delayMillis = BrowserStarter.getDelayMillis(attemptNumber);
                this.checkAndOpenPageLater(hostAndPort, attemptNumber + 1, delayMillis);
            }
        }
    }

    private static int getDelayMillis(int attemptNumber) {
        if (attemptNumber < 10) {
            return 400;
        }
        if (attemptNumber < 100) {
            return 1000;
        }
        return 2000;
    }

    private void openPageLater(int millis) {
        JobScheduler.getScheduler().schedule(() -> this.openPageNow(), (long)millis, TimeUnit.MILLISECONDS);
    }

    private void openPageNow() {
        if (!this.isOutdated()) {
            JavaScriptDebuggerStarter.Util.startDebugOrLaunchBrowser(this.myRunConfiguration, this.mySettings);
        }
    }

    private boolean isOutdated() {
        return (Boolean)this.myOutdated.compute();
    }
}

