/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.commander;

import com.intellij.ide.commander.CommanderPanel;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.GroupedElementsRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

final class ColoredCommanderRenderer
extends ColoredListCellRenderer {
    private final CommanderPanel myCommanderPanel;

    public ColoredCommanderRenderer(@NotNull CommanderPanel commanderPanel) {
        if (commanderPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commanderPanel", "com/intellij/ide/commander/ColoredCommanderRenderer", "<init>"));
        }
        this.myCommanderPanel = commanderPanel;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        hasFocus = selected;
        if (!this.myCommanderPanel.isActive()) {
            selected = false;
        }
        return super.getListCellRendererComponent(list, value, index, selected, hasFocus);
    }

    protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/commander/ColoredCommanderRenderer", "customizeCellRenderer"));
        }
        if (UIUtil.isUnderGTKLookAndFeel()) {
            Color background = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
            UIUtil.changeBackGround((Component)((Object)this), (Color)background);
        }
        Color color = UIUtil.getListForeground();
        SimpleTextAttributes attributes = null;
        String locationString = null;
        this.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        if (value instanceof NodeDescriptor) {
            NodeDescriptor descriptor = (NodeDescriptor)value;
            this.setIcon(descriptor.getIcon());
            Color elementColor = descriptor.getColor();
            if (elementColor != null) {
                color = elementColor;
            }
            if (descriptor instanceof AbstractTreeNode) {
                TextAttributes textAttributes;
                AbstractTreeNode treeNode = (AbstractTreeNode)descriptor;
                TextAttributesKey attributesKey = treeNode.getAttributesKey();
                if (attributesKey != null && (textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey)) != null) {
                    attributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
                }
                locationString = treeNode.getLocationString();
                PresentationData presentation = treeNode.getPresentation();
                if (presentation.hasSeparatorAbove() && !selected) {
                    this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, GroupedElementsRenderer.POPUP_SEPARATOR_FOREGROUND), BorderFactory.createEmptyBorder(0, 0, 1, 0)));
                }
            }
        }
        if (attributes == null) {
            attributes = new SimpleTextAttributes(0, color);
        }
        String text = value.toString();
        if (this.myCommanderPanel.isEnableSearchHighlighting()) {
            JList list1 = this.myCommanderPanel.getList();
            if (list1 != null) {
                SpeedSearchUtil.appendFragmentsForSpeedSearch((JComponent)list1, (String)text, (SimpleTextAttributes)attributes, (boolean)selected, (SimpleColoredComponent)this);
            }
        } else {
            this.append(text != null ? text : "", attributes);
        }
        if (locationString != null && locationString.length() > 0) {
            this.append(" (" + locationString + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }
}

