/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.SelectInManager;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.impl.SelectInTargetPsiWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesViewSelectInTarget
extends SelectInTargetPsiWrapper {
    public FavoritesViewSelectInTarget(Project project2) {
        super(project2);
    }

    @Override
    public String toString() {
        return SelectInManager.FAVORITES;
    }

    public String getToolWindowId() {
        return SelectInManager.FAVORITES;
    }

    @Override
    protected void select(Object selector, VirtualFile virtualFile, boolean requestFocus) {
        FavoritesViewSelectInTarget.select(this.myProject, selector, null, null, virtualFile, requestFocus);
    }

    @Override
    protected void select(PsiElement element, boolean requestFocus) {
        PsiElement toSelect = null;
        if (element instanceof PsiFile || element instanceof PsiDirectory) {
            toSelect = element;
        } else {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null) {
                return;
            }
            FileViewProvider viewProvider = containingFile.getViewProvider();
            toSelect = viewProvider.getPsi(viewProvider.getBaseLanguage());
        }
        if (toSelect == null) {
            return;
        }
        PsiElement originalElement = toSelect.getOriginalElement();
        VirtualFile virtualFile = PsiUtilBase.getVirtualFile((PsiElement)originalElement);
        this.select(originalElement, virtualFile, requestFocus);
    }

    public static ActionCallback select(@NotNull Project project2, Object toSelect, @Nullable String viewId, @Nullable String subviewId, VirtualFile virtualFile, boolean requestFocus) {
        FavoritesTreeViewPanel panel;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/favoritesTreeView/FavoritesViewSelectInTarget", "select"));
        }
        ActionCallback result2 = new ActionCallback();
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project2);
        ToolWindow favoritesToolWindow = windowManager.getToolWindow(ToolWindowId.FAVORITES_VIEW);
        if (favoritesToolWindow != null && (panel = (FavoritesTreeViewPanel)UIUtil.findComponentOfType((JComponent)favoritesToolWindow.getComponent(), FavoritesTreeViewPanel.class)) != null) {
            Runnable runnable2 = () -> {
                panel.selectElement(toSelect, virtualFile, requestFocus);
                result2.setDone();
            };
            if (requestFocus) {
                favoritesToolWindow.activate(runnable2, false);
            } else {
                favoritesToolWindow.show(runnable2);
            }
        }
        return result2;
    }

    @Override
    protected boolean canSelect(PsiFileSystemItem file2) {
        return FavoritesViewSelectInTarget.findSuitableFavoritesList(file2.getVirtualFile(), this.myProject, null) != null;
    }

    public static String findSuitableFavoritesList(VirtualFile file2, Project project2, String currentSubId) {
        return FavoritesManager.getInstance(project2).getFavoriteListName(currentSubId, file2);
    }

    public String getMinorViewId() {
        return "Favorites";
    }

    public float getWeight() {
        return 1.01f;
    }

    @Override
    protected boolean canWorkWithCustomObjects() {
        return false;
    }
}

