/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.LanguageMethodHierarchy;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.psi.PsiElement;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;

public abstract class MethodHierarchyBrowserBase
extends HierarchyBrowserBaseEx {
    public static final String METHOD_TYPE = IdeBundle.message((String)"title.hierarchy.method", (Object[])new Object[0]);
    public static final DataKey<MethodHierarchyBrowserBase> DATA_KEY = DataKey.create((String)"com.intellij.ide.hierarchy.MethodHierarchyBrowserBase");

    public MethodHierarchyBrowserBase(Project project2, PsiElement method) {
        super(project2, method);
    }

    @Override
    @NotNull
    protected String getPrevOccurenceActionNameImpl() {
        String string = IdeBundle.message((String)"hierarchy.method.prev.occurence.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/MethodHierarchyBrowserBase", "getPrevOccurenceActionNameImpl"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getNextOccurenceActionNameImpl() {
        String string = IdeBundle.message((String)"hierarchy.method.next.occurence.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/MethodHierarchyBrowserBase", "getNextOccurenceActionNameImpl"));
        }
        return string;
    }

    protected static JPanel createStandardLegendPanel(String methodDefinedText, String methodNotDefinedLegallyText, String methodShouldBeDefined) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 0, 5), 0, 0);
        JLabel label = new JLabel(methodDefinedText, AllIcons.Hierarchy.MethodDefined, 2);
        label.setUI((LabelUI)new MultiLineLabelUI());
        label.setIconTextGap(10);
        panel.add((Component)label, gc);
        ++gc.gridy;
        label = new JLabel(methodNotDefinedLegallyText, AllIcons.Hierarchy.MethodNotDefined, 2);
        label.setUI((LabelUI)new MultiLineLabelUI());
        label.setIconTextGap(10);
        panel.add((Component)label, gc);
        ++gc.gridy;
        label = new JLabel(methodShouldBeDefined, AllIcons.Hierarchy.ShouldDefineMethod, 2);
        label.setUI((LabelUI)new MultiLineLabelUI());
        label.setIconTextGap(10);
        panel.add((Component)label, gc);
        return panel;
    }

    @Override
    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ide/hierarchy/MethodHierarchyBrowserBase", "prependActions"));
        }
        actionGroup.add((AnAction)new HierarchyBrowserBaseEx.AlphaSortAction());
        actionGroup.add((AnAction)new ShowImplementationsOnlyAction());
    }

    @Override
    @NotNull
    protected String getBrowserDataKey() {
        String string = DATA_KEY.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/MethodHierarchyBrowserBase", "getBrowserDataKey"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getActionPlace() {
        if ("MethodHierarchyViewToolbar" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/MethodHierarchyBrowserBase", "getActionPlace"));
        }
        return "MethodHierarchyViewToolbar";
    }

    public static class BaseOnThisMethodAction
    extends HierarchyBrowserBaseEx.BaseOnThisElementAction {
        public BaseOnThisMethodAction() {
            super(IdeBundle.message((String)"action.base.on.this.method", (Object[])new Object[0]), DATA_KEY.getName(), (LanguageExtension<HierarchyProvider>)LanguageMethodHierarchy.INSTANCE);
        }
    }

    private final class ShowImplementationsOnlyAction
    extends ToggleAction {
        private ShowImplementationsOnlyAction() {
            super(IdeBundle.message((String)"action.hide.non.implementations", (Object[])new Object[0]), null, AllIcons.General.Filter);
        }

        public final boolean isSelected(AnActionEvent event) {
            return HierarchyBrowserManager.getInstance((Project)MethodHierarchyBrowserBase.this.myProject).getState().HIDE_CLASSES_WHERE_METHOD_NOT_IMPLEMENTED;
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            HierarchyBrowserManager.getInstance((Project)MethodHierarchyBrowserBase.this.myProject).getState().HIDE_CLASSES_WHERE_METHOD_NOT_IMPLEMENTED = flag;
            ApplicationManager.getApplication().invokeLater(() -> MethodHierarchyBrowserBase.this.doRefresh(true));
        }

        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/hierarchy/MethodHierarchyBrowserBase$ShowImplementationsOnlyAction", "update"));
            }
            super.update(event);
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(MethodHierarchyBrowserBase.this.isValidBase());
        }
    }
}

