/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.PathUtilEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public final class JdkPathMacro
extends Macro {
    @Override
    public String getName() {
        return "JDKPath";
    }

    @Override
    public String getDescription() {
        return IdeBundle.message((String)"macro.jdk.path", (Object[])new Object[0]);
    }

    @Override
    public String expand(DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return null;
        }
        Sdk anyJdk = PathUtilEx.getAnyJdk(project2);
        return JdkPathMacro.sdkPath(anyJdk);
    }

    @Nullable
    static String sdkPath(@Nullable Sdk anyJdk) {
        if (anyJdk == null) {
            return null;
        }
        String jdkHomePath = PathUtil.getLocalPath((VirtualFile)anyJdk.getHomeDirectory());
        if (jdkHomePath != null) {
            jdkHomePath = jdkHomePath.replace('/', File.separatorChar);
        }
        return jdkHomePath;
    }
}

