/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Map;

public class ModuleGroupUtil {
    private ModuleGroupUtil() {
    }

    public static <T> T buildModuleGroupPath(ModuleGroup group, T parentNode, Map<ModuleGroup, T> map, Consumer<ParentChildRelation<T>> insertNode, Function<ModuleGroup, T> createNewNode) {
        String[] groupPath;
        ArrayList<String> path = new ArrayList<String>();
        for (String pathElement : groupPath = group.getGroupPath()) {
            path.add(pathElement);
            ModuleGroup moduleGroup = new ModuleGroup(ArrayUtil.toStringArray(path));
            Object moduleGroupNode = map.get(moduleGroup);
            if (moduleGroupNode == null) {
                moduleGroupNode = createNewNode.fun((Object)moduleGroup);
                map.put(moduleGroup, moduleGroupNode);
                insertNode.consume(new ParentChildRelation<T>(parentNode, moduleGroupNode));
            }
            parentNode = moduleGroupNode;
        }
        return parentNode;
    }

    public static <T> T updateModuleGroupPath(ModuleGroup group, T parentNode, Function<ModuleGroup, T> needToCreateNode, Consumer<ParentChildRelation<T>> insertNode, Function<ModuleGroup, T> createNewNode) {
        String[] groupPath;
        ArrayList<String> path = new ArrayList<String>();
        for (String pathElement : groupPath = group.getGroupPath()) {
            path.add(pathElement);
            ModuleGroup moduleGroup = new ModuleGroup(ArrayUtil.toStringArray(path));
            Object moduleGroupNode = needToCreateNode.fun((Object)moduleGroup);
            if (moduleGroupNode == null) {
                moduleGroupNode = createNewNode.fun((Object)moduleGroup);
                insertNode.consume(new ParentChildRelation<Object>(parentNode, moduleGroupNode));
            }
            parentNode = moduleGroupNode;
        }
        return parentNode;
    }

    public static class ParentChildRelation<T> {
        private final T myParent;
        private final T myChild;

        public ParentChildRelation(T parent, T child) {
            this.myParent = parent;
            this.myChild = child;
        }

        public T getParent() {
            return this.myParent;
        }

        public T getChild() {
            return this.myChild;
        }
    }
}

