/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.PsiClassChildrenSource;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.BasePsiMemberNode;
import com.intellij.ide.projectView.impl.nodes.PsiFieldNode;
import com.intellij.ide.projectView.impl.nodes.PsiMethodNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class ClassTreeNode
extends BasePsiMemberNode<PsiClass> {
    public ClassTreeNode(Project project2, PsiClass value, ViewSettings viewSettings) {
        super(project2, value, viewSettings);
    }

    @Override
    public Collection<AbstractTreeNode> getChildrenImpl() {
        PsiClass parent = (PsiClass)this.getValue();
        ArrayList<AbstractTreeNode> treeNodes = new ArrayList<AbstractTreeNode>();
        if (this.getSettings().isShowMembers()) {
            ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
            PsiClassChildrenSource.DEFAULT_CHILDREN.addChildren(parent, result2);
            for (PsiElement psiElement : result2) {
                if (!psiElement.isPhysical()) continue;
                if (psiElement instanceof PsiClass) {
                    treeNodes.add((AbstractTreeNode)new ClassTreeNode(this.getProject(), (PsiClass)psiElement, this.getSettings()));
                    continue;
                }
                if (psiElement instanceof PsiMethod) {
                    treeNodes.add((AbstractTreeNode)new PsiMethodNode(this.getProject(), (PsiMethod)psiElement, this.getSettings()));
                    continue;
                }
                if (!(psiElement instanceof PsiField)) continue;
                treeNodes.add((AbstractTreeNode)new PsiFieldNode(this.getProject(), (PsiField)psiElement, this.getSettings()));
            }
        }
        return treeNodes;
    }

    public boolean isAlwaysLeaf() {
        return !this.getSettings().isShowMembers();
    }

    @Override
    public void updateImpl(PresentationData data) {
        PsiClass aClass = (PsiClass)this.getValue();
        if (aClass != null) {
            data.setPresentableText(aClass.getName());
        }
    }

    public boolean isTopLevel() {
        return this.getValue() != null && ((PsiClass)this.getValue()).getParent() instanceof PsiFile;
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    public PsiClass getPsiClass() {
        return (PsiClass)this.getValue();
    }

    public boolean isAlwaysExpand() {
        return this.getParentValue() instanceof PsiFile;
    }

    public int getWeight() {
        return 20;
    }

    public String getTitle() {
        PsiClass psiClass = (PsiClass)this.getValue();
        if (psiClass != null && psiClass.isValid()) {
            return psiClass.getQualifiedName();
        }
        return super.getTitle();
    }

    @Override
    protected boolean isMarkReadOnly() {
        return true;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return sortByType ? 5 : 0;
    }

    public Comparable getTypeSortKey() {
        return new ClassNameSortKey();
    }

    public static int getClassPosition(PsiClass aClass) {
        if (aClass == null || !aClass.isValid()) {
            return 0;
        }
        try {
            int pos;
            int n = pos = aClass instanceof JspClass ? 70 : ElementPresentationUtil.getClassKind(aClass);
            if (pos == 30 || pos == 80) {
                boolean isAbstract;
                boolean bl = isAbstract = aClass.hasModifierProperty("abstract") && !aClass.isInterface();
                if (isAbstract) {
                    --pos;
                }
            }
            return pos;
        }
        catch (IndexNotReadyException e) {
            return 0;
        }
    }

    public boolean shouldDrillDownOnEmptyElement() {
        return true;
    }

    public boolean canRepresent(Object element) {
        if (!this.isValid()) {
            return false;
        }
        return super.canRepresent(element) || this.canRepresent((PsiClass)this.getValue(), element);
    }

    private boolean canRepresent(PsiClass psiClass, Object element) {
        PsiFile elementFile;
        if (psiClass == null || !psiClass.isValid() || element == null) {
            return false;
        }
        PsiFile parentFile = ClassTreeNode.parentFileOf(psiClass);
        if (parentFile != null && (parentFile == element || element.equals(parentFile.getVirtualFile()))) {
            return true;
        }
        if (!this.getSettings().isShowMembers() && element instanceof PsiElement && ((PsiElement)element).isValid() && (elementFile = ((PsiElement)element).getContainingFile()) != null && parentFile != null) {
            return elementFile.equals(parentFile);
        }
        return false;
    }

    @Nullable
    private static PsiFile parentFileOf(PsiClass psiClass) {
        return psiClass.getContainingClass() == null ? psiClass.getContainingFile() : null;
    }

    private class ClassNameSortKey
    implements Comparable {
        private ClassNameSortKey() {
        }

        public int compareTo(Object o) {
            if (!(o instanceof ClassNameSortKey)) {
                return 0;
            }
            ClassNameSortKey rhs = (ClassNameSortKey)o;
            return this.getPosition() - rhs.getPosition();
        }

        int getPosition() {
            return ClassTreeNode.getClassPosition((PsiClass)ClassTreeNode.this.getValue());
        }
    }
}

