/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.FileIconProvider;
import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.ide.scratch.LightDirectoryIndex;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.lang.PerFileMappingsBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighterProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PairConsumer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ScratchFileService", storages={@Storage(value="scratches.xml")})
public class ScratchFileServiceImpl
extends ScratchFileService
implements PersistentStateComponent<Element> {
    private static final RootType NULL_TYPE = new RootType("", null){};
    private final LightDirectoryIndex<RootType> myIndex;
    private final MyLanguages myScratchMapping = new MyLanguages();

    protected ScratchFileServiceImpl(MessageBus messageBus) {
        this.myIndex = new LightDirectoryIndex<RootType>(messageBus.connect(), NULL_TYPE){

            @Override
            protected void collectRoots(@NotNull PairConsumer<VirtualFile, RootType> consumer) {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/ide/scratch/ScratchFileServiceImpl$2", "collectRoots"));
                }
                LocalFileSystem fileSystem = LocalFileSystem.getInstance();
                for (RootType r : RootType.getAllRootIds()) {
                    String root = ScratchFileServiceImpl.this.getRootPath(r);
                    VirtualFile rootFile = fileSystem.findFileByPath(root);
                    if (rootFile == null) continue;
                    consumer.consume((Object)rootFile, (Object)r);
                }
            }
        };
        this.initFileOpenedListener(messageBus);
    }

    @Override
    @NotNull
    public String getRootPath(@NotNull RootType rootId) {
        if (rootId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootId", "com/intellij/ide/scratch/ScratchFileServiceImpl", "getRootPath"));
        }
        String string = this.getRootPath() + "/" + rootId.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileServiceImpl", "getRootPath"));
        }
        return string;
    }

    @Override
    @Nullable
    public RootType getRootType(@Nullable VirtualFile file2) {
        VirtualFile directory;
        if (file2 == null) {
            return null;
        }
        VirtualFile virtualFile = directory = file2.isDirectory() ? file2 : file2.getParent();
        if (!(directory instanceof VirtualFileWithId)) {
            return null;
        }
        RootType result2 = this.myIndex.getInfoForFile(directory);
        return result2 == NULL_TYPE ? null : result2;
    }

    private void initFileOpenedListener(MessageBus messageBus) {
        final FileEditorManagerAdapter editorListener = new FileEditorManagerAdapter(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/scratch/ScratchFileServiceImpl$3", "fileOpened"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileServiceImpl$3", "fileOpened"));
                }
                if (!this.isEditable(file2)) {
                    return;
                }
                RootType rootType = ScratchFileServiceImpl.this.getRootType(file2);
                if (rootType == null) {
                    return;
                }
                rootType.fileOpened(file2, source);
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/scratch/ScratchFileServiceImpl$3", "fileClosed"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileServiceImpl$3", "fileClosed"));
                }
                if (Boolean.TRUE.equals(file2.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN))) {
                    return;
                }
                if (!this.isEditable(file2)) {
                    return;
                }
                RootType rootType = ScratchFileServiceImpl.this.getRootType(file2);
                if (rootType == null) {
                    return;
                }
                rootType.fileClosed(file2, source);
            }

            boolean isEditable(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileServiceImpl$3", "isEditable"));
                }
                return FileDocumentManager.getInstance().getDocument(file2) != null;
            }
        };
        ProjectManagerAdapter projectListener = new ProjectManagerAdapter(){

            public void projectOpened(Project project2) {
                project2.getMessageBus().connect((Disposable)project2).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)editorListener);
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)project2);
                for (VirtualFile virtualFile : editorManager.getOpenFiles()) {
                    editorListener.fileOpened(editorManager, virtualFile);
                }
            }
        };
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            projectListener.projectOpened(project2);
        }
        messageBus.connect().subscribe(ProjectManager.TOPIC, (Object)projectListener);
    }

    @NotNull
    protected String getRootPath() {
        String string = FileUtil.toSystemIndependentName((String)PathManager.getScratchPath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileServiceImpl", "getRootPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public PerFileMappings<Language> getScratchesMapping() {
        MyLanguages myLanguages = this.myScratchMapping;
        if (myLanguages == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileServiceImpl", "getScratchesMapping"));
        }
        return myLanguages;
    }

    @Nullable
    public Element getState() {
        return this.myScratchMapping.getState();
    }

    public void loadState(Element state) {
        this.myScratchMapping.loadState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualFile findFile(@NotNull RootType rootType, @NotNull String pathName, @NotNull ScratchFileService.Option option) throws IOException {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/ide/scratch/ScratchFileServiceImpl", "findFile"));
        }
        if (pathName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathName", "com/intellij/ide/scratch/ScratchFileServiceImpl", "findFile"));
        }
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/ide/scratch/ScratchFileServiceImpl", "findFile"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String fullPath = this.getRootPath(rootType) + "/" + pathName;
        if (option != ScratchFileService.Option.create_new_always) {
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(fullPath);
            if (file2 != null && !file2.isDirectory()) {
                return file2;
            }
            if (option == ScratchFileService.Option.existing_only) {
                return null;
            }
        }
        String ext = PathUtil.getFileExtension((String)pathName);
        String fileNameExt = PathUtil.getFileName((String)pathName);
        String fileName = StringUtil.trimEnd((String)fileNameExt, (String)(ext == null ? "" : "." + ext));
        AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(this.getClass());
        try {
            VirtualFile dir = VfsUtil.createDirectories((String)PathUtil.getParentPath((String)fullPath));
            if (option == ScratchFileService.Option.create_new_always) {
                VirtualFile virtualFile = VfsUtil.createChildSequent((Object)LocalFileSystem.getInstance(), (VirtualFile)dir, (String)fileName, (String)StringUtil.notNullize((String)ext));
                return virtualFile;
            }
            VirtualFile virtualFile = dir.createChildData((Object)LocalFileSystem.getInstance(), fileNameExt);
            return virtualFile;
        }
        finally {
            token.finish();
        }
    }

    @Nullable
    private static Language getLanguageByFileName(@Nullable VirtualFile file2) {
        return file2 == null ? null : LanguageUtil.getFileTypeLanguage((FileType)FileTypeManager.getInstance().getFileTypeByFileName(file2.getName()));
    }

    public static class NavBarExtension
    extends AbstractNavBarModelExtension {
        @Override
        @Nullable
        public String getPresentableText(Object object) {
            if (!(object instanceof PsiElement)) {
                return null;
            }
            Project project2 = ((PsiElement)object).getProject();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)object));
            if (virtualFile == null || !virtualFile.isValid()) {
                return null;
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(virtualFile);
            if (rootType == null) {
                return null;
            }
            if (virtualFile.isDirectory() && this.additionalRoots(project2).contains(virtualFile)) {
                return rootType.getDisplayName();
            }
            return rootType.substituteName(project2, virtualFile);
        }

        @Override
        @NotNull
        public Collection<VirtualFile> additionalRoots(Project project2) {
            LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            ScratchFileService app = ScratchFileService.getInstance();
            for (RootType r : RootType.getAllRootIds()) {
                ContainerUtil.addIfNotNull((Collection)result2, (Object)fileSystem.findFileByPath(app.getRootPath(r)));
            }
            LinkedHashSet linkedHashSet = result2;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileServiceImpl$NavBarExtension", "additionalRoots"));
            }
            return linkedHashSet;
        }
    }

    public static class AccessExtension
    implements NonProjectFileWritingAccessExtension {
        @Override
        public boolean isWritable(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileServiceImpl$AccessExtension", "isWritable"));
            }
            return file2.getFileType() == ScratchFileType.INSTANCE;
        }
    }

    public static class FilePresentation
    implements FileIconProvider,
    EditorTabTitleProvider {
        @Nullable
        public Icon getIcon(@NotNull VirtualFile file2, @Iconable.IconFlags int flags, @Nullable Project project2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileServiceImpl$FilePresentation", "getIcon"));
            }
            if (project2 == null || file2.isDirectory()) {
                return null;
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(file2);
            if (rootType == null) {
                return null;
            }
            return rootType.substituteIcon(project2, file2);
        }

        @Override
        @Nullable
        public String getEditorTabTitle(@NotNull Project project2, @NotNull VirtualFile file2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchFileServiceImpl$FilePresentation", "getEditorTabTitle"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileServiceImpl$FilePresentation", "getEditorTabTitle"));
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(file2);
            if (rootType == null) {
                return null;
            }
            return rootType.substituteName(project2, file2);
        }
    }

    public static class Highlighter
    implements SyntaxHighlighterProvider {
        @Nullable
        public SyntaxHighlighter create(@NotNull FileType fileType, @Nullable Project project2, @Nullable VirtualFile file2) {
            if (fileType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/ide/scratch/ScratchFileServiceImpl$Highlighter", "create"));
            }
            if (project2 == null || file2 == null || !(fileType instanceof ScratchFileType)) {
                return null;
            }
            Language language = LanguageUtil.getLanguageForPsi((Project)project2, (VirtualFile)file2);
            return language == null ? null : SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project2, (VirtualFile)file2);
        }
    }

    public static class Substitutor
    extends LanguageSubstitutor {
        @Nullable
        public Language getLanguage(@NotNull VirtualFile file2, @NotNull Project project2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileServiceImpl$Substitutor", "getLanguage"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchFileServiceImpl$Substitutor", "getLanguage"));
            }
            return Substitutor.substituteLanguage(project2, file2);
        }

        @Nullable
        public static Language substituteLanguage(@NotNull Project project2, @NotNull VirtualFile file2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchFileServiceImpl$Substitutor", "substituteLanguage"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileServiceImpl$Substitutor", "substituteLanguage"));
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(file2);
            if (rootType == null) {
                return null;
            }
            Language language = rootType.substituteLanguage(project2, file2);
            Language adjusted = language != null ? language : ScratchFileServiceImpl.getLanguageByFileName(file2);
            return adjusted != null && adjusted != ScratchFileType.INSTANCE.getLanguage() ? LanguageSubstitutors.INSTANCE.substituteLanguage(adjusted, file2, project2) : adjusted;
        }
    }

    public static class TypeFactory
    extends FileTypeFactory {
        public void createFileTypes(@NotNull FileTypeConsumer consumer) {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/ide/scratch/ScratchFileServiceImpl$TypeFactory", "createFileTypes"));
            }
            consumer.consume((FileType)ScratchFileType.INSTANCE);
        }
    }

    private static class MyLanguages
    extends PerFileMappingsBase<Language> {
        private MyLanguages() {
        }

        protected List<Language> getAvailableValues() {
            return LanguageUtil.getFileLanguages();
        }

        @Nullable
        protected String serialize(Language language) {
            return language.getID();
        }

        @Nullable
        protected Language handleUnknownMapping(VirtualFile file2, String value) {
            return PlainTextLanguage.INSTANCE;
        }
    }
}

