/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.script;

import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.ide.script.IdeScriptBindings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.ide.script.IdeScriptEngine;
import org.jetbrains.ide.script.IdeScriptEngineManager;
import org.jetbrains.ide.script.IdeScriptException;

class IdeStartupScripts
extends ApplicationComponent.Adapter {
    private static final Logger LOG = Logger.getInstance(IdeStartupScripts.class);
    private static final String SCRIPT_DIR = "startup";

    IdeStartupScripts() {
    }

    public void initComponent() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        IdeStartupScripts.scheduleStartupScriptsExecution();
    }

    private static void scheduleStartupScriptsExecution() {
        List<VirtualFile> scripts = IdeStartupScripts.getScripts();
        LOG.info(scripts.size() + " startup script(s) found");
        if (scripts.isEmpty()) {
            return;
        }
        final Future<List<Pair<VirtualFile, IdeScriptEngine>>> scriptsAndEnginesFuture = IdeStartupScripts.prepareScriptEnginesAsync(scripts);
        ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){
            final AtomicBoolean myScriptsExecutionStarted = new AtomicBoolean();

            public void projectOpened(Project project2) {
                StartupManager.getInstance((Project)project2).runWhenProjectIsInitialized(() -> {
                    if (project2.isDisposed()) {
                        return;
                    }
                    if (!this.myScriptsExecutionStarted.compareAndSet(false, true)) {
                        return;
                    }
                    ProjectManager.getInstance().removeProjectManagerListener((ProjectManagerListener)this);
                    this.runAllScriptsImpl(project2);
                });
            }

            private void runAllScriptsImpl(@NotNull Project project2) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/script/IdeStartupScripts$1", "runAllScriptsImpl"));
                }
                try {
                    for (Pair pair : (List)scriptsAndEnginesFuture.get()) {
                        try {
                            if (pair.second == null) {
                                LOG.warn(((VirtualFile)pair.first).getPath() + " not supported (no script engine)");
                                continue;
                            }
                            IdeStartupScripts.runImpl(project2, (VirtualFile)pair.first, (IdeScriptEngine)pair.second);
                        }
                        catch (Exception e) {
                            LOG.warn((Throwable)e);
                        }
                    }
                }
                catch (ProcessCanceledException e) {
                    LOG.warn("... cancelled");
                }
                catch (InterruptedException e) {
                    LOG.warn("... interrupted");
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    @NotNull
    private static Future<List<Pair<VirtualFile, IdeScriptEngine>>> prepareScriptEnginesAsync(@NotNull List<VirtualFile> scripts) {
        if (scripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scripts", "com/intellij/ide/script/IdeStartupScripts", "prepareScriptEnginesAsync"));
        }
        Future<List<Pair<VirtualFile, IdeScriptEngine>>> future2 = PooledThreadExecutor.INSTANCE.submit(() -> {
            if (scripts == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scripts", "com/intellij/ide/script/IdeStartupScripts", "lambda$prepareScriptEnginesAsync$0"));
            }
            return IdeStartupScripts.prepareScriptEngines(scripts);
        });
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/script/IdeStartupScripts", "prepareScriptEnginesAsync"));
        }
        return future2;
    }

    @NotNull
    private static List<Pair<VirtualFile, IdeScriptEngine>> prepareScriptEngines(@NotNull List<VirtualFile> scripts) {
        if (scripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scripts", "com/intellij/ide/script/IdeStartupScripts", "prepareScriptEngines"));
        }
        IdeScriptEngineManager scriptEngineManager = IdeScriptEngineManager.getInstance();
        ArrayList result2 = ContainerUtil.newArrayList();
        for (VirtualFile script : scripts) {
            String extension = script.getExtension();
            IdeScriptEngine engine = extension != null ? scriptEngineManager.getEngineForFileExtension(extension, null) : null;
            result2.add(Pair.create((Object)script, (Object)engine));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/script/IdeStartupScripts", "prepareScriptEngines"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runImpl(@NotNull Project project2, @NotNull VirtualFile script, @NotNull IdeScriptEngine engine) throws ExecutionException, IOException, IdeScriptException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/script/IdeStartupScripts", "runImpl"));
        }
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/intellij/ide/script/IdeStartupScripts", "runImpl"));
        }
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/ide/script/IdeStartupScripts", "runImpl"));
        }
        String scriptText = VfsUtilCore.loadText((VirtualFile)script);
        IdeScriptBindings.ensureIdeIsBound(project2, engine);
        LOG.info(script.getPath());
        long start = System.currentTimeMillis();
        try {
            engine.eval(scriptText);
        }
        finally {
            LOG.info("... completed in " + StringUtil.formatDuration((long)(System.currentTimeMillis() - start)));
        }
    }

    @NotNull
    private static List<VirtualFile> getScripts() {
        List scripts;
        try {
            VirtualFile scriptDir = IdeStartupScripts.getScriptsRootDirectory();
            Object[] scriptDirChildren = scriptDir != null ? scriptDir.getChildren() : VirtualFile.EMPTY_ARRAY;
            scripts = ContainerUtil.filter((Object[])scriptDirChildren, ExtensionsRootType.regularFileFilter());
        }
        catch (IOException ignore) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/script/IdeStartupScripts", "getScripts"));
            }
            return list;
        }
        ContainerUtil.sort((List)scripts, (f1, f2) -> {
            String f1Name = f1 != null ? f1.getName() : null;
            String f2Name = f2 != null ? f2.getName() : null;
            return StringUtil.compare((String)f1Name, (String)f2Name, (boolean)false);
        });
        List list = scripts;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/script/IdeStartupScripts", "getScripts"));
        }
        return list;
    }

    @Nullable
    private static VirtualFile getScriptsRootDirectory() throws IOException {
        PluginId corePlugin = (PluginId)ObjectUtils.assertNotNull((Object)PluginId.findId((String[])new String[]{"com.intellij"}));
        return ExtensionsRootType.getInstance().findResourceDirectory(corePlugin, SCRIPT_DIR, false);
    }
}

