/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.HighlightedRegionProvider;
import com.intellij.ide.todo.nodes.SummaryNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ui.HighlightableCellRenderer;
import com.intellij.ui.HighlightedRegion;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

final class TodoCompositeRenderer
implements TreeCellRenderer {
    private final NodeRenderer myNodeRenderer = new NodeRenderer();
    private final HighlightableCellRenderer myColorTreeCellRenderer = new HighlightableCellRenderer();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component result2;
        Object userObject = ((DefaultMutableTreeNode)obj).getUserObject();
        if (userObject instanceof SummaryNode) {
            this.myNodeRenderer.getTreeCellRendererComponent(tree, (Object)userObject.toString(), selected, expanded, leaf, row, hasFocus);
            this.myNodeRenderer.setFont(UIUtil.getTreeFont().deriveFont(1));
            this.myNodeRenderer.setIcon(null);
            result2 = this.myNodeRenderer;
        } else if (userObject instanceof NodeDescriptor && userObject instanceof HighlightedRegionProvider) {
            NodeDescriptor descriptor = (NodeDescriptor)userObject;
            HighlightedRegionProvider regionProvider = (HighlightedRegionProvider)userObject;
            this.myColorTreeCellRenderer.getTreeCellRendererComponent(tree, obj, selected, expanded, leaf, row, hasFocus);
            for (HighlightedRegion region : regionProvider.getHighlightedRegions()) {
                this.myColorTreeCellRenderer.addHighlighter(region.startOffset, region.endOffset, region.textAttributes);
            }
            this.myColorTreeCellRenderer.setIcon(descriptor.getIcon());
            result2 = this.myColorTreeCellRenderer;
        } else {
            result2 = this.myNodeRenderer.getTreeCellRendererComponent(tree, null, selected, expanded, leaf, row, hasFocus);
        }
        if (result2 instanceof JComponent) {
            ((JComponent)result2).setOpaque(!selected);
        }
        return result2;
    }
}

