/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.ui.Gray;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class MacIntelliJComboBoxUI
extends BasicComboBoxUI {
    private static final Icon DEFAULT_ICON = EmptyIcon.create((Icon)MacIntelliJIconCache.getIcon("comboRight"));
    private static final Border ourDefaultEditorBorder = JBUI.Borders.empty((int)1, (int)0);
    private final JComboBox myComboBox;
    private PropertyChangeListener myEditorChangeListener;
    private PropertyChangeListener myEditorBorderChangeListener;

    public MacIntelliJComboBoxUI(JComboBox comboBox) {
        this.myComboBox = comboBox;
        comboBox.setOpaque(false);
        this.currentValuePane = new CellRendererPane(){

            @Override
            public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
                c.setBackground((Color)(MacIntelliJComboBoxUI.this.myComboBox.isEnabled() ? Gray.xFF : Gray.xF8));
                super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
            }
        };
    }

    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJComboBoxUI((JComboBox)c);
    }

    @Override
    public void installUI(final JComponent c) {
        super.installUI(c);
        this.myEditorBorderChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Component component;
                Object value = evt.getNewValue();
                if (value == ourDefaultEditorBorder) {
                    return;
                }
                ComboBoxEditor editor = ((JComboBox)c).getEditor();
                if (editor != null && (component = editor.getEditorComponent()) instanceof JComponent) {
                    ((JComponent)component).setBorder(ourDefaultEditorBorder);
                }
            }
        };
        this.myEditorChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Component component;
                Object value = evt.getNewValue();
                Object oldEditor = evt.getOldValue();
                if (oldEditor instanceof ComboBoxEditor && (component = ((ComboBoxEditor)oldEditor).getEditorComponent()) instanceof JComponent) {
                    component.removePropertyChangeListener("border", MacIntelliJComboBoxUI.this.myEditorBorderChangeListener);
                }
                if (value instanceof ComboBoxEditor && (component = ((ComboBoxEditor)value).getEditorComponent()) instanceof JComponent) {
                    JComponent comboBoxEditor = (JComponent)component;
                    comboBoxEditor.setBorder(ourDefaultEditorBorder);
                    comboBoxEditor.addPropertyChangeListener("border", MacIntelliJComboBoxUI.this.myEditorBorderChangeListener);
                }
            }
        };
        c.addPropertyChangeListener("editor", this.myEditorChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        Component component;
        c.removePropertyChangeListener("editor", this.myEditorChangeListener);
        ComboBoxEditor editor = ((JComboBox)c).getEditor();
        if (editor != null && (component = editor.getEditorComponent()) instanceof JComponent) {
            component.removePropertyChangeListener("border", this.myEditorBorderChangeListener);
        }
        super.uninstallUI(c);
    }

    @Override
    protected JButton createArrowButton() {
        Color bg = this.myComboBox.getBackground();
        Color fg = this.myComboBox.getForeground();
        BasicArrowButton button = new BasicArrowButton(5, bg, fg, fg, fg){

            @Override
            public void paint(Graphics g2) {
                Icon icon = MacIntelliJIconCache.getIcon("comboRight", false, MacIntelliJComboBoxUI.this.myComboBox.hasFocus(), MacIntelliJComboBoxUI.this.myComboBox.isEnabled());
                icon.paintIcon(this, g2, 0, 0);
            }

            @Override
            public Dimension getPreferredSize() {
                return JBUI.size((int)DEFAULT_ICON.getIconWidth(), (int)DEFAULT_ICON.getIconHeight());
            }
        };
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setOpaque(false);
        return button;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return MacIntelliJComboBoxUI.getSizeWithIcon(super.getMinimumSize(c));
    }

    private static Dimension getSizeWithIcon(Dimension d) {
        return new Dimension(Math.max(d.width + 7, DEFAULT_ICON.getIconWidth()), Math.max(d.height, DEFAULT_ICON.getIconHeight()));
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return MacIntelliJComboBoxUI.getSizeWithIcon(super.getPreferredSize(c));
    }

    @Override
    protected ComboBoxEditor createEditor() {
        BasicComboBoxEditor.UIResource comboBoxEditor = new BasicComboBoxEditor.UIResource(){

            @Override
            protected JTextField createEditorComponent() {
                return new JTextField(){
                    {
                        this.setOpaque(false);
                        this.setBorder(ourDefaultEditorBorder);
                    }

                    @Override
                    public Color getBackground() {
                        if (!this.isEnabled()) {
                            return Gray.xF8;
                        }
                        return super.getBackground();
                    }

                    @Override
                    public void setText(String s) {
                        if (this.getText().equals(s)) {
                            return;
                        }
                        super.setText(s);
                    }

                    @Override
                    public void setBorder(Border border) {
                    }

                    @Override
                    public Border getBorder() {
                        return ourDefaultEditorBorder;
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension size = super.getPreferredSize();
                        return new Dimension(size.width, DEFAULT_ICON.getIconHeight() - 6);
                    }
                };
            }
        };
        if (comboBoxEditor.getEditorComponent() != null) {
            comboBoxEditor.getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    this.process(e);
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    this.process(e);
                }

                private void process(KeyEvent e) {
                    int code = e.getKeyCode();
                    if ((code == 38 || code == 40) && e.getModifiers() == 0) {
                        MacIntelliJComboBoxUI.this.comboBox.dispatchEvent(e);
                    }
                }
            });
            comboBoxEditor.getEditorComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    this.update();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.update();
                }

                void update() {
                    if (MacIntelliJComboBoxUI.this.comboBox != null) {
                        MacIntelliJComboBoxUI.this.comboBox.revalidate();
                        MacIntelliJComboBoxUI.this.comboBox.repaint();
                    }
                }
            });
        }
        return comboBoxEditor;
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        Rectangle rect = super.rectangleForCurrentValue();
        rect.height = Math.min(rect.height, DEFAULT_ICON.getIconHeight() - 8);
        rect.y += 4;
        rect.x += 8;
        rect.width -= 8;
        return rect;
    }

    @Override
    protected Dimension getDefaultSize() {
        return super.getDefaultSize();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return parent.getPreferredSize();
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return parent.getMinimumSize();
            }

            @Override
            public void layoutContainer(Container parent) {
                JComboBox cb = (JComboBox)parent;
                int width = cb.getWidth();
                int height = cb.getHeight();
                Insets insets = MacIntelliJComboBoxUI.this.getInsets();
                int buttonHeight = height - (insets.top + insets.bottom);
                int buttonWidth = DEFAULT_ICON.getIconWidth();
                if (MacIntelliJComboBoxUI.this.arrowButton != null) {
                    Insets arrowInsets = MacIntelliJComboBoxUI.this.arrowButton.getInsets();
                    buttonWidth = ((MacIntelliJComboBoxUI)MacIntelliJComboBoxUI.this).arrowButton.getPreferredSize().width + arrowInsets.left + arrowInsets.right;
                }
                if (MacIntelliJComboBoxUI.this.arrowButton != null) {
                    MacIntelliJComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                }
                if (MacIntelliJComboBoxUI.this.editor != null) {
                    Rectangle cvb = MacIntelliJComboBoxUI.this.rectangleForCurrentValue();
                    MacIntelliJComboBoxUI.this.editor.setBounds(cvb);
                }
            }
        };
    }

    @Override
    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.myComboBox){

            @Override
            protected void configurePopup() {
                super.configurePopup();
                this.setBorderPainted(false);
                this.setBorder((Border)JBUI.Borders.empty());
                this.setBackground((Color)Gray.xFF);
            }

            @Override
            protected void configureList() {
                super.configureList();
                this.wrapRenderer();
            }

            @Override
            protected PropertyChangeListener createPropertyChangeListener() {
                final PropertyChangeListener listener2 = super.createPropertyChangeListener();
                return new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        listener2.propertyChange(evt);
                        if ("renderer".equals(evt.getPropertyName())) {
                            this.wrapRenderer();
                        }
                    }
                };
            }

            private void wrapRenderer() {
                ListCellRenderer renderer = this.list.getCellRenderer();
                if (!(renderer instanceof ComboBoxRendererWrapper) && renderer != null) {
                    this.list.setCellRenderer(new ComboBoxRendererWrapper(renderer));
                }
            }

            class ComboBoxRendererWrapper
            implements ListCellRenderer {
                private final ListCellRenderer myRenderer;

                public ComboBoxRendererWrapper(ListCellRenderer renderer) {
                    if (renderer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/ide/ui/laf/intellij/MacIntelliJComboBoxUI$9$ComboBoxRendererWrapper", "<init>"));
                    }
                    this.myRenderer = renderer;
                }

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c = this.myRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    BorderLayoutPanel panel = (BorderLayoutPanel)JBUI.Panels.simplePanel((Component)c).withBorder((Border)JBUI.Borders.empty((int)0, (int)8));
                    panel.setBackground(c.getBackground());
                    return panel;
                }
            }
        };
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        g.setColor((Color)(this.myComboBox.isEnabled() ? Gray.xFF : Gray.xF8));
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        super.paintCurrentValue(g, bounds, this.comboBox.isPopupVisible());
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle r = this.arrowButton.getBounds();
        int stop2 = r.x;
        Insets clip = this.getInsets();
        Graphics gg = g.create(clip.left, r.y, stop2 - clip.left, DEFAULT_ICON.getIconHeight());
        boolean enabled = c.isEnabled();
        boolean hasFocus = c.hasFocus();
        Icon icon = MacIntelliJIconCache.getIcon("comboLeft", false, hasFocus, enabled);
        icon.paintIcon(c, gg, 0, 0);
        int x = icon.getIconWidth();
        icon = MacIntelliJIconCache.getIcon("comboMiddle", false, hasFocus, enabled);
        while (x < stop2) {
            icon.paintIcon(c, gg, x, 0);
            x += icon.getIconWidth();
        }
        gg.dispose();
        icon = MacIntelliJIconCache.getIcon("comboRight", false, hasFocus, enabled);
        icon.paintIcon(c, g, r.x, r.y);
        if (!this.comboBox.isEditable()) {
            this.paintCurrentValue(g, this.rectangleForCurrentValue(), false);
        }
    }
}

