/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaProgressBarUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class MacIntelliJProgressBarUI
extends DarculaProgressBarUI {
    public static final int HEIGHT = 6;
    protected volatile int position = 0;

    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJProgressBarUI();
    }

    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        Insets insets = this.progressBar.getInsets();
        int w = c.getWidth();
        int h = c.getHeight();
        int y = (h - 6) / 2;
        int x = insets.left;
        Icon icon = MacIntelliJIconCache.getIcon("progressLeft");
        icon.paintIcon(c, g, x, y);
        int stop2 = w - MacIntelliJIconCache.getIcon("progressRight").getIconWidth();
        Graphics gg = g.create(0, 0, w, h);
        gg.setClip(x += icon.getIconWidth(), y, stop2 - x, h);
        icon = MacIntelliJIconCache.getIcon("progressMiddle");
        while (x < stop2) {
            icon.paintIcon(c, gg, x, y);
            x += icon.getIconWidth();
        }
        gg.dispose();
        icon = MacIntelliJIconCache.getIcon("progressRight");
        icon.paintIcon(c, g, stop2, y);
        int barRectWidth = w - (insets.right + insets.left);
        int barRectHeight = h - (insets.top + insets.bottom);
        int amountFull = this.getAmountFull(insets, barRectWidth, barRectHeight);
        boolean done2 = amountFull == barRectWidth;
        Icon left = MacIntelliJIconCache.getIcon("progressLeft", true, false);
        Icon middle = MacIntelliJIconCache.getIcon("progressMiddle", true, false);
        Icon right = MacIntelliJIconCache.getIcon("progressRight", true, false);
        gg = g.create(0, 0, barRectWidth + insets.left - right.getIconWidth(), h);
        gg.setClip(insets.left, y, amountFull - right.getIconWidth(), 6);
        int cur = left.getIconWidth() + insets.left;
        if (cur <= amountFull) {
            left.paintIcon(c, gg, insets.left, y);
        }
        while (cur < amountFull) {
            middle.paintIcon(c, gg, cur, y);
            cur += middle.getIconWidth();
        }
        gg.dispose();
        if (done2) {
            right.paintIcon(c, g, insets.left + barRectWidth - right.getIconWidth(), y);
        }
    }

    @Override
    protected void paintIndeterminate(Graphics g, JComponent c) {
        Insets insets = this.progressBar.getInsets();
        int w = c.getWidth();
        int h = c.getHeight();
        int y = (h - 6) / 2 + insets.top;
        int x = insets.left;
        Icon icon = MacIntelliJIconCache.getIcon("progressLeft", true, false);
        icon.paintIcon(c, g, x, y);
        int stop2 = w - MacIntelliJIconCache.getIcon("progressRight", true, false).getIconWidth() - insets.right;
        Graphics gg = g.create(0, 0, w, h);
        gg.setClip(x += icon.getIconWidth(), y, stop2 - x, h);
        icon = MacIntelliJIconCache.getIcon("progressMiddle", true, false);
        while (x < stop2) {
            icon.paintIcon(c, gg, x, y);
            x += icon.getIconWidth();
        }
        gg.dispose();
        icon = MacIntelliJIconCache.getIcon("progressRight", true, false);
        icon.paintIcon(c, g, stop2, y);
        Icon shadow = MacIntelliJIconCache.getIcon("progressShadow");
        int boxWidth = w - insets.left - insets.right;
        if (boxWidth <= 0) {
            return;
        }
        gg = g.create(0, 0, w, h);
        gg.setClip(new RoundRectangle2D.Double(insets.left, y, boxWidth, 6.0, 6.0, 6.0));
        shadow.paintIcon(c, gg, this.position, y);
        int xx = boxWidth - (this.position + shadow.getIconWidth());
        if (xx < 0) {
            shadow.paintIcon(c, gg, -xx - shadow.getIconWidth(), y);
        }
        ++this.position;
        this.position %= boxWidth;
        gg.dispose();
    }
}

