/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ColorPanel;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class WinIntelliJTextBorder
implements Border,
UIResource {
    @Override
    public Insets getBorderInsets(Component c) {
        int vOffset;
        int n = vOffset = TextFieldWithPopupHandlerUI.isSearchField(c) ? 6 : 4;
        if (TextFieldWithPopupHandlerUI.isSearchFieldWithHistoryPopup(c)) {
            return JBUI.insets((int)vOffset, (int)26, (int)vOffset, (int)23).asUIResource();
        }
        if (TextFieldWithPopupHandlerUI.isSearchField(c)) {
            return JBUI.insets((int)vOffset, (int)23, (int)vOffset, (int)23).asUIResource();
        }
        if (c instanceof JTextField && c.getParent() instanceof ColorPanel) {
            return JBUI.insets((int)3, (int)3, (int)2, (int)2).asUIResource();
        }
        return JBUI.insets((int)vOffset, (int)7, (int)vOffset, (int)7).asUIResource();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        if (DarculaTextFieldUI.isSearchField(c)) {
            return;
        }
        Graphics2D g = (Graphics2D)g2;
        GraphicsConfig config = new GraphicsConfig((Graphics)g);
        g.translate(x, y);
        boolean editable = !(c instanceof JTextComponent) || ((JTextComponent)c).isEditable();
        int d = JBUI.scale((int)1);
        int dd = JBUI.scale((int)2);
        if (c.hasFocus()) {
            g.setColor(WinIntelliJTextBorder.getBorderColor(c.isEnabled() && editable, true));
            Area s1 = new Area(new Rectangle2D.Float(d, d, width - 2 * d, height - 2 * d));
            Area s2 = new Area(new Rectangle2D.Float(d + dd, d + dd, width - 2 * d - 2 * dd, height - 2 * d - 2 * dd));
            s1.subtract(s2);
            g.fill(s1);
        } else {
            g.setColor(WinIntelliJTextBorder.getBorderColor(c.isEnabled() && editable, false));
            g.drawRect(d, d, width - 2 * d, height - 2 * d);
        }
        g.translate(-x, -y);
        config.restore();
    }

    private static Color getBorderColor(boolean enabled, boolean focus) {
        if (focus) {
            return UIManager.getColor("TextField.activeBorderColor");
        }
        return UIManager.getColor(enabled ? "TextField.borderColor" : "disabledBorderColor");
    }
}

