/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.commander.CommanderPanel;
import com.intellij.ide.commander.ProjectListBuilder;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.TreeModelWrapper;
import com.intellij.ide.util.FileStructureFilter;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.FileStructurePopup;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.TreeStructureActionsOwner;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.SmartTreeStructure;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStructureDialog
extends DialogWrapper {
    private final Editor myEditor;
    private final Navigatable myNavigatable;
    private final Project myProject;
    private MyCommanderPanel myCommanderPanel;
    private final StructureViewModel myTreeModel;
    private final StructureViewModel myBaseTreeModel;
    private SmartTreeStructure myTreeStructure;
    private final TreeStructureActionsOwner myTreeActionsOwner;
    @NonNls
    private static final String ourPropertyKey = "FileStructure.narrowDown";
    private boolean myShouldNarrowDown;

    public FileStructureDialog(@NotNull StructureViewModel structureViewModel, @NotNull Editor editor, @NotNull Project project2, Navigatable navigatable, @NotNull Disposable auxDisposable, boolean applySortAndFilter) {
        if (structureViewModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structureViewModel", "com/intellij/ide/util/FileStructureDialog", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ide/util/FileStructureDialog", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/FileStructureDialog", "<init>"));
        }
        if (auxDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auxDisposable", "com/intellij/ide/util/FileStructureDialog", "<init>"));
        }
        super(project2, true);
        this.myShouldNarrowDown = false;
        this.myProject = project2;
        this.myEditor = editor;
        this.myNavigatable = navigatable;
        this.myBaseTreeModel = structureViewModel;
        if (applySortAndFilter) {
            this.myTreeActionsOwner = new TreeStructureActionsOwner(this.myBaseTreeModel);
            this.myTreeModel = new TreeModelWrapper(structureViewModel, this.myTreeActionsOwner);
        } else {
            this.myTreeActionsOwner = null;
            this.myTreeModel = structureViewModel;
        }
        PsiFile psiFile = this.getPsiFile(project2);
        PsiElement psiElement = this.getCurrentElement(psiFile);
        this.init();
        if (psiElement != null) {
            if (structureViewModel.shouldEnterElement((Object)psiElement)) {
                this.myCommanderPanel.getBuilder().enterElement(psiElement, PsiUtilCore.getVirtualFile((PsiElement)psiElement));
            } else {
                this.myCommanderPanel.getBuilder().selectElement(psiElement, PsiUtilCore.getVirtualFile((PsiElement)psiElement));
            }
        }
        Disposer.register((Disposable)this.myDisposable, (Disposable)auxDisposable);
    }

    protected PsiFile getPsiFile(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/FileStructureDialog", "getPsiFile"));
        }
        return PsiDocumentManager.getInstance((Project)project2).getPsiFile(this.myEditor.getDocument());
    }

    @Nullable
    protected Border createContentPaneBorder() {
        return null;
    }

    public void dispose() {
        this.myCommanderPanel.dispose();
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return DockManager.getInstance((Project)this.myProject).getDimensionKeyForFocus("#com.intellij.ide.util.FileStructureDialog");
    }

    public JComponent getPreferredFocusedComponent() {
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myCommanderPanel);
    }

    @Nullable
    protected PsiElement getCurrentElement(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        Object elementAtCursor = this.myTreeModel.getCurrentEditorElement();
        if (elementAtCursor instanceof PsiElement) {
            return (PsiElement)elementAtCursor;
        }
        return null;
    }

    protected JComponent createCenterPanel() {
        this.myCommanderPanel = new MyCommanderPanel(this.myProject);
        this.myTreeStructure = new MyStructureTreeStructure();
        ArrayList<FileStructureFilter> fileStructureFilters = new ArrayList<FileStructureFilter>();
        ArrayList<FileStructureNodeProvider> fileStructureNodeProviders = new ArrayList<FileStructureNodeProvider>();
        if (this.myTreeActionsOwner != null) {
            for (Filter filter : this.myBaseTreeModel.getFilters()) {
                if (!(filter instanceof FileStructureFilter)) continue;
                FileStructureFilter fsFilter = (FileStructureFilter)filter;
                this.myTreeActionsOwner.setActionIncluded((TreeAction)fsFilter, true);
                fileStructureFilters.add(fsFilter);
            }
            if (this.myBaseTreeModel instanceof ProvidingTreeModel) {
                for (NodeProvider provider : ((ProvidingTreeModel)this.myBaseTreeModel).getNodeProviders()) {
                    if (!(provider instanceof FileStructureNodeProvider)) continue;
                    fileStructureNodeProviders.add((FileStructureNodeProvider)provider);
                }
            }
        }
        PsiFile psiFile = this.getPsiFile(this.myProject);
        boolean showRoot = this.isShowRoot(psiFile);
        ProjectListBuilder projectListBuilder = new ProjectListBuilder(this.myProject, this.myCommanderPanel, (AbstractTreeStructure)this.myTreeStructure, null, showRoot){

            @Override
            protected boolean shouldEnterSingleTopLevelElement(Object rootChild) {
                Object element = ((StructureViewTreeElement)((AbstractTreeNode)rootChild).getValue()).getValue();
                return FileStructureDialog.this.myBaseTreeModel.shouldEnterElement(element);
            }

            @Override
            protected boolean nodeIsAcceptableForElement(AbstractTreeNode node, Object element) {
                return Comparing.equal((Object)((StructureViewTreeElement)node.getValue()).getValue(), (Object)element);
            }

            @Override
            protected void refreshSelection() {
                FileStructureDialog.this.myCommanderPanel.scrollSelectionInView();
                if (FileStructureDialog.this.myShouldNarrowDown) {
                    FileStructureDialog.this.myCommanderPanel.updateSpeedSearch();
                }
            }

            @Override
            protected List<AbstractTreeNode> getAllAcceptableNodes(Object[] childElements, VirtualFile file2) {
                ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
                for (Object childElement : childElements) {
                    result2.add((AbstractTreeNode)childElement);
                }
                return result2;
            }
        };
        this.myCommanderPanel.setBuilder(projectListBuilder);
        this.myCommanderPanel.setTitlePanelVisible(false);
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                boolean succeeded = FileStructureDialog.this.myCommanderPanel.navigateSelectedElement();
                if (succeeded) {
                    this.unregisterCustomShortcutSet(FileStructureDialog.this.myCommanderPanel);
                }
            }
        }.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditSource").getShortcutSet(), (JComponent)this.myCommanderPanel);
        this.myCommanderPanel.setPreferredSize((Dimension)JBUI.size((int)400, (int)500));
        JPanel panel = new JPanel(new BorderLayout());
        JPanel comboPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        this.addNarrowDownCheckbox(comboPanel);
        for (FileStructureFilter filter : fileStructureFilters) {
            this.addCheckbox(comboPanel, (TreeAction)filter);
        }
        for (FileStructureNodeProvider provider : fileStructureNodeProviders) {
            this.addCheckbox(comboPanel, (TreeAction)provider);
        }
        this.myCommanderPanel.setBorder(IdeBorderFactory.createBorder((int)2));
        panel.add((Component)comboPanel, "North");
        panel.add((Component)this.myCommanderPanel, "Center");
        return panel;
    }

    protected boolean isShowRoot(PsiFile psiFile) {
        StructureViewBuilder viewBuilder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(psiFile);
        return viewBuilder instanceof TreeBasedStructureViewBuilder && ((TreeBasedStructureViewBuilder)viewBuilder).isRootNodeShown();
    }

    private void addNarrowDownCheckbox(JPanel panel) {
        final JCheckBox checkBox = new JCheckBox(IdeBundle.message((String)"checkbox.narrow.down.the.list.on.typing", (Object[])new Object[0]));
        checkBox.setSelected(PropertiesComponent.getInstance().isTrueValue(ourPropertyKey));
        checkBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FileStructureDialog.this.myShouldNarrowDown = checkBox.isSelected();
                PropertiesComponent.getInstance().setValue(FileStructureDialog.ourPropertyKey, FileStructureDialog.this.myShouldNarrowDown);
                ProjectListBuilder builder = (ProjectListBuilder)FileStructureDialog.this.myCommanderPanel.getBuilder();
                if (builder == null) {
                    return;
                }
                builder.addUpdateRequest();
            }
        });
        checkBox.setFocusable(false);
        panel.add(checkBox);
    }

    private void addCheckbox(JPanel panel, final TreeAction action) {
        String text;
        String string = action instanceof FileStructureFilter ? ((FileStructureFilter)action).getCheckBoxText() : (text = action instanceof FileStructureNodeProvider ? ((FileStructureNodeProvider)action).getCheckBoxText() : null);
        if (text == null) {
            return;
        }
        Shortcut[] shortcuts = FileStructurePopup.extractShortcutFor(action);
        final JCheckBox chkFilter = new JCheckBox();
        chkFilter.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedSearchSupply supply;
                Object elementValue;
                AbstractTreeNode parentNode;
                Object value;
                ProjectListBuilder builder = (ProjectListBuilder)FileStructureDialog.this.myCommanderPanel.getBuilder();
                PsiElement currentParent = null;
                if (builder != null && (value = (parentNode = builder.getParentNode()).getValue()) instanceof StructureViewTreeElement && (elementValue = ((StructureViewTreeElement)value).getValue()) instanceof PsiElement) {
                    currentParent = (PsiElement)elementValue;
                }
                boolean state = chkFilter.isSelected();
                FileStructureDialog.this.myTreeActionsOwner.setActionIncluded(action, action instanceof FileStructureFilter ? !state : state);
                FileStructureDialog.this.myTreeStructure.rebuildTree();
                if (builder != null) {
                    if (currentParent != null) {
                        boolean oldNarrowDown = FileStructureDialog.this.myShouldNarrowDown;
                        FileStructureDialog.this.myShouldNarrowDown = false;
                        try {
                            builder.enterElement(currentParent, PsiUtilCore.getVirtualFile((PsiElement)currentParent));
                        }
                        finally {
                            FileStructureDialog.this.myShouldNarrowDown = oldNarrowDown;
                        }
                    }
                    builder.updateList(true);
                }
                if (SpeedSearchBase.hasActiveSpeedSearch(FileStructureDialog.this.myCommanderPanel.getList()) && (supply = SpeedSearchSupply.getSupply((JComponent)FileStructureDialog.this.myCommanderPanel.getList())) != null && supply.isPopupActive()) {
                    supply.refreshSelection();
                }
            }
        });
        chkFilter.setFocusable(false);
        if (shortcuts.length > 0) {
            text = text + " (" + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + ")";
            new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    chkFilter.doClick();
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), (JComponent)this.myCommanderPanel);
        }
        chkFilter.setText(text);
        panel.add(chkFilter);
    }

    @Nullable
    protected JComponent createSouthPanel() {
        return null;
    }

    public CommanderPanel getPanel() {
        return this.myCommanderPanel;
    }

    private static SpeedSearchComparator createSpeedSearchComparator() {
        return new SpeedSearchComparator(false){

            @Override
            @NotNull
            protected MinusculeMatcher createMatcher(@NotNull String pattern) {
                if (pattern == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/FileStructureDialog$6", "createMatcher"));
                }
                MinusculeMatcher minusculeMatcher = FileStructureDialog.createFileStructureMatcher(pattern);
                if (minusculeMatcher == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/FileStructureDialog$6", "createMatcher"));
                }
                return minusculeMatcher;
            }
        };
    }

    @NotNull
    public static MinusculeMatcher createFileStructureMatcher(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/FileStructureDialog", "createFileStructureMatcher"));
        }
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)pattern).withSeparators(" ()").build();
        if (minusculeMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/FileStructureDialog", "createFileStructureMatcher"));
        }
        return minusculeMatcher;
    }

    private class MyStructureTreeStructure
    extends SmartTreeStructure {
        public MyStructureTreeStructure() {
            super(FileStructureDialog.this.myProject, (TreeModel)FileStructureDialog.this.myTreeModel);
        }

        @Override
        public Object[] getChildElements(Object element) {
            Object[] childElements = super.getChildElements(element);
            if (!FileStructureDialog.this.myShouldNarrowDown) {
                return childElements;
            }
            String enteredPrefix = FileStructureDialog.this.myCommanderPanel.getEnteredPrefix();
            if (enteredPrefix == null) {
                return childElements;
            }
            ArrayList<Object> filteredElements = new ArrayList<Object>(childElements.length);
            SpeedSearchComparator speedSearchComparator = FileStructureDialog.createSpeedSearchComparator();
            for (Object child : childElements) {
                String name;
                Object value;
                if (child instanceof AbstractTreeNode && (value = ((AbstractTreeNode)child).getValue()) instanceof TreeElement && ((name = ((TreeElement)value).getPresentation().getPresentableText()) == null || speedSearchComparator.matchingFragments(enteredPrefix, name) == null)) continue;
                filteredElements.add(child);
            }
            return ArrayUtil.toObjectArray(filteredElements);
        }

        @Override
        public void rebuildTree() {
            this.getChildElements(this.getRootElement());
            super.rebuildTree();
        }
    }

    private class MyCommanderPanel
    extends CommanderPanel
    implements DataProvider {
        @Override
        protected boolean shouldDrillDownOnEmptyElement(AbstractTreeNode node) {
            return false;
        }

        public MyCommanderPanel(Project _project) {
            super(_project, false, true);
            this.myList.setSelectionMode(0);
            this.myListSpeedSearch.addChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ProjectListBuilder builder = (ProjectListBuilder)MyCommanderPanel.this.getBuilder();
                    if (builder == null) {
                        return;
                    }
                    builder.addUpdateRequest(MyCommanderPanel.this.hasPrefixShortened(evt));
                    ApplicationManager.getApplication().invokeLater(() -> {
                        int index = MyCommanderPanel.this.myList.getSelectedIndex();
                        if (index != -1 && index < MyCommanderPanel.this.myList.getModel().getSize()) {
                            MyCommanderPanel.this.myList.clearSelection();
                            ScrollingUtil.selectItem((JList)MyCommanderPanel.this.myList, (int)index);
                        } else {
                            ScrollingUtil.ensureSelectionExists((JList)MyCommanderPanel.this.myList);
                        }
                    });
                }
            });
            this.myListSpeedSearch.setComparator(FileStructureDialog.createSpeedSearchComparator());
        }

        private boolean hasPrefixShortened(PropertyChangeEvent evt) {
            return evt.getNewValue() != null && evt.getOldValue() != null && ((String)evt.getNewValue()).length() < ((String)evt.getOldValue()).length();
        }

        @Override
        public boolean navigateSelectedElement() {
            Ref succeeded = new Ref();
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            commandProcessor.executeCommand(FileStructureDialog.this.myProject, () -> {
                succeeded.set((Object)MyCommanderPanel.super.navigateSelectedElement());
                IdeDocumentHistory.getInstance(FileStructureDialog.this.myProject).includeCurrentCommandAsNavigation();
            }, "Navigate", null);
            if (((Boolean)succeeded.get()).booleanValue()) {
                FileStructureDialog.this.close(1);
            }
            return (Boolean)succeeded.get();
        }

        public Object getData(String dataId) {
            Object selectedElement = FileStructureDialog.this.myCommanderPanel.getSelectedValue();
            if (selectedElement instanceof TreeElement) {
                selectedElement = ((StructureViewTreeElement)selectedElement).getValue();
            }
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return selectedElement instanceof Navigatable ? selectedElement : FileStructureDialog.this.myNavigatable;
            }
            if (OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
                return FileStructureDialog.this.myEditor;
            }
            return this.getDataImpl(dataId);
        }

        public String getEnteredPrefix() {
            return this.myListSpeedSearch.getEnteredPrefix();
        }

        public void updateSpeedSearch() {
            this.myListSpeedSearch.refreshSelection();
        }

        public void scrollSelectionInView() {
            int selectedIndex = this.myList.getSelectedIndex();
            if (selectedIndex >= 0) {
                ScrollingUtil.ensureIndexIsVisible((JList)this.myList, (int)selectedIndex, (int)0);
            }
        }
    }
}

