/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javadoc;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.javadoc.JavadocHelper;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorNavigationDelegate;
import com.intellij.openapi.editor.EditorNavigationDelegateAdapter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavadocNavigationDelegate
extends EditorNavigationDelegateAdapter {
    private static final JavadocHelper ourHelper = JavadocHelper.getInstance();

    @NotNull
    public EditorNavigationDelegate.Result navigateToLineEnd(@NotNull Editor editor, @NotNull DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javadoc/JavadocNavigationDelegate", "navigateToLineEnd"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/javadoc/JavadocNavigationDelegate", "navigateToLineEnd"));
        }
        if (!CodeInsightSettings.getInstance().SMART_END_ACTION) {
            EditorNavigationDelegate.Result result2 = EditorNavigationDelegate.Result.CONTINUE;
            if (result2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javadoc/JavadocNavigationDelegate", "navigateToLineEnd"));
            }
            return result2;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            EditorNavigationDelegate.Result result3 = EditorNavigationDelegate.Result.CONTINUE;
            if (result3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javadoc/JavadocNavigationDelegate", "navigateToLineEnd"));
            }
            return result3;
        }
        Document document2 = editor.getDocument();
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document2);
        }
        if (psiFile == null) {
            EditorNavigationDelegate.Result result4 = EditorNavigationDelegate.Result.CONTINUE;
            if (result4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javadoc/JavadocNavigationDelegate", "navigateToLineEnd"));
            }
            return result4;
        }
        EditorNavigationDelegate.Result result5 = JavadocNavigationDelegate.navigateToLineEnd(editor, psiFile);
        if (result5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javadoc/JavadocNavigationDelegate", "navigateToLineEnd"));
        }
        return result5;
    }

    public static EditorNavigationDelegate.Result navigateToLineEnd(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javadoc/JavadocNavigationDelegate", "navigateToLineEnd"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/javadoc/JavadocNavigationDelegate", "navigateToLineEnd"));
        }
        Document document2 = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        int offset = caretModel.getOffset();
        CharSequence text = document2.getCharsSequence();
        int line = caretModel.getLogicalPosition().line;
        int endLineOffset = document2.getLineEndOffset(line);
        LogicalPosition endLineLogicalPosition = editor.offsetToLogicalPosition(endLineOffset);
        int lastNonWsSymbolOffset = CharArrayUtil.shiftBackward((CharSequence)text, (int)endLineOffset, (String)" \t");
        if (lastNonWsSymbolOffset > offset || caretModel.getLogicalPosition().column > endLineLogicalPosition.column) {
            return EditorNavigationDelegate.Result.CONTINUE;
        }
        Pair<JavadocHelper.JavadocParameterInfo, List<JavadocHelper.JavadocParameterInfo>> pair = ourHelper.parse(psiFile, editor, offset);
        if (pair.first == null || ((JavadocHelper.JavadocParameterInfo)pair.first).parameterDescriptionStartPosition != null) {
            return EditorNavigationDelegate.Result.CONTINUE;
        }
        LogicalPosition position = ourHelper.calculateDescriptionStartPosition(psiFile, (Collection)pair.second, (JavadocHelper.JavadocParameterInfo)pair.first);
        ourHelper.navigate(position, editor, psiFile.getProject());
        return EditorNavigationDelegate.Result.STOP;
    }
}

