/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlQuotesFormatPreprocessor
implements PreFormatProcessor {
    @Override
    @NotNull
    public TextRange process(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor", "process"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor", "process"));
        }
        PsiElement psiElement = node.getPsi();
        if (psiElement != null && psiElement.isValid() && psiElement.getLanguage().is((Language)HTMLLanguage.INSTANCE)) {
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)psiElement.getProject());
            CodeStyleSettings.QuoteStyle quoteStyle = settings.HTML_QUOTE_STYLE;
            if (quoteStyle != CodeStyleSettings.QuoteStyle.None && settings.HTML_ENFORCE_QUOTES) {
                HtmlQuotesConverter converter = new HtmlQuotesConverter(quoteStyle, psiElement, range);
                Document document2 = converter.getDocument();
                if (document2 != null) {
                    DocumentUtil.executeInBulk(document2, true, converter);
                }
                TextRange textRange = converter.getTextRange();
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor", "process"));
                }
                return textRange;
            }
        }
        TextRange textRange = range;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor", "process"));
        }
        return textRange;
    }

    private static class HtmlQuotesConverter
    extends XmlRecursiveElementVisitor
    implements Runnable {
        private TextRange myTextRange;
        private final Document myDocument;
        private final PsiDocumentManager myDocumentManager;
        private final PsiElement myElement;
        private int myDelta;
        private final char myQuoteChar;

        private HtmlQuotesConverter(CodeStyleSettings.QuoteStyle style, @NotNull PsiElement element, @NotNull TextRange textRange) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "<init>"));
            }
            if (textRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "<init>"));
            }
            this.myDelta = 0;
            Project project2 = element.getProject();
            PsiFile file2 = element.getContainingFile();
            this.myElement = element;
            this.myTextRange = new TextRange(textRange.getStartOffset(), textRange.getEndOffset());
            this.myDocumentManager = PsiDocumentManager.getInstance((Project)project2);
            this.myDocument = this.myDocumentManager.getDocument(file2);
            switch (style) {
                case Single: {
                    this.myQuoteChar = (char)39;
                    break;
                }
                case Double: {
                    this.myQuoteChar = (char)34;
                    break;
                }
                default: {
                    this.myQuoteChar = '\u0000';
                }
            }
        }

        public TextRange getTextRange() {
            return this.myTextRange.grown(this.myDelta);
        }

        public Document getDocument() {
            return this.myDocument;
        }

        public void visitXmlAttributeValue(XmlAttributeValue value) {
            PsiElement child;
            if (this.myTextRange.contains(value.getTextRange()) && (child = value.getFirstChild()) != null && !this.containsQuoteChars(value)) {
                String newValue = null;
                if (child.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                    char existingQuote;
                    CharSequence delimiterChars;
                    PsiElement lastChild = value.getLastChild();
                    if (lastChild != null && lastChild.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && (delimiterChars = child.getNode().getChars()).length() == 1 && (existingQuote = delimiterChars.charAt(0)) != this.myQuoteChar) {
                        newValue = this.convertQuotes(value);
                    }
                } else if (child.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && child == value.getLastChild()) {
                    newValue = this.surroundWithQuotes(value);
                }
                if (newValue != null) {
                    int startOffset = value.getTextRange().getStartOffset() + this.myDelta;
                    int endOffset = value.getTextRange().getEndOffset() + this.myDelta;
                    this.myDocument.replaceString(startOffset, endOffset, (CharSequence)newValue);
                    this.myDelta += newValue.length() - value.getTextLength();
                }
            }
        }

        @Nullable
        private String convertQuotes(@NotNull XmlAttributeValue value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "convertQuotes"));
            }
            String currValue = value.getNode().getChars().toString();
            if (currValue.length() >= 2) {
                return this.myQuoteChar + currValue.substring(1, currValue.length() - 1) + this.myQuoteChar;
            }
            return null;
        }

        @NotNull
        private String surroundWithQuotes(@NotNull XmlAttributeValue value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "surroundWithQuotes"));
            }
            String currValue = value.getNode().getChars().toString();
            String string = this.myQuoteChar + currValue + this.myQuoteChar;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "surroundWithQuotes"));
            }
            return string;
        }

        private boolean containsQuoteChars(@NotNull XmlAttributeValue value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "containsQuoteChars"));
            }
            for (PsiElement child = value.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (HtmlQuotesConverter.isDelimiter(child.getNode().getElementType())) continue;
                CharSequence valueChars = child.getNode().getChars();
                for (int i = 0; i < valueChars.length(); ++i) {
                    if (valueChars.charAt(i) != this.myQuoteChar) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isDelimiter(@NotNull IElementType elementType) {
            if (elementType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "isDelimiter"));
            }
            return elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER || elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
        }

        @Override
        public void run() {
            if (this.myDocument != null) {
                this.myDocumentManager.doPostponedOperationsAndUnblockDocument(this.myDocument);
                this.myElement.accept((PsiElementVisitor)this);
                this.myDocumentManager.commitDocument(this.myDocument);
            }
        }
    }
}

