/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.pratt;

import com.intellij.lang.pratt.PathPattern;
import com.intellij.lang.pratt.TokenParser;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrattRegistry {
    private final MultiMap<IElementType, Trinity<Integer, PathPattern, TokenParser>> myMap = new MultiMap();

    public void registerParser(@NotNull IElementType type, int priority, TokenParser parser) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/pratt/PrattRegistry", "registerParser"));
        }
        this.registerParser(type, priority, PathPattern.path(), parser);
    }

    public void registerParser(@NotNull IElementType type, int priority, PathPattern pattern, TokenParser parser) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/pratt/PrattRegistry", "registerParser"));
        }
        this.myMap.putValue((Object)type, (Object)new Trinity((Object)priority, (Object)pattern, (Object)parser));
    }

    @NotNull
    public Collection<Trinity<Integer, PathPattern, TokenParser>> getParsers(@Nullable IElementType type) {
        Collection collection = this.myMap.get((Object)type);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/pratt/PrattRegistry", "getParsers"));
        }
        return collection;
    }
}

