/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeHighlighterHolder;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.ConflictChange;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeList;
import com.intellij.openapi.diff.impl.incrementalMerge.TwoSideChange;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MergeConflict
extends TwoSideChange<ConflictChange> {
    MergeConflict(@NotNull TextRange baseRange, @NotNull TextRange leftRange, @NotNull TextRange rightRange, @NotNull MergeList mergeList) {
        if (baseRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseRange", "com/intellij/openapi/diff/impl/incrementalMerge/MergeConflict", "<init>"));
        }
        if (leftRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftRange", "com/intellij/openapi/diff/impl/incrementalMerge/MergeConflict", "<init>"));
        }
        if (rightRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightRange", "com/intellij/openapi/diff/impl/incrementalMerge/MergeConflict", "<init>"));
        }
        if (mergeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeList", "com/intellij/openapi/diff/impl/incrementalMerge/MergeConflict", "<init>"));
        }
        super(baseRange, mergeList, new ChangeHighlighterHolder());
        this.myLeftChange = new ConflictChange(this, FragmentSide.SIDE1, leftRange, mergeList.getLeftChangeList());
        this.myRightChange = new ConflictChange(this, FragmentSide.SIDE2, rightRange, mergeList.getRightChangeList());
    }

    private MergeConflict(@NotNull TextRange baseRange, @Nullable ConflictChange leftChange, @Nullable ConflictChange rightChange, @NotNull MergeList mergeList, @NotNull ChangeHighlighterHolder highlighterHolder) {
        if (baseRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseRange", "com/intellij/openapi/diff/impl/incrementalMerge/MergeConflict", "<init>"));
        }
        if (mergeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeList", "com/intellij/openapi/diff/impl/incrementalMerge/MergeConflict", "<init>"));
        }
        if (highlighterHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighterHolder", "com/intellij/openapi/diff/impl/incrementalMerge/MergeConflict", "<init>"));
        }
        super(baseRange, mergeList, highlighterHolder);
        this.myLeftChange = leftChange;
        this.myRightChange = rightChange;
    }

    @NotNull
    public MergeConflict deriveSideForNotAppliedChange(@NotNull TextRange baseRange, @Nullable ConflictChange leftChange, @Nullable ConflictChange rightChange) {
        if (baseRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseRange", "com/intellij/openapi/diff/impl/incrementalMerge/MergeConflict", "deriveSideForNotAppliedChange"));
        }
        ChangeHighlighterHolder highlighterHolder = new ChangeHighlighterHolder();
        MergeConflict mergeConflict = new MergeConflict(baseRange, leftChange, rightChange, this.myMergeList, highlighterHolder);
        highlighterHolder.highlight(mergeConflict, this.myCommonHighlighterHolder.getEditor(), ChangeType.CONFLICT);
        MergeConflict mergeConflict2 = mergeConflict;
        if (mergeConflict2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/MergeConflict", "deriveSideForNotAppliedChange"));
        }
        return mergeConflict2;
    }
}

