/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.impl.id.PlatformIdTableBuilding;
import com.intellij.psi.impl.search.LexerEditorHighlighterLexer;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHighlighterCache {
    private static final Key<WeakReference<EditorHighlighter>> ourSomeEditorSyntaxHighlighter = Key.create((String)"some editor highlighter");

    private EditorHighlighterCache() {
    }

    public static void rememberEditorHighlighterForCachesOptimization(Document document2, @NotNull EditorHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorHighlighterCache", "rememberEditorHighlighterForCachesOptimization"));
        }
        document2.putUserData(ourSomeEditorSyntaxHighlighter, new WeakReference<EditorHighlighter>(highlighter));
    }

    @Nullable
    public static EditorHighlighter getEditorHighlighterForCachesBuilding(Document document2) {
        if (document2 == null) {
            return null;
        }
        WeakReference editorHighlighterWeakReference = (WeakReference)document2.getUserData(ourSomeEditorSyntaxHighlighter);
        EditorHighlighter someEditorHighlighter = (EditorHighlighter)SoftReference.dereference((Reference)editorHighlighterWeakReference);
        if (someEditorHighlighter instanceof LexerEditorHighlighter && ((LexerEditorHighlighter)someEditorHighlighter).isValid()) {
            return someEditorHighlighter;
        }
        document2.putUserData(ourSomeEditorSyntaxHighlighter, null);
        return null;
    }

    @Nullable
    public static Lexer getLexerBasedOnLexerHighlighter(CharSequence text, VirtualFile virtualFile, Project project2) {
        EditorHighlighter cachedEditorHighlighter;
        EditorHighlighter highlighter = null;
        PsiFile psiFile = virtualFile != null ? PsiManager.getInstance((Project)project2).findFile(virtualFile) : null;
        Document document2 = psiFile != null ? PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile) : null;
        boolean alreadyInitializedHighlighter = false;
        if (document2 != null && (cachedEditorHighlighter = EditorHighlighterCache.getEditorHighlighterForCachesBuilding(document2)) != null && PlatformIdTableBuilding.checkCanUseCachedEditorHighlighter(text, cachedEditorHighlighter)) {
            highlighter = cachedEditorHighlighter;
            alreadyInitializedHighlighter = true;
        } else if (virtualFile != null) {
            highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project2, virtualFile);
        }
        if (highlighter != null) {
            return new LexerEditorHighlighterLexer(highlighter, alreadyInitializedHighlighter);
        }
        return null;
    }
}

