/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldRegionImpl;
import com.intellij.openapi.editor.impl.FoldRegionsTree;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.Point;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingModelImpl
implements FoldingModelEx,
PrioritizedInternalDocumentListener,
Dumpable,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorFoldingModelImpl");
    private static final Key<LogicalPosition> SAVED_CARET_POSITION = Key.create((String)"saved.position.before.folding");
    private static final Key<Boolean> MARK_FOR_UPDATE = Key.create((String)"marked.for.position.update");
    private final List<FoldingListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myIsFoldingEnabled;
    private final EditorImpl myEditor;
    private final FoldRegionsTree myFoldTree;
    private TextAttributes myFoldTextAttributes;
    private boolean myIsBatchFoldingProcessing;
    private boolean myDoNotCollapseCaret;
    private boolean myFoldRegionsProcessed;
    private int mySavedCaretShift;
    private final MultiMap<FoldingGroup, FoldRegion> myGroups = new MultiMap();
    private boolean myDocumentChangeProcessed = true;
    private final AtomicLong myExpansionCounter = new AtomicLong();

    public FoldingModelImpl(EditorImpl editor) {
        this.myEditor = editor;
        this.myIsFoldingEnabled = true;
        this.myIsBatchFoldingProcessing = false;
        this.myDoNotCollapseCaret = false;
        this.myFoldTree = new FoldRegionsTree(){

            @Override
            protected boolean isFoldingEnabled() {
                return FoldingModelImpl.this.isFoldingEnabled();
            }
        };
        this.myFoldRegionsProcessed = false;
        this.refreshSettings();
    }

    @Override
    @NotNull
    public List<FoldRegion> getGroupedRegions(@NotNull FoldingGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/editor/impl/FoldingModelImpl", "getGroupedRegions"));
        }
        List list = (List)this.myGroups.get((Object)group);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FoldingModelImpl", "getGroupedRegions"));
        }
        return list;
    }

    @Override
    public void clearDocumentRangesModificationStatus() {
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        this.myFoldTree.clearDocumentRangesModificationStatus();
    }

    @Override
    public boolean hasDocumentRegionChangedFor(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/openapi/editor/impl/FoldingModelImpl", "hasDocumentRegionChangedFor"));
        }
        FoldingModelImpl.assertReadAccess();
        return region instanceof FoldRegionImpl && ((FoldRegionImpl)region).hasDocumentRegionChanged();
    }

    @NotNull
    public FoldRegion getFirstRegion(@NotNull FoldingGroup group, FoldRegion child) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/editor/impl/FoldingModelImpl", "getFirstRegion"));
        }
        List<FoldRegion> regions = this.getGroupedRegions(group);
        if (regions.isEmpty()) {
            boolean inAll = Arrays.asList(this.getAllFoldRegions()).contains(child);
            throw new AssertionError((Object)("Folding group without children; the known child is in all: " + inAll));
        }
        FoldRegion main = regions.get(0);
        for (int i = 1; i < regions.size(); ++i) {
            FoldRegion region = regions.get(i);
            if (main.getStartOffset() <= region.getStartOffset()) continue;
            main = region;
        }
        FoldRegion foldRegion = main;
        if (foldRegion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FoldingModelImpl", "getFirstRegion"));
        }
        return foldRegion;
    }

    public int getEndOffset(@NotNull FoldingGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/editor/impl/FoldingModelImpl", "getEndOffset"));
        }
        List<FoldRegion> regions = this.getGroupedRegions(group);
        int endOffset = 0;
        for (FoldRegion region : regions) {
            if (!region.isValid()) continue;
            endOffset = Math.max(endOffset, region.getEndOffset());
        }
        return endOffset;
    }

    public void refreshSettings() {
        this.myFoldTextAttributes = this.myEditor.getColorsScheme().getAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES);
    }

    @Override
    public boolean isFoldingEnabled() {
        return this.myIsFoldingEnabled;
    }

    public boolean isOffsetCollapsed(int offset) {
        FoldingModelImpl.assertReadAccess();
        return this.getCollapsedRegionAtOffset(offset) != null;
    }

    private boolean isOffsetInsideCollapsedRegion(int offset) {
        FoldingModelImpl.assertReadAccess();
        FoldRegion region = this.getCollapsedRegionAtOffset(offset);
        return region != null && region.getStartOffset() < offset;
    }

    private static void assertIsDispatchThreadForEditor() {
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread();
    }

    private static void assertReadAccess() {
        ApplicationManagerEx.getApplicationEx().assertReadAccessAllowed();
    }

    @Override
    public void setFoldingEnabled(boolean isEnabled) {
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        this.myIsFoldingEnabled = isEnabled;
    }

    public FoldRegion addFoldRegion(int startOffset, int endOffset, @NotNull String placeholderText) {
        if (placeholderText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeholderText", "com/intellij/openapi/editor/impl/FoldingModelImpl", "addFoldRegion"));
        }
        FoldRegion region = this.createFoldRegion(startOffset, endOffset, placeholderText, null, false);
        if (region == null) {
            return null;
        }
        if (!this.addFoldRegion(region)) {
            region.dispose();
            return null;
        }
        return region;
    }

    public boolean addFoldRegion(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/openapi/editor/impl/FoldingModelImpl", "addFoldRegion"));
        }
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        if (!this.isFoldingEnabled()) {
            return false;
        }
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
            return false;
        }
        this.myFoldRegionsProcessed = true;
        if (this.myFoldTree.addRegion(region)) {
            FoldingGroup group = region.getGroup();
            if (group != null) {
                this.myGroups.putValue((Object)group, (Object)region);
            }
            for (FoldingListener listener2 : this.myListeners) {
                listener2.onFoldRegionStateChange(region);
            }
            return true;
        }
        return false;
    }

    public void runBatchFoldingOperation(@NotNull Runnable operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/editor/impl/FoldingModelImpl", "runBatchFoldingOperation"));
        }
        this.runBatchFoldingOperation(operation, false, true);
    }

    public void runBatchFoldingOperation(@NotNull Runnable operation, boolean moveCaret) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/editor/impl/FoldingModelImpl", "runBatchFoldingOperation"));
        }
        this.runBatchFoldingOperation(operation, false, moveCaret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBatchFoldingOperation(Runnable operation, boolean dontCollapseCaret, boolean moveCaret) {
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        boolean oldDontCollapseCaret = this.myDoNotCollapseCaret;
        this.myDoNotCollapseCaret |= dontCollapseCaret;
        boolean oldBatchFlag = this.myIsBatchFoldingProcessing;
        if (!oldBatchFlag) {
            ((ScrollingModelImpl)this.myEditor.getScrollingModel()).finishAnimation();
            this.mySavedCaretShift = this.myEditor.visibleLineToY(this.myEditor.getCaretModel().getVisualPosition().line) - this.myEditor.getScrollingModel().getVerticalScrollOffset();
        }
        this.myIsBatchFoldingProcessing = true;
        try {
            operation.run();
        }
        finally {
            if (!oldBatchFlag) {
                if (this.myFoldRegionsProcessed) {
                    this.notifyBatchFoldingProcessingDone(moveCaret);
                    this.myFoldRegionsProcessed = false;
                }
                this.myIsBatchFoldingProcessing = false;
            }
            this.myDoNotCollapseCaret = oldDontCollapseCaret;
        }
    }

    public void runBatchFoldingOperationDoNotCollapseCaret(@NotNull Runnable operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/editor/impl/FoldingModelImpl", "runBatchFoldingOperationDoNotCollapseCaret"));
        }
        this.runBatchFoldingOperation(operation, true, true);
    }

    public void flushCaretShift() {
        this.mySavedCaretShift = -1;
    }

    @NotNull
    public FoldRegion[] getAllFoldRegions() {
        FoldingModelImpl.assertReadAccess();
        FoldRegion[] foldRegionArray = this.myFoldTree.fetchAllRegions();
        if (foldRegionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FoldingModelImpl", "getAllFoldRegions"));
        }
        return foldRegionArray;
    }

    @Nullable
    public FoldRegion getCollapsedRegionAtOffset(int offset) {
        return this.myFoldTree.fetchOutermost(offset);
    }

    @Nullable
    public FoldRegion getFoldRegion(int startOffset, int endOffset) {
        FoldingModelImpl.assertReadAccess();
        return this.myFoldTree.getRegionAt(startOffset, endOffset);
    }

    @Override
    @Nullable
    public FoldRegion getFoldingPlaceholderAt(Point p) {
        FoldingModelImpl.assertReadAccess();
        LogicalPosition pos = this.myEditor.xyToLogicalPosition(p);
        int line = pos.line;
        if (line >= this.myEditor.getDocument().getLineCount()) {
            return null;
        }
        int offset = this.myEditor.logicalPositionToOffset(pos);
        return this.myFoldTree.fetchOutermost(offset);
    }

    public void removeFoldRegion(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/openapi/editor/impl/FoldingModelImpl", "removeFoldRegion"));
        }
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
        }
        region.setExpanded(true);
        FoldingGroup group = region.getGroup();
        if (group != null) {
            this.myGroups.remove((Object)group, (Object)region);
        }
        this.myFoldTree.removeRegion(region);
        this.myFoldRegionsProcessed = true;
        region.dispose();
    }

    public void dispose() {
        this.doClearFoldRegions();
    }

    @Override
    public void clearFoldRegions() {
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
            return;
        }
        if (this.myEditor.myUseNewRendering) {
            FoldRegion[] regions;
            for (FoldRegion region : regions = this.getAllFoldRegions()) {
                if (region.isExpanded()) continue;
                this.notifyListenersOnFoldRegionStateChange(region);
                this.myFoldRegionsProcessed = true;
            }
        }
        this.doClearFoldRegions();
    }

    public void doClearFoldRegions() {
        this.myGroups.clear();
        this.myFoldTree.clear();
    }

    public void expandFoldRegion(FoldRegion region) {
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        if (region.isExpanded() || region.shouldNeverExpand()) {
            return;
        }
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be collapsed or expanded inside batchFoldProcessing() only.");
        }
        for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
            int savedOffset;
            FoldRegion[] allCollapsed;
            LogicalPosition savedPosition = (LogicalPosition)caret.getUserData(SAVED_CARET_POSITION);
            if (savedPosition == null || (allCollapsed = this.myFoldTree.fetchCollapsedAt(savedOffset = this.myEditor.logicalPositionToOffset(savedPosition))).length != 1 || allCollapsed[0] != region) continue;
            caret.putUserData(MARK_FOR_UPDATE, (Object)Boolean.TRUE);
        }
        this.myFoldRegionsProcessed = true;
        this.myExpansionCounter.incrementAndGet();
        ((FoldRegionImpl)region).setExpandedInternal(true);
        this.notifyListenersOnFoldRegionStateChange(region);
    }

    public void collapseFoldRegion(FoldRegion region) {
        int caretOffset;
        LogicalPosition caretPosition;
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        if (!region.isExpanded()) {
            return;
        }
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be collapsed or expanded inside batchFoldProcessing() only.");
        }
        List<Caret> carets = this.myEditor.getCaretModel().getAllCarets();
        for (Caret caret : carets) {
            caretPosition = caret.getLogicalPosition();
            caretOffset = this.myEditor.logicalPositionToOffset(caretPosition);
            if (!FoldRegionsTree.contains(region, caretOffset) || !this.myDoNotCollapseCaret) continue;
            return;
        }
        for (Caret caret : carets) {
            caretPosition = caret.getLogicalPosition();
            caretOffset = this.myEditor.logicalPositionToOffset(caretPosition);
            if (!FoldRegionsTree.contains(region, caretOffset) || caret.getUserData(SAVED_CARET_POSITION) != null) continue;
            caret.putUserData(SAVED_CARET_POSITION, (Object)caretPosition.withoutVisualPositionInfo());
        }
        this.myFoldRegionsProcessed = true;
        ((FoldRegionImpl)region).setExpandedInternal(false);
        this.notifyListenersOnFoldRegionStateChange(region);
    }

    private void notifyBatchFoldingProcessingDone(boolean moveCaretFromCollapsedRegion) {
        this.rebuild();
        for (FoldingListener listener2 : this.myListeners) {
            listener2.onFoldProcessingEnd();
        }
        this.myEditor.updateCaretCursor();
        this.myEditor.recalculateSizeAndRepaint();
        this.myEditor.getGutterComponentEx().updateSize();
        this.myEditor.getGutterComponentEx().repaint();
        for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
            boolean markedForUpdate;
            LogicalPosition caretPosition = caret.getLogicalPosition().withoutVisualPositionInfo();
            int caretOffset = this.myEditor.logicalPositionToOffset(caretPosition);
            int selectionStart = caret.getSelectionStart();
            int selectionEnd = caret.getSelectionEnd();
            LogicalPosition positionToUse = null;
            int offsetToUse = -1;
            FoldRegion collapsed = this.myFoldTree.fetchOutermost(caretOffset);
            LogicalPosition savedPosition = (LogicalPosition)caret.getUserData(SAVED_CARET_POSITION);
            boolean bl = markedForUpdate = caret.getUserData(MARK_FOR_UPDATE) != null;
            if (savedPosition != null) {
                int savedOffset = this.myEditor.logicalPositionToOffset(savedPosition);
                FoldRegion collapsedAtSaved = this.myFoldTree.fetchOutermost(savedOffset);
                if (collapsedAtSaved == null) {
                    positionToUse = savedPosition;
                } else {
                    offsetToUse = collapsedAtSaved.getStartOffset();
                }
            }
            if (collapsed != null && positionToUse == null) {
                positionToUse = this.myEditor.offsetToLogicalPosition(collapsed.getStartOffset());
            }
            if ((markedForUpdate || moveCaretFromCollapsedRegion) && caret.isUpToDate()) {
                if (offsetToUse >= 0) {
                    caret.moveToOffset(offsetToUse);
                } else if (positionToUse != null) {
                    caret.moveToLogicalPosition(positionToUse);
                } else {
                    caret.moveToLogicalPosition(caretPosition);
                }
            }
            caret.putUserData(SAVED_CARET_POSITION, (Object)savedPosition);
            caret.putUserData(MARK_FOR_UPDATE, null);
            if (this.isOffsetInsideCollapsedRegion(selectionStart) || this.isOffsetInsideCollapsedRegion(selectionEnd)) {
                caret.removeSelection();
                continue;
            }
            if (selectionStart >= this.myEditor.getDocument().getTextLength()) continue;
            caret.setSelection(selectionStart, selectionEnd);
        }
        if (this.mySavedCaretShift > 0) {
            ScrollingModelEx scrollingModel = this.myEditor.getScrollingModel();
            scrollingModel.disableAnimation();
            scrollingModel.scrollVertically(this.myEditor.visibleLineToY(this.myEditor.getCaretModel().getVisualPosition().line) - this.mySavedCaretShift);
            scrollingModel.enableAnimation();
        }
    }

    @Override
    public void rebuild() {
        if (!this.myEditor.getDocument().isInBulkUpdate()) {
            this.myFoldTree.rebuild();
        }
    }

    public boolean isInBatchFoldingOperation() {
        return this.myIsBatchFoldingProcessing;
    }

    private void updateCachedOffsets() {
        this.myFoldTree.updateCachedOffsets();
    }

    public int getFoldedLinesCountBefore(int offset) {
        if (!this.myDocumentChangeProcessed && this.myEditor.getDocument().isInEventsHandling()) {
            return 0;
        }
        return this.myFoldTree.getFoldedLinesCountBefore(offset);
    }

    @Override
    @Nullable
    public FoldRegion[] fetchTopLevel() {
        return this.myFoldTree.fetchTopLevel();
    }

    public FoldRegion[] fetchCollapsedAt(int offset) {
        return this.myFoldTree.fetchCollapsedAt(offset);
    }

    @Override
    public boolean intersectsRegion(int startOffset, int endOffset) {
        return this.myFoldTree.intersectsRegion(startOffset, endOffset);
    }

    public FoldRegion[] fetchVisible() {
        return this.myFoldTree.fetchVisible();
    }

    @Override
    public int getLastCollapsedRegionBefore(int offset) {
        return this.myFoldTree.getLastTopLevelIndexBefore(offset);
    }

    @Override
    public TextAttributes getPlaceholderAttributes() {
        return this.myFoldTextAttributes;
    }

    public void flushCaretPosition() {
        for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
            caret.putUserData(SAVED_CARET_POSITION, null);
        }
    }

    void onBulkDocumentUpdateStarted() {
        this.myFoldTree.clearCachedValues();
    }

    void onBulkDocumentUpdateFinished() {
        this.myFoldTree.rebuild();
    }

    public void beforeDocumentChange(DocumentEvent event) {
        this.myDocumentChangeProcessed = false;
    }

    public void documentChanged(DocumentEvent event) {
        try {
            if (!((DocumentEx)event.getDocument()).isInBulkUpdate()) {
                this.updateCachedOffsets();
            }
        }
        finally {
            this.myDocumentChangeProcessed = true;
        }
    }

    @Override
    public void moveTextHappened(int start, int end, int base) {
        if (!this.myEditor.getDocument().isInBulkUpdate()) {
            this.myFoldTree.rebuild();
        }
    }

    @Override
    public int getPriority() {
        return 60;
    }

    @Override
    public FoldRegion createFoldRegion(int startOffset, int endOffset, @NotNull String placeholder, @Nullable FoldingGroup group, boolean neverExpands) {
        if (placeholder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeholder", "com/intellij/openapi/editor/impl/FoldingModelImpl", "createFoldRegion"));
        }
        FoldRegionImpl region = new FoldRegionImpl(this.myEditor, startOffset, endOffset, placeholder, group, neverExpands);
        LOG.assertTrue(region.isValid());
        return region;
    }

    @Override
    public void addListener(final @NotNull FoldingListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/FoldingModelImpl", "addListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/FoldingModelImpl", "addListener"));
        }
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                FoldingModelImpl.this.myListeners.remove(listener2);
            }
        });
    }

    private void notifyListenersOnFoldRegionStateChange(@NotNull FoldRegion foldRegion) {
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldRegion", "com/intellij/openapi/editor/impl/FoldingModelImpl", "notifyListenersOnFoldRegionStateChange"));
        }
        for (FoldingListener listener2 : this.myListeners) {
            listener2.onFoldRegionStateChange(foldRegion);
        }
    }

    @NotNull
    public String dumpState() {
        String string = Arrays.toString(this.myFoldTree.fetchTopLevel());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FoldingModelImpl", "dumpState"));
        }
        return string;
    }

    public String toString() {
        return this.dumpState();
    }

    public long getModificationCount() {
        return this.myExpansionCounter.get();
    }
}

