/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.mapping.CachingSoftWrapDataMapper;
import org.jetbrains.annotations.NotNull;

public class IncrementalCacheUpdateEvent {
    private static Logger LOG = Logger.getInstance(IncrementalCacheUpdateEvent.class);
    private final int myStartOffset;
    private final int myMandatoryEndOffset;
    private int myActualEndOffset;
    private final int myLengthDiff;
    @NotNull
    private final LogicalPosition myStartLogicalPosition;
    @NotNull
    private final VisualPosition myStartVisualPosition;
    private final int myOldEndLogicalLine;
    private int myNewEndLogicalLine;

    IncrementalCacheUpdateEvent(@NotNull DocumentEvent event, @NotNull CachingSoftWrapDataMapper mapper, @NotNull EditorImpl editor) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        this(event.getOffset(), event.getOffset() + event.getOldLength(), event.getOffset() + event.getNewLength(), mapper, editor);
    }

    IncrementalCacheUpdateEvent(int startOffset, int endOffset, @NotNull CachingSoftWrapDataMapper mapper, @NotNull EditorImpl editor) {
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        this(startOffset, endOffset, endOffset, mapper, editor);
        this.myNewEndLogicalLine = this.myOldEndLogicalLine;
    }

    IncrementalCacheUpdateEvent(@NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        this.myActualEndOffset = -1;
        this.myNewEndLogicalLine = -1;
        this.myStartOffset = 0;
        this.myMandatoryEndOffset = document2.getTextLength();
        this.myLengthDiff = 0;
        this.myStartLogicalPosition = new LogicalPosition(0, 0, 0, 0, 0, 0, 0);
        this.myStartVisualPosition = new VisualPosition(0, 0);
        this.myOldEndLogicalLine = this.myNewEndLogicalLine = Math.max(0, document2.getLineCount() - 1);
    }

    private IncrementalCacheUpdateEvent(int startOffset, int oldEndOffset, int newEndOffset, @NotNull CachingSoftWrapDataMapper mapper, @NotNull EditorImpl editor) {
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        this.myActualEndOffset = -1;
        this.myNewEndLogicalLine = -1;
        if (editor.myUseNewRendering) {
            VisualLineInfo info = IncrementalCacheUpdateEvent.getVisualLineInfo(editor, startOffset, false);
            if (info.startsWithSoftWrap) {
                info = IncrementalCacheUpdateEvent.getVisualLineInfo(editor, info.startOffset, true);
            }
            this.myStartOffset = info.startOffset;
            this.myStartLogicalPosition = editor.offsetToLogicalPosition(this.myStartOffset);
            this.myStartVisualPosition = new VisualPosition(info.visualLine, 0);
        } else {
            this.myStartOffset = mapper.getPreviousVisualLineStartOffset(startOffset);
            this.myStartLogicalPosition = mapper.offsetToLogicalPosition(this.myStartOffset);
            LOG.assertTrue(this.myStartLogicalPosition.visualPositionAware);
            this.myStartVisualPosition = this.myStartLogicalPosition.toVisualPosition();
        }
        this.myMandatoryEndOffset = newEndOffset;
        this.myLengthDiff = newEndOffset - oldEndOffset;
        this.myOldEndLogicalLine = editor.getDocument().getLineNumber(oldEndOffset);
    }

    private static VisualLineInfo getVisualLineInfo(@NotNull EditorImpl editor, int offset, boolean beforeSoftWrap) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "getVisualLineInfo"));
        }
        DocumentEx document2 = editor.getDocument();
        int textLength = document2.getTextLength();
        if (offset <= 0 || textLength == 0) {
            return new VisualLineInfo(0, 0, false);
        }
        offset = Math.min(offset, textLength);
        int startOffset = EditorUtil.getNotFoldedLineStartOffset(editor, offset);
        SoftWrapModelImpl softWrapModel = editor.getSoftWrapModel();
        int wrapIndex = softWrapModel.getSoftWrapIndex(offset);
        int prevSoftWrapIndex = wrapIndex < 0 ? -wrapIndex - 2 : wrapIndex - (beforeSoftWrap ? 1 : 0);
        SoftWrap prevSoftWrap = prevSoftWrapIndex < 0 ? null : softWrapModel.getRegisteredSoftWraps().get(prevSoftWrapIndex);
        int visualLine = document2.getLineNumber(offset) - editor.getFoldingModel().getFoldedLinesCountBefore(offset) + (prevSoftWrapIndex + 1);
        int visualLineStartOffset = prevSoftWrap == null ? startOffset : Math.max(startOffset, prevSoftWrap.getStart());
        return new VisualLineInfo(visualLine, visualLineStartOffset, prevSoftWrap != null && prevSoftWrap.getStart() == visualLineStartOffset);
    }

    public void updateAfterDocumentChange(@NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "updateAfterDocumentChange"));
        }
        this.myNewEndLogicalLine = document2.getLineNumber(this.myMandatoryEndOffset);
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    @NotNull
    public LogicalPosition getStartLogicalPosition() {
        LogicalPosition logicalPosition = this.myStartLogicalPosition;
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "getStartLogicalPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getStartVisualPosition() {
        VisualPosition visualPosition = this.myStartVisualPosition;
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "getStartVisualPosition"));
        }
        return visualPosition;
    }

    public int getMandatoryEndOffset() {
        return this.myMandatoryEndOffset;
    }

    public int getActualEndOffset() {
        return this.myActualEndOffset;
    }

    void setActualEndOffset(int actualEndOffset) {
        this.myActualEndOffset = actualEndOffset;
    }

    public int getLengthDiff() {
        return this.myLengthDiff;
    }

    public int getLogicalLinesDiff() {
        return this.myNewEndLogicalLine - this.myOldEndLogicalLine;
    }

    public int getStartLogicalLine() {
        return this.myStartLogicalPosition.line;
    }

    public int getOldEndLogicalLine() {
        return this.myOldEndLogicalLine;
    }

    public String toString() {
        return "startOffset=" + this.myStartOffset + ", mandatoryEndOffset=" + this.myMandatoryEndOffset + ", actualEndOffset=" + this.myActualEndOffset + ", lengthDiff=" + this.myLengthDiff + ", startLogicalPosition=" + this.myStartLogicalPosition + ", oldEndLogicalLine=" + this.myOldEndLogicalLine + ", newEndLogicalLine=" + this.myNewEndLogicalLine;
    }

    private static class VisualLineInfo {
        private final int visualLine;
        private final int startOffset;
        private final boolean startsWithSoftWrap;

        private VisualLineInfo(int visualLine, int startOffset, boolean wrap) {
            this.visualLine = visualLine;
            this.startOffset = startOffset;
            this.startsWithSoftWrap = wrap;
        }
    }
}

