/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.AbstractMappingStrategy;
import com.intellij.openapi.editor.impl.softwrap.mapping.CacheEntry;
import com.intellij.openapi.editor.impl.softwrap.mapping.EditorPosition;
import com.intellij.openapi.editor.impl.softwrap.mapping.MappingUtil;
import com.intellij.openapi.editor.impl.softwrap.mapping.TabData;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LogicalToOffsetCalculationStrategy
extends AbstractMappingStrategy<Integer> {
    private LogicalPosition targetPosition;

    LogicalToOffsetCalculationStrategy(@NotNull EditorEx editor, @NotNull SoftWrapsStorage storage2, @NotNull List<CacheEntry> cache) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToOffsetCalculationStrategy", "<init>"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToOffsetCalculationStrategy", "<init>"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToOffsetCalculationStrategy", "<init>"));
        }
        super(editor, storage2, cache);
    }

    void init(LogicalPosition logical) {
        CacheEntry entry = MappingUtil.getCacheEntryForLogicalPosition(logical, this.myCache);
        if (entry == null) {
            if (logical.line >= this.myEditor.getDocument().getLineCount()) {
                this.setEagerMatch(this.myEditor.getDocument().getTextLength());
            } else {
                this.setEagerMatch(Math.min(this.myEditor.getDocument().getLineStartOffset(logical.line) + logical.column, this.myEditor.getDocument().getLineEndOffset(logical.line)));
            }
            return;
        }
        if (entry.endLogicalLine == logical.line && entry.endLogicalColumn <= logical.column) {
            this.setEagerMatch(entry.endOffset);
            return;
        }
        this.reset();
        this.targetPosition = logical;
        this.setTargetEntry(entry, true);
    }

    @Override
    @Nullable
    protected Integer buildIfExceeds(EditorPosition position, int offset) {
        if (position.logicalLine != this.targetPosition.line) {
            return null;
        }
        int result2 = position.offset + this.targetPosition.column - position.logicalColumn;
        return result2 > offset ? null : Integer.valueOf(result2);
    }

    @Override
    public Integer processFoldRegion(@NotNull EditorPosition position, @NotNull FoldRegion foldRegion) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToOffsetCalculationStrategy", "processFoldRegion"));
        }
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldRegion", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToOffsetCalculationStrategy", "processFoldRegion"));
        }
        int startLine = position.logicalLine;
        int startColumn = position.logicalColumn;
        int startX = position.x;
        this.advancePositionOnFolding(position, foldRegion);
        if (position.logicalLine < this.targetPosition.line || position.logicalLine == this.targetPosition.line && position.logicalColumn <= this.targetPosition.column) {
            return null;
        }
        DocumentEx document2 = this.myEditor.getDocument();
        int lineEndOffset = document2.getLineEndOffset(this.targetPosition.line);
        int result2 = SoftWrapModelImpl.getEditorTextRepresentationHelper(this.myEditor).calcSoftWrapUnawareOffset(this.targetPosition.line == startLine ? foldRegion.getStartOffset() : document2.getLineStartOffset(this.targetPosition.line), lineEndOffset, this.targetPosition.line == startLine ? startColumn : 0, this.targetPosition.column, this.targetPosition.line == startLine ? startX : 0);
        return result2 < 0 ? lineEndOffset : result2;
    }

    @Override
    @Nullable
    protected Integer buildIfExceeds(@NotNull EditorPosition position, @NotNull FoldRegion foldRegion) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToOffsetCalculationStrategy", "buildIfExceeds"));
        }
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldRegion", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToOffsetCalculationStrategy", "buildIfExceeds"));
        }
        throw new RuntimeException("Unexpected invocation");
    }

    @Override
    @Nullable
    protected Integer buildIfExceeds(EditorPosition position, TabData tabData) {
        if (position.logicalLine != this.targetPosition.line) {
            return null;
        }
        return position.logicalColumn + tabData.widthInColumns > this.targetPosition.column ? Integer.valueOf(position.offset) : null;
    }

    @Override
    @Nullable
    public Integer processSoftWrap(@NotNull EditorPosition position, SoftWrap softWrap) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToOffsetCalculationStrategy", "processSoftWrap"));
        }
        return null;
    }

    @Override
    @NotNull
    public Integer build(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToOffsetCalculationStrategy", "build"));
        }
        Integer n = position.offset + this.targetPosition.column - position.logicalColumn;
        if (n == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/LogicalToOffsetCalculationStrategy", "build"));
        }
        return n;
    }
}

