/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.execution.rmi.RemoteServer;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemService;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolverImpl;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManagerImpl;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemFacadeImpl<S extends ExternalSystemExecutionSettings>
extends RemoteServer
implements RemoteExternalSystemFacade<S> {
    private final ConcurrentMap<Class<?>, RemoteExternalSystemService<S>> myRemotes;
    private final AtomicReference<S> mySettings;
    private final AtomicReference<ExternalSystemTaskNotificationListener> myNotificationListener;
    @NotNull
    private final RemoteExternalSystemProjectResolverImpl<S> myProjectResolver;
    @NotNull
    private final RemoteExternalSystemTaskManagerImpl<S> myTaskManager;

    public AbstractExternalSystemFacadeImpl(@NotNull Class<ExternalSystemProjectResolver<S>> projectResolverClass, @NotNull Class<ExternalSystemTaskManager<S>> buildManagerClass) throws IllegalAccessException, InstantiationException {
        if (projectResolverClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectResolverClass", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl", "<init>"));
        }
        if (buildManagerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildManagerClass", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl", "<init>"));
        }
        this.myRemotes = ContainerUtil.newConcurrentMap();
        this.mySettings = new AtomicReference();
        this.myNotificationListener = new AtomicReference<1>(new ExternalSystemTaskNotificationListenerAdapter(){});
        this.myProjectResolver = new RemoteExternalSystemProjectResolverImpl<S>(projectResolverClass.newInstance());
        this.myTaskManager = new RemoteExternalSystemTaskManagerImpl<S>(buildManagerClass.newInstance());
    }

    protected void init() throws RemoteException {
        this.applyProgressManager(RemoteExternalSystemProgressNotificationManager.NULL_OBJECT);
    }

    @Nullable
    protected S getSettings() {
        return (S)((ExternalSystemExecutionSettings)this.mySettings.get());
    }

    @NotNull
    protected ExternalSystemTaskNotificationListener getNotificationListener() {
        ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener = this.myNotificationListener.get();
        if (externalSystemTaskNotificationListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl", "getNotificationListener"));
        }
        return externalSystemTaskNotificationListener;
    }

    @Override
    @NotNull
    public RemoteExternalSystemProjectResolver<S> getResolver() throws RemoteException, IllegalStateException {
        RemoteExternalSystemProjectResolver remoteExternalSystemProjectResolver;
        try {
            remoteExternalSystemProjectResolver = this.getService(RemoteExternalSystemProjectResolver.class, this.myProjectResolver);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't create '%s' service", RemoteExternalSystemProjectResolverImpl.class.getName()), e);
        }
        if (remoteExternalSystemProjectResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl", "getResolver"));
        }
        return remoteExternalSystemProjectResolver;
    }

    @Override
    @NotNull
    public RemoteExternalSystemTaskManager<S> getTaskManager() throws RemoteException {
        RemoteExternalSystemTaskManager remoteExternalSystemTaskManager;
        try {
            remoteExternalSystemTaskManager = this.getService(RemoteExternalSystemTaskManager.class, this.myTaskManager);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't create '%s' service", ExternalSystemTaskManager.class.getName()), e);
        }
        if (remoteExternalSystemTaskManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl", "getTaskManager"));
        }
        return remoteExternalSystemTaskManager;
    }

    private <I extends RemoteExternalSystemService<S>, C extends I> I getService(@NotNull Class<I> interfaceClass, @NotNull C impl) throws ClassNotFoundException, IllegalAccessException, InstantiationException, RemoteException {
        if (interfaceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceClass", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl", "getService"));
        }
        if (impl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "impl", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl", "getService"));
        }
        Object cachedResult = this.myRemotes.get(interfaceClass);
        if (cachedResult != null) {
            return (I)((RemoteExternalSystemService)cachedResult);
        }
        S settings = this.getSettings();
        if (settings != null) {
            impl.setNotificationListener(this.getNotificationListener());
            impl.setSettings(settings);
        }
        impl.setNotificationListener(this.getNotificationListener());
        try {
            I created = this.createService(interfaceClass, impl);
            RemoteExternalSystemService<S> stored = this.myRemotes.putIfAbsent(interfaceClass, (RemoteExternalSystemService<S>)created);
            return (I)(stored == null ? created : stored);
        }
        catch (RemoteException e) {
            Object raceResult = this.myRemotes.get(interfaceClass);
            if (raceResult != null) {
                return (I)((RemoteExternalSystemService)raceResult);
            }
            throw new IllegalStateException(String.format("Can't prepare remote service for interface '%s', implementation '%s'", interfaceClass, impl), e);
        }
    }

    protected abstract <I extends RemoteExternalSystemService<S>, C extends I> I createService(@NotNull Class<I> var1, @NotNull C var2) throws ClassNotFoundException, IllegalAccessException, InstantiationException, RemoteException;

    @Override
    public boolean isTaskInProgress(@NotNull ExternalSystemTaskId id) throws RemoteException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl", "isTaskInProgress"));
        }
        for (RemoteExternalSystemService service : this.myRemotes.values()) {
            if (!service.isTaskInProgress(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> getTasksInProgress() throws RemoteException {
        Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> result2 = null;
        for (RemoteExternalSystemService service : this.myRemotes.values()) {
            Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> tasks = service.getTasksInProgress();
            if (tasks.isEmpty()) continue;
            if (result2 == null) {
                result2 = new HashMap<ExternalSystemTaskType, Set<ExternalSystemTaskId>>();
            }
            for (Map.Entry<ExternalSystemTaskType, Set<ExternalSystemTaskId>> entry : tasks.entrySet()) {
                Set<ExternalSystemTaskId> ids = result2.get(entry.getKey());
                if (ids == null) {
                    ids = new HashSet<ExternalSystemTaskId>();
                    result2.put(entry.getKey(), ids);
                }
                ids.addAll((Collection<ExternalSystemTaskId>)entry.getValue());
            }
        }
        if (result2 == null) {
            result2 = Collections.emptyMap();
        }
        Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> map = result2;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl", "getTasksInProgress"));
        }
        return map;
    }

    @Override
    public void applySettings(@NotNull S settings) throws RemoteException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl", "applySettings"));
        }
        this.mySettings.set(settings);
        ArrayList services = ContainerUtilRt.newArrayList(this.myRemotes.values());
        for (RemoteExternalSystemService service : services) {
            service.setSettings(settings);
        }
    }

    @Override
    public void applyProgressManager(@NotNull RemoteExternalSystemProgressNotificationManager progressManager) throws RemoteException {
        if (progressManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressManager", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl", "applyProgressManager"));
        }
        SwallowingNotificationListener listener2 = new SwallowingNotificationListener(progressManager);
        this.myNotificationListener.set(listener2);
        this.myProjectResolver.setNotificationListener(listener2);
        this.myTaskManager.setNotificationListener(listener2);
    }

    @Override
    public boolean cancelTask(@NotNull ExternalSystemTaskId id) throws RemoteException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl", "cancelTask"));
        }
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            return this.myProjectResolver.cancelTask(id);
        }
        return this.myTaskManager.cancelTask(id);
    }

    private static class SwallowingNotificationListener
    implements ExternalSystemTaskNotificationListener {
        @NotNull
        private final RemoteExternalSystemProgressNotificationManager myManager;

        SwallowingNotificationListener(@NotNull RemoteExternalSystemProgressNotificationManager manager) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl$SwallowingNotificationListener", "<init>"));
            }
            this.myManager = manager;
        }

        public void onQueued(@NotNull ExternalSystemTaskId id, String workingDir) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl$SwallowingNotificationListener", "onQueued"));
            }
        }

        public void onStart(@NotNull ExternalSystemTaskId id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl$SwallowingNotificationListener", "onStart"));
            }
            try {
                this.myManager.onStart(id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl$SwallowingNotificationListener", "onStatusChange"));
            }
            try {
                this.myManager.onStatusChange(event);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl$SwallowingNotificationListener", "onTaskOutput"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl$SwallowingNotificationListener", "onTaskOutput"));
            }
            try {
                this.myManager.onTaskOutput(id, text, stdOut);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void onEnd(@NotNull ExternalSystemTaskId id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl$SwallowingNotificationListener", "onEnd"));
            }
            try {
                this.myManager.onEnd(id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void onSuccess(@NotNull ExternalSystemTaskId id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl$SwallowingNotificationListener", "onSuccess"));
            }
            try {
                this.myManager.onSuccess(id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception ex) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl$SwallowingNotificationListener", "onFailure"));
            }
            if (ex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ex", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl$SwallowingNotificationListener", "onFailure"));
            }
            try {
                this.myManager.onFailure(id, ex);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void beforeCancel(@NotNull ExternalSystemTaskId id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl$SwallowingNotificationListener", "beforeCancel"));
            }
            try {
                this.myManager.beforeCancel(id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void onCancel(@NotNull ExternalSystemTaskId id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl$SwallowingNotificationListener", "onCancel"));
            }
            try {
                this.myManager.onCancel(id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

