/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.service.AbstractExternalSystemFacadeImpl;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemService;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class RemoteExternalSystemFacadeImpl<S extends ExternalSystemExecutionSettings>
extends AbstractExternalSystemFacadeImpl<S> {
    private static final long DEFAULT_REMOTE_PROCESS_TTL_IN_MS = TimeUnit.MILLISECONDS.convert(3L, TimeUnit.MINUTES);
    private final AtomicInteger myCallsInProgressNumber;
    private final Alarm myShutdownAlarm;
    private final AtomicLong myTtlMs;
    private volatile boolean myStdOutputConfigured;

    public RemoteExternalSystemFacadeImpl(@NotNull Class<ExternalSystemProjectResolver<S>> projectResolverClass, @NotNull Class<ExternalSystemTaskManager<S>> buildManagerClass) throws IllegalAccessException, InstantiationException {
        if (projectResolverClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectResolverClass", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemFacadeImpl", "<init>"));
        }
        if (buildManagerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildManagerClass", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemFacadeImpl", "<init>"));
        }
        super(projectResolverClass, buildManagerClass);
        this.myCallsInProgressNumber = new AtomicInteger();
        this.myShutdownAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        this.myTtlMs = new AtomicLong(DEFAULT_REMOTE_PROCESS_TTL_IN_MS);
        this.updateAutoShutdownTime();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            throw new IllegalArgumentException("Can't create external system facade. Reason: given arguments don't contain information about external system resolver to use");
        }
        Class resolverClass = Class.forName(args[0]);
        if (!ExternalSystemProjectResolver.class.isAssignableFrom(resolverClass)) {
            throw new IllegalArgumentException(String.format("Can't create external system facade. Reason: given external system resolver class (%s) must be IS-A '%s'", resolverClass, ExternalSystemProjectResolver.class));
        }
        if (args.length < 2) {
            throw new IllegalArgumentException("Can't create external system facade. Reason: given arguments don't contain information about external system build manager to use");
        }
        Class buildManagerClass = Class.forName(args[1]);
        if (!ExternalSystemProjectResolver.class.isAssignableFrom(resolverClass)) {
            throw new IllegalArgumentException(String.format("Can't create external system facade. Reason: given external system build manager (%s) must be IS-A '%s'", buildManagerClass, ExternalSystemTaskManager.class));
        }
        Registry.get((String)(System.getProperty("external.system.id") + ".system.in.process")).setValue(false);
        RemoteExternalSystemFacadeImpl facade = new RemoteExternalSystemFacadeImpl(resolverClass, buildManagerClass);
        facade.init();
        RemoteExternalSystemFacadeImpl.start(facade);
    }

    @Override
    protected <I extends RemoteExternalSystemService<S>, C extends I> I createService(@NotNull Class<I> interfaceClass, @NotNull C impl) throws ClassNotFoundException, IllegalAccessException, InstantiationException, RemoteException {
        if (interfaceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceClass", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemFacadeImpl", "createService"));
        }
        if (impl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "impl", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemFacadeImpl", "createService"));
        }
        if (!this.myStdOutputConfigured) {
            this.myStdOutputConfigured = true;
            System.setOut(new LineAwarePrintStream(System.out));
            System.setErr(new LineAwarePrintStream(System.err));
        }
        RemoteExternalSystemService proxy = (RemoteExternalSystemService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{interfaceClass}, new InvocationHandler((RemoteExternalSystemService)impl){
            final /* synthetic */ RemoteExternalSystemService val$impl;
            {
                this.val$impl = remoteExternalSystemService;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                RemoteExternalSystemFacadeImpl.this.myCallsInProgressNumber.incrementAndGet();
                try {
                    Object object = method.invoke((Object)this.val$impl, args);
                    return object;
                }
                finally {
                    RemoteExternalSystemFacadeImpl.this.myCallsInProgressNumber.decrementAndGet();
                    RemoteExternalSystemFacadeImpl.this.updateAutoShutdownTime();
                }
            }
        });
        return (I)((RemoteExternalSystemService)UnicastRemoteObject.exportObject((Remote)proxy, 0));
    }

    @Override
    public void applySettings(@NotNull S settings) throws RemoteException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemFacadeImpl", "applySettings"));
        }
        super.applySettings(settings);
        long ttl = settings.getRemoteProcessIdleTtlInMs();
        if (ttl > 0L) {
            this.myTtlMs.set(ttl);
        }
    }

    private void updateAutoShutdownTime() {
        this.myShutdownAlarm.cancelAllRequests();
        this.myShutdownAlarm.addRequest(() -> {
            if (this.myCallsInProgressNumber.get() > 0) {
                this.updateAutoShutdownTime();
                return;
            }
            System.exit(0);
        }, (int)this.myTtlMs.get());
    }

    private static class LineAwarePrintStream
    extends PrintStream {
        private LineAwarePrintStream(final @NotNull PrintStream delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemFacadeImpl$LineAwarePrintStream", "<init>"));
            }
            super(new OutputStream(){
                @NotNull
                private final StringBuilder myBuffer = new StringBuilder();

                @Override
                public void write(int b) throws IOException {
                    char c = (char)b;
                    this.myBuffer.append(Character.toString(c));
                    if (c == '\n') {
                        this.doFlush();
                    }
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    int start = off;
                    int maxOffset = off + len;
                    for (int i = off; i < maxOffset; ++i) {
                        if (b[i] != 10) continue;
                        this.myBuffer.append(new String(b, start, i - start + 1));
                        this.doFlush();
                        start = i + 1;
                    }
                    if (start < maxOffset) {
                        this.myBuffer.append(new String(b, start, maxOffset - start));
                    }
                }

                private void doFlush() {
                    delegate.print(this.myBuffer.toString());
                    delegate.flush();
                    this.myBuffer.setLength(0);
                }
            });
        }
    }
}

