/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.remote;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.remote.AbstractRemoteExternalSystemService;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteExternalSystemProjectResolverImpl<S extends ExternalSystemExecutionSettings>
extends AbstractRemoteExternalSystemService<S>
implements RemoteExternalSystemProjectResolver<S> {
    private final ExternalSystemProjectResolver<S> myDelegate;

    public RemoteExternalSystemProjectResolverImpl(@NotNull ExternalSystemProjectResolver<S> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemProjectResolverImpl", "<init>"));
        }
        this.myDelegate = delegate;
    }

    @Override
    @Nullable
    public DataNode<ProjectData> resolveProjectInfo(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, boolean isPreviewMode, S settings) throws ExternalSystemException, IllegalArgumentException, IllegalStateException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemProjectResolverImpl", "resolveProjectInfo"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemProjectResolverImpl", "resolveProjectInfo"));
        }
        return (DataNode)this.execute(id, () -> {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemProjectResolverImpl", "lambda$resolveProjectInfo$0"));
            }
            if (projectPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemProjectResolverImpl", "lambda$resolveProjectInfo$0"));
            }
            return this.myDelegate.resolveProjectInfo(id, projectPath, isPreviewMode, settings, this.getNotificationListener());
        });
    }

    @Override
    public boolean cancelTask(@NotNull ExternalSystemTaskId id) throws ExternalSystemException, IllegalArgumentException, IllegalStateException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemProjectResolverImpl", "cancelTask"));
        }
        return this.myDelegate.cancelTask(id, this.getNotificationListener());
    }
}

